/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.AccessPointDescription;
import software.amazon.awssdk.services.efs.model.AccessPointDescriptionsCopier;
import software.amazon.awssdk.services.efs.model.EfsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccessPointsResponse
extends EfsResponse
implements ToCopyableBuilder<Builder, DescribeAccessPointsResponse> {
    private static final SdkField<List<AccessPointDescription>> ACCESS_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeAccessPointsResponse.getter(DescribeAccessPointsResponse::accessPoints)).setter(DescribeAccessPointsResponse.setter(Builder::accessPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessPointDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAccessPointsResponse.getter(DescribeAccessPointsResponse::nextToken)).setter(DescribeAccessPointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AccessPointDescription> accessPoints;
    private final String nextToken;

    private DescribeAccessPointsResponse(BuilderImpl builder) {
        super(builder);
        this.accessPoints = builder.accessPoints;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAccessPoints() {
        return this.accessPoints != null && !(this.accessPoints instanceof SdkAutoConstructList);
    }

    public List<AccessPointDescription> accessPoints() {
        return this.accessPoints;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccessPointsResponse)) {
            return false;
        }
        DescribeAccessPointsResponse other = (DescribeAccessPointsResponse)((Object)obj);
        return Objects.equals(this.accessPoints(), other.accessPoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAccessPointsResponse").add("AccessPoints", this.accessPoints()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessPoints": {
                return Optional.ofNullable(clazz.cast(this.accessPoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccessPointsResponse, T> g) {
        return obj -> g.apply((DescribeAccessPointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsResponse.BuilderImpl
    implements Builder {
        private List<AccessPointDescription> accessPoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccessPointsResponse model) {
            super(model);
            this.accessPoints(model.accessPoints);
            this.nextToken(model.nextToken);
        }

        public final Collection<AccessPointDescription.Builder> getAccessPoints() {
            return this.accessPoints != null ? (Collection)this.accessPoints.stream().map(AccessPointDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessPoints(Collection<AccessPointDescription> accessPoints) {
            this.accessPoints = AccessPointDescriptionsCopier.copy(accessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(AccessPointDescription ... accessPoints) {
            this.accessPoints(Arrays.asList(accessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(Consumer<AccessPointDescription.Builder> ... accessPoints) {
            this.accessPoints(Stream.of(accessPoints).map(c -> (AccessPointDescription)((AccessPointDescription.Builder)AccessPointDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessPoints(Collection<AccessPointDescription.BuilderImpl> accessPoints) {
            this.accessPoints = AccessPointDescriptionsCopier.copyFromBuilder(accessPoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAccessPointsResponse build() {
            return new DescribeAccessPointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EfsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccessPointsResponse> {
        public Builder accessPoints(Collection<AccessPointDescription> var1);

        public Builder accessPoints(AccessPointDescription ... var1);

        public Builder accessPoints(Consumer<AccessPointDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

