/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.efs.model.EFSResponse;
import software.amazon.awssdk.services.efs.model.LifeCycleState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateMountTargetResponse
extends EFSResponse
implements ToCopyableBuilder<Builder, CreateMountTargetResponse> {
    private final String ownerId;
    private final String mountTargetId;
    private final String fileSystemId;
    private final String subnetId;
    private final String lifeCycleState;
    private final String ipAddress;
    private final String networkInterfaceId;

    private CreateMountTargetResponse(BuilderImpl builder) {
        super(builder);
        this.ownerId = builder.ownerId;
        this.mountTargetId = builder.mountTargetId;
        this.fileSystemId = builder.fileSystemId;
        this.subnetId = builder.subnetId;
        this.lifeCycleState = builder.lifeCycleState;
        this.ipAddress = builder.ipAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String mountTargetId() {
        return this.mountTargetId;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(this.lifeCycleState);
    }

    public String lifeCycleStateString() {
        return this.lifeCycleState;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycleStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMountTargetResponse)) {
            return false;
        }
        CreateMountTargetResponse other = (CreateMountTargetResponse)((Object)obj);
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.mountTargetId(), other.mountTargetId()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.lifeCycleStateString(), other.lifeCycleStateString()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId());
    }

    public String toString() {
        return ToString.builder((String)"CreateMountTargetResponse").add("OwnerId", (Object)this.ownerId()).add("MountTargetId", (Object)this.mountTargetId()).add("FileSystemId", (Object)this.fileSystemId()).add("SubnetId", (Object)this.subnetId()).add("LifeCycleState", (Object)this.lifeCycleStateString()).add("IpAddress", (Object)this.ipAddress()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.of(clazz.cast(this.ownerId()));
            }
            case "MountTargetId": {
                return Optional.of(clazz.cast(this.mountTargetId()));
            }
            case "FileSystemId": {
                return Optional.of(clazz.cast(this.fileSystemId()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "LifeCycleState": {
                return Optional.of(clazz.cast(this.lifeCycleStateString()));
            }
            case "IpAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EFSResponse.BuilderImpl
    implements Builder {
        private String ownerId;
        private String mountTargetId;
        private String fileSystemId;
        private String subnetId;
        private String lifeCycleState;
        private String ipAddress;
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMountTargetResponse model) {
            this.ownerId(model.ownerId);
            this.mountTargetId(model.mountTargetId);
            this.fileSystemId(model.fileSystemId);
            this.subnetId(model.subnetId);
            this.lifeCycleState(model.lifeCycleState);
            this.ipAddress(model.ipAddress);
            this.networkInterfaceId(model.networkInterfaceId);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getMountTargetId() {
            return this.mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getLifeCycleState() {
            return this.lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState.toString());
            return this;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public CreateMountTargetResponse build() {
            return new CreateMountTargetResponse(this);
        }
    }

    public static interface Builder
    extends EFSResponse.Builder,
    CopyableBuilder<Builder, CreateMountTargetResponse> {
        public Builder ownerId(String var1);

        public Builder mountTargetId(String var1);

        public Builder fileSystemId(String var1);

        public Builder subnetId(String var1);

        public Builder lifeCycleState(String var1);

        public Builder lifeCycleState(LifeCycleState var1);

        public Builder ipAddress(String var1);

        public Builder networkInterfaceId(String var1);
    }
}

