/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.CreateFileSystemRequest;

@SdkInternalApi
public class CreateFileSystemRequestModelMarshaller {
    private static final MarshallingInfo<String> CREATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationToken").build();
    private static final MarshallingInfo<String> PERFORMANCEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PerformanceMode").build();
    private static final MarshallingInfo<Boolean> ENCRYPTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encrypted").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final CreateFileSystemRequestModelMarshaller INSTANCE = new CreateFileSystemRequestModelMarshaller();

    public static CreateFileSystemRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateFileSystemRequest createFileSystemRequest, ProtocolMarshaller protocolMarshaller) {
        if (createFileSystemRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createFileSystemRequest.creationToken(), CREATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createFileSystemRequest.performanceModeString(), PERFORMANCEMODE_BINDING);
            protocolMarshaller.marshall((Object)createFileSystemRequest.encrypted(), ENCRYPTED_BINDING);
            protocolMarshaller.marshall((Object)createFileSystemRequest.kmsKeyId(), KMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

