/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.efs.model.EFSRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteFileSystemRequest
extends EFSRequest
implements ToCopyableBuilder<Builder, DeleteFileSystemRequest> {
    private final String fileSystemId;

    private DeleteFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemRequest)) {
            return false;
        }
        DeleteFileSystemRequest other = (DeleteFileSystemRequest)((Object)obj);
        return Objects.equals(this.fileSystemId(), other.fileSystemId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.fileSystemId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.of(clazz.cast(this.fileSystemId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EFSRequest.BuilderImpl
    implements Builder {
        private String fileSystemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemRequest model) {
            this.fileSystemId(model.fileSystemId);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteFileSystemRequest build() {
            return new DeleteFileSystemRequest(this);
        }
    }

    public static interface Builder
    extends EFSRequest.Builder,
    CopyableBuilder<Builder, DeleteFileSystemRequest> {
        public Builder fileSystemId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

