/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs;

import java.util.function.Consumer;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.efs.DefaultEFSClientBuilder;
import software.amazon.awssdk.services.efs.EFSClientBuilder;
import software.amazon.awssdk.services.efs.model.BadRequestException;
import software.amazon.awssdk.services.efs.model.CreateFileSystemRequest;
import software.amazon.awssdk.services.efs.model.CreateFileSystemResponse;
import software.amazon.awssdk.services.efs.model.CreateMountTargetRequest;
import software.amazon.awssdk.services.efs.model.CreateMountTargetResponse;
import software.amazon.awssdk.services.efs.model.CreateTagsRequest;
import software.amazon.awssdk.services.efs.model.CreateTagsResponse;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemRequest;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemResponse;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetRequest;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetResponse;
import software.amazon.awssdk.services.efs.model.DeleteTagsRequest;
import software.amazon.awssdk.services.efs.model.DeleteTagsResponse;
import software.amazon.awssdk.services.efs.model.DependencyTimeoutException;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse;
import software.amazon.awssdk.services.efs.model.DescribeTagsRequest;
import software.amazon.awssdk.services.efs.model.DescribeTagsResponse;
import software.amazon.awssdk.services.efs.model.EFSException;
import software.amazon.awssdk.services.efs.model.FileSystemAlreadyExistsException;
import software.amazon.awssdk.services.efs.model.FileSystemInUseException;
import software.amazon.awssdk.services.efs.model.FileSystemLimitExceededException;
import software.amazon.awssdk.services.efs.model.FileSystemNotFoundException;
import software.amazon.awssdk.services.efs.model.IncorrectFileSystemLifeCycleStateException;
import software.amazon.awssdk.services.efs.model.IncorrectMountTargetStateException;
import software.amazon.awssdk.services.efs.model.InternalServerErrorException;
import software.amazon.awssdk.services.efs.model.IpAddressInUseException;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.MountTargetConflictException;
import software.amazon.awssdk.services.efs.model.MountTargetNotFoundException;
import software.amazon.awssdk.services.efs.model.NetworkInterfaceLimitExceededException;
import software.amazon.awssdk.services.efs.model.NoFreeAddressesInSubnetException;
import software.amazon.awssdk.services.efs.model.SecurityGroupLimitExceededException;
import software.amazon.awssdk.services.efs.model.SecurityGroupNotFoundException;
import software.amazon.awssdk.services.efs.model.SubnetNotFoundException;
import software.amazon.awssdk.services.efs.model.UnsupportedAvailabilityZoneException;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface EFSClient
extends SdkAutoCloseable {
    public static final String SERVICE_NAME = "elasticfilesystem";

    public static EFSClient create() {
        return (EFSClient)EFSClient.builder().build();
    }

    public static EFSClientBuilder builder() {
        return new DefaultEFSClientBuilder();
    }

    default public CreateFileSystemResponse createFileSystem(CreateFileSystemRequest createFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemAlreadyExistsException, FileSystemLimitExceededException, SdkServiceException, SdkClientException, EFSException {
        throw new UnsupportedOperationException();
    }

    default public CreateFileSystemResponse createFileSystem(Consumer<CreateFileSystemRequest.Builder> createFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemAlreadyExistsException, FileSystemLimitExceededException, SdkServiceException, SdkClientException, EFSException {
        return this.createFileSystem((CreateFileSystemRequest)((Object)((CreateFileSystemRequest.Builder)CreateFileSystemRequest.builder().apply(createFileSystemRequest)).build()));
    }

    default public CreateMountTargetResponse createMountTarget(CreateMountTargetRequest createMountTargetRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, MountTargetConflictException, SubnetNotFoundException, NoFreeAddressesInSubnetException, IpAddressInUseException, NetworkInterfaceLimitExceededException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, UnsupportedAvailabilityZoneException, SdkServiceException, SdkClientException, EFSException {
        throw new UnsupportedOperationException();
    }

    default public CreateMountTargetResponse createMountTarget(Consumer<CreateMountTargetRequest.Builder> createMountTargetRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, MountTargetConflictException, SubnetNotFoundException, NoFreeAddressesInSubnetException, IpAddressInUseException, NetworkInterfaceLimitExceededException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, UnsupportedAvailabilityZoneException, SdkServiceException, SdkClientException, EFSException {
        return this.createMountTarget((CreateMountTargetRequest)((Object)((CreateMountTargetRequest.Builder)CreateMountTargetRequest.builder().apply(createMountTargetRequest)).build()));
    }

    default public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkServiceException, SdkClientException, EFSException {
        throw new UnsupportedOperationException();
    }

    default public CreateTagsResponse createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkServiceException, SdkClientException, EFSException {
        return this.createTags((CreateTagsRequest)((Object)((CreateTagsRequest.Builder)CreateTagsRequest.builder().apply(createTagsRequest)).build()));
    }

    default public DeleteFileSystemResponse deleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, FileSystemInUseException, SdkServiceException, SdkClientException, EFSException {
        throw new UnsupportedOperationException();
    }

    default public DeleteFileSystemResponse deleteFileSystem(Consumer<DeleteFileSystemRequest.Builder> deleteFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, FileSystemInUseException, SdkServiceException, SdkClientException, EFSException {
        return this.deleteFileSystem((DeleteFileSystemRequest)((Object)((DeleteFileSystemRequest.Builder)DeleteFileSystemRequest.builder().apply(deleteFileSystemRequest)).build()));
    }

    default public DeleteMountTargetResponse deleteMountTarget(DeleteMountTargetRequest deleteMountTargetRequest) throws BadRequestException, InternalServerErrorException, DependencyTimeoutException, MountTargetNotFoundException, SdkServiceException, SdkClientException, EFSException {
        throw new UnsupportedOperationException();
    }

    default public DeleteMountTargetResponse deleteMountTarget(Consumer<DeleteMountTargetRequest.Builder> deleteMountTargetRequest) throws BadRequestException, InternalServerErrorException, DependencyTimeoutException, MountTargetNotFoundException, SdkServiceException, SdkClientException, EFSException {
        return this.deleteMountTarget((DeleteMountTargetRequest)((Object)((DeleteMountTargetRequest.Builder)DeleteMountTargetRequest.builder().apply(deleteMountTargetRequest)).build()));
    }

    default public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkServiceException, SdkClientException, EFSException {
        throw new UnsupportedOperationException();
    }

    default public DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkServiceException, SdkClientException, EFSException {
        return this.deleteTags((DeleteTagsRequest)((Object)((DeleteTagsRequest.Builder)DeleteTagsRequest.builder().apply(deleteTagsRequest)).build()));
    }

    default public DescribeFileSystemsResponse describeFileSystems() throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkServiceException, SdkClientException, EFSException {
        return this.describeFileSystems((DescribeFileSystemsRequest)((Object)DescribeFileSystemsRequest.builder().build()));
    }

    default public DescribeFileSystemsResponse describeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkServiceException, SdkClientException, EFSException {
        throw new UnsupportedOperationException();
    }

    default public DescribeFileSystemsResponse describeFileSystems(Consumer<DescribeFileSystemsRequest.Builder> describeFileSystemsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkServiceException, SdkClientException, EFSException {
        return this.describeFileSystems((DescribeFileSystemsRequest)((Object)((DescribeFileSystemsRequest.Builder)DescribeFileSystemsRequest.builder().apply(describeFileSystemsRequest)).build()));
    }

    default public DescribeMountTargetSecurityGroupsResponse describeMountTargetSecurityGroups(DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, SdkServiceException, SdkClientException, EFSException {
        throw new UnsupportedOperationException();
    }

    default public DescribeMountTargetSecurityGroupsResponse describeMountTargetSecurityGroups(Consumer<DescribeMountTargetSecurityGroupsRequest.Builder> describeMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, SdkServiceException, SdkClientException, EFSException {
        return this.describeMountTargetSecurityGroups((DescribeMountTargetSecurityGroupsRequest)((Object)((DescribeMountTargetSecurityGroupsRequest.Builder)DescribeMountTargetSecurityGroupsRequest.builder().apply(describeMountTargetSecurityGroupsRequest)).build()));
    }

    default public DescribeMountTargetsResponse describeMountTargets(DescribeMountTargetsRequest describeMountTargetsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, MountTargetNotFoundException, SdkServiceException, SdkClientException, EFSException {
        throw new UnsupportedOperationException();
    }

    default public DescribeMountTargetsResponse describeMountTargets(Consumer<DescribeMountTargetsRequest.Builder> describeMountTargetsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, MountTargetNotFoundException, SdkServiceException, SdkClientException, EFSException {
        return this.describeMountTargets((DescribeMountTargetsRequest)((Object)((DescribeMountTargetsRequest.Builder)DescribeMountTargetsRequest.builder().apply(describeMountTargetsRequest)).build()));
    }

    default public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkServiceException, SdkClientException, EFSException {
        throw new UnsupportedOperationException();
    }

    default public DescribeTagsResponse describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkServiceException, SdkClientException, EFSException {
        return this.describeTags((DescribeTagsRequest)((Object)((DescribeTagsRequest.Builder)DescribeTagsRequest.builder().apply(describeTagsRequest)).build()));
    }

    default public ModifyMountTargetSecurityGroupsResponse modifyMountTargetSecurityGroups(ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, SdkServiceException, SdkClientException, EFSException {
        throw new UnsupportedOperationException();
    }

    default public ModifyMountTargetSecurityGroupsResponse modifyMountTargetSecurityGroups(Consumer<ModifyMountTargetSecurityGroupsRequest.Builder> modifyMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, SdkServiceException, SdkClientException, EFSException {
        return this.modifyMountTargetSecurityGroups((ModifyMountTargetSecurityGroupsRequest)((Object)((ModifyMountTargetSecurityGroupsRequest.Builder)ModifyMountTargetSecurityGroupsRequest.builder().apply(modifyMountTargetSecurityGroupsRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

