/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.FileSystemSize;

@SdkInternalApi
public class FileSystemSizeMarshaller {
    private static final MarshallingInfo<Long> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").build();
    private static final FileSystemSizeMarshaller INSTANCE = new FileSystemSizeMarshaller();

    public static FileSystemSizeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FileSystemSize fileSystemSize, ProtocolMarshaller protocolMarshaller) {
        if (fileSystemSize == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fileSystemSize.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)fileSystemSize.timestamp(), TIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

