/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.efs.model.FileSystemDescription;

@SdkInternalApi
public class FileSystemDescriptionMarshaller {
    private static final MarshallingInfo<String> OWNERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerId").build();
    private static final MarshallingInfo<String> CREATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationToken").build();
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final MarshallingInfo<String> LIFECYCLESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LifeCycleState").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Integer> NUMBEROFMOUNTTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfMountTargets").build();
    private static final MarshallingInfo<StructuredPojo> SIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInBytes").build();
    private static final MarshallingInfo<String> PERFORMANCEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PerformanceMode").build();
    private static final FileSystemDescriptionMarshaller INSTANCE = new FileSystemDescriptionMarshaller();

    public static FileSystemDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FileSystemDescription fileSystemDescription, ProtocolMarshaller protocolMarshaller) {
        if (fileSystemDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fileSystemDescription.ownerId(), OWNERID_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.creationToken(), CREATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.fileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.lifeCycleState(), LIFECYCLESTATE_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.numberOfMountTargets(), NUMBEROFMOUNTTARGETS_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.sizeInBytes(), SIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.performanceMode(), PERFORMANCEMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

