/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.efs.model.FileSystemDescription;
import software.amazon.awssdk.services.efs.model.FileSystemDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFileSystemsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeFileSystemsResponse> {
    private final String marker;
    private final List<FileSystemDescription> fileSystems;
    private final String nextMarker;

    private DescribeFileSystemsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.fileSystems = builder.fileSystems;
        this.nextMarker = builder.nextMarker;
    }

    public String marker() {
        return this.marker;
    }

    public List<FileSystemDescription> fileSystems() {
        return this.fileSystems;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.fileSystems() == null ? 0 : this.fileSystems().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsResponse)) {
            return false;
        }
        DescribeFileSystemsResponse other = (DescribeFileSystemsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.fileSystems() == null ^ this.fileSystems() == null) {
            return false;
        }
        if (other.fileSystems() != null && !other.fileSystems().equals(this.fileSystems())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.fileSystems() != null) {
            sb.append("FileSystems: ").append(this.fileSystems()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<FileSystemDescription> fileSystems;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsResponse model) {
            this.setMarker(model.marker);
            this.setFileSystems(model.fileSystems);
            this.setNextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<FileSystemDescription> getFileSystems() {
            return this.fileSystems;
        }

        @Override
        public final Builder fileSystems(Collection<FileSystemDescription> fileSystems) {
            this.fileSystems = FileSystemDescriptionsCopier.copy(fileSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(FileSystemDescription ... fileSystems) {
            this.fileSystems(Arrays.asList(fileSystems));
            return this;
        }

        public final void setFileSystems(Collection<FileSystemDescription> fileSystems) {
            this.fileSystems = FileSystemDescriptionsCopier.copy(fileSystems);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public DescribeFileSystemsResponse build() {
            return new DescribeFileSystemsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFileSystemsResponse> {
        public Builder marker(String var1);

        public Builder fileSystems(Collection<FileSystemDescription> var1);

        public Builder fileSystems(FileSystemDescription ... var1);

        public Builder nextMarker(String var1);
    }
}

