/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.time.Instant;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.efs.model.FileSystemSize;
import software.amazon.awssdk.services.efs.model.LifeCycleState;
import software.amazon.awssdk.services.efs.model.PerformanceMode;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFileSystemResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateFileSystemResponse> {
    private final String ownerId;
    private final String creationToken;
    private final String fileSystemId;
    private final Instant creationTime;
    private final String lifeCycleState;
    private final String name;
    private final Integer numberOfMountTargets;
    private final FileSystemSize sizeInBytes;
    private final String performanceMode;

    private CreateFileSystemResponse(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.creationToken = builder.creationToken;
        this.fileSystemId = builder.fileSystemId;
        this.creationTime = builder.creationTime;
        this.lifeCycleState = builder.lifeCycleState;
        this.name = builder.name;
        this.numberOfMountTargets = builder.numberOfMountTargets;
        this.sizeInBytes = builder.sizeInBytes;
        this.performanceMode = builder.performanceMode;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String creationToken() {
        return this.creationToken;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String lifeCycleState() {
        return this.lifeCycleState;
    }

    public String name() {
        return this.name;
    }

    public Integer numberOfMountTargets() {
        return this.numberOfMountTargets;
    }

    public FileSystemSize sizeInBytes() {
        return this.sizeInBytes;
    }

    public String performanceMode() {
        return this.performanceMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.creationToken() == null ? 0 : this.creationToken().hashCode());
        hashCode = 31 * hashCode + (this.fileSystemId() == null ? 0 : this.fileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.lifeCycleState() == null ? 0 : this.lifeCycleState().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.numberOfMountTargets() == null ? 0 : this.numberOfMountTargets().hashCode());
        hashCode = 31 * hashCode + (this.sizeInBytes() == null ? 0 : this.sizeInBytes().hashCode());
        hashCode = 31 * hashCode + (this.performanceMode() == null ? 0 : this.performanceMode().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemResponse)) {
            return false;
        }
        CreateFileSystemResponse other = (CreateFileSystemResponse)((Object)obj);
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.creationToken() == null ^ this.creationToken() == null) {
            return false;
        }
        if (other.creationToken() != null && !other.creationToken().equals(this.creationToken())) {
            return false;
        }
        if (other.fileSystemId() == null ^ this.fileSystemId() == null) {
            return false;
        }
        if (other.fileSystemId() != null && !other.fileSystemId().equals(this.fileSystemId())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.lifeCycleState() == null ^ this.lifeCycleState() == null) {
            return false;
        }
        if (other.lifeCycleState() != null && !other.lifeCycleState().equals(this.lifeCycleState())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.numberOfMountTargets() == null ^ this.numberOfMountTargets() == null) {
            return false;
        }
        if (other.numberOfMountTargets() != null && !other.numberOfMountTargets().equals(this.numberOfMountTargets())) {
            return false;
        }
        if (other.sizeInBytes() == null ^ this.sizeInBytes() == null) {
            return false;
        }
        if (other.sizeInBytes() != null && !other.sizeInBytes().equals(this.sizeInBytes())) {
            return false;
        }
        if (other.performanceMode() == null ^ this.performanceMode() == null) {
            return false;
        }
        return other.performanceMode() == null || other.performanceMode().equals(this.performanceMode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.creationToken() != null) {
            sb.append("CreationToken: ").append(this.creationToken()).append(",");
        }
        if (this.fileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.fileSystemId()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.lifeCycleState() != null) {
            sb.append("LifeCycleState: ").append(this.lifeCycleState()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.numberOfMountTargets() != null) {
            sb.append("NumberOfMountTargets: ").append(this.numberOfMountTargets()).append(",");
        }
        if (this.sizeInBytes() != null) {
            sb.append("SizeInBytes: ").append(this.sizeInBytes()).append(",");
        }
        if (this.performanceMode() != null) {
            sb.append("PerformanceMode: ").append(this.performanceMode()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String creationToken;
        private String fileSystemId;
        private Instant creationTime;
        private String lifeCycleState;
        private String name;
        private Integer numberOfMountTargets;
        private FileSystemSize sizeInBytes;
        private String performanceMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemResponse model) {
            this.setOwnerId(model.ownerId);
            this.setCreationToken(model.creationToken);
            this.setFileSystemId(model.fileSystemId);
            this.setCreationTime(model.creationTime);
            this.setLifeCycleState(model.lifeCycleState);
            this.setName(model.name);
            this.setNumberOfMountTargets(model.numberOfMountTargets);
            this.setSizeInBytes(model.sizeInBytes);
            this.setPerformanceMode(model.performanceMode);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getCreationToken() {
            return this.creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getLifeCycleState() {
            return this.lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState.toString());
            return this;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getNumberOfMountTargets() {
            return this.numberOfMountTargets;
        }

        @Override
        public final Builder numberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
            return this;
        }

        public final void setNumberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
        }

        public final FileSystemSize getSizeInBytes() {
            return this.sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(FileSystemSize sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(FileSystemSize sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public final String getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode.toString());
            return this;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        public CreateFileSystemResponse build() {
            return new CreateFileSystemResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateFileSystemResponse> {
        public Builder ownerId(String var1);

        public Builder creationToken(String var1);

        public Builder fileSystemId(String var1);

        public Builder creationTime(Instant var1);

        public Builder lifeCycleState(String var1);

        public Builder lifeCycleState(LifeCycleState var1);

        public Builder name(String var1);

        public Builder numberOfMountTargets(Integer var1);

        public Builder sizeInBytes(FileSystemSize var1);

        public Builder performanceMode(String var1);

        public Builder performanceMode(PerformanceMode var1);
    }
}

