/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.efs.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMountTargetSecurityGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMountTargetSecurityGroupsResponse> {
    private final List<String> securityGroups;

    private DescribeMountTargetSecurityGroupsResponse(BuilderImpl builder) {
        this.securityGroups = builder.securityGroups;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetSecurityGroupsResponse)) {
            return false;
        }
        DescribeMountTargetSecurityGroupsResponse other = (DescribeMountTargetSecurityGroupsResponse)((Object)obj);
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        return other.securityGroups() == null || other.securityGroups().equals(this.securityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetSecurityGroupsResponse model) {
            this.setSecurityGroups(model.securityGroups);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @SafeVarargs
        public final void setSecurityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
        }

        public DescribeMountTargetSecurityGroupsResponse build() {
            return new DescribeMountTargetSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMountTargetSecurityGroupsResponse> {
        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);
    }
}

