/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.UpdateFileSystemRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateFileSystemRequestModelMarshaller {
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FileSystemId").isBinary(false).build();
    private static final MarshallingInfo<String> THROUGHPUTMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThroughputMode").isBinary(false).build();
    private static final MarshallingInfo<Double> PROVISIONEDTHROUGHPUTINMIBPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedThroughputInMibps").isBinary(false).build();
    private static final UpdateFileSystemRequestModelMarshaller INSTANCE = new UpdateFileSystemRequestModelMarshaller();

    private UpdateFileSystemRequestModelMarshaller() {
    }

    public static UpdateFileSystemRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateFileSystemRequest updateFileSystemRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateFileSystemRequest), (String)"updateFileSystemRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateFileSystemRequest.fileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall((Object)updateFileSystemRequest.throughputModeAsString(), THROUGHPUTMODE_BINDING);
            protocolMarshaller.marshall((Object)updateFileSystemRequest.provisionedThroughputInMibps(), PROVISIONEDTHROUGHPUTINMIBPS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

