/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeFileSystemsRequestModelMarshaller {
    private static final MarshallingInfo<Integer> MAXITEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("MaxItems").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("Marker").isBinary(false).build();
    private static final MarshallingInfo<String> CREATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("CreationToken").isBinary(false).build();
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("FileSystemId").isBinary(false).build();
    private static final DescribeFileSystemsRequestModelMarshaller INSTANCE = new DescribeFileSystemsRequestModelMarshaller();

    private DescribeFileSystemsRequestModelMarshaller() {
    }

    public static DescribeFileSystemsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeFileSystemsRequest describeFileSystemsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeFileSystemsRequest), (String)"describeFileSystemsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeFileSystemsRequest.maxItems(), MAXITEMS_BINDING);
            protocolMarshaller.marshall((Object)describeFileSystemsRequest.marker(), MARKER_BINDING);
            protocolMarshaller.marshall((Object)describeFileSystemsRequest.creationToken(), CREATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)describeFileSystemsRequest.fileSystemId(), FILESYSTEMID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

