/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.services.efs.model.PerformanceMode;
import software.amazon.awssdk.services.efs.model.ThroughputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFileSystemRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, CreateFileSystemRequest> {
    private final String creationToken;
    private final String performanceMode;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String throughputMode;
    private final Double provisionedThroughputInMibps;

    private CreateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.creationToken = builder.creationToken;
        this.performanceMode = builder.performanceMode;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.throughputMode = builder.throughputMode;
        this.provisionedThroughputInMibps = builder.provisionedThroughputInMibps;
    }

    public String creationToken() {
        return this.creationToken;
    }

    public PerformanceMode performanceMode() {
        return PerformanceMode.fromValue(this.performanceMode);
    }

    public String performanceModeAsString() {
        return this.performanceMode;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(this.throughputMode);
    }

    public String throughputModeAsString() {
        return this.throughputMode;
    }

    public Double provisionedThroughputInMibps() {
        return this.provisionedThroughputInMibps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputInMibps());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemRequest)) {
            return false;
        }
        CreateFileSystemRequest other = (CreateFileSystemRequest)((Object)obj);
        return Objects.equals(this.creationToken(), other.creationToken()) && Objects.equals(this.performanceModeAsString(), other.performanceModeAsString()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.throughputModeAsString(), other.throughputModeAsString()) && Objects.equals(this.provisionedThroughputInMibps(), other.provisionedThroughputInMibps());
    }

    public String toString() {
        return ToString.builder((String)"CreateFileSystemRequest").add("CreationToken", (Object)this.creationToken()).add("PerformanceMode", (Object)this.performanceModeAsString()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ThroughputMode", (Object)this.throughputModeAsString()).add("ProvisionedThroughputInMibps", (Object)this.provisionedThroughputInMibps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationToken": {
                return Optional.ofNullable(clazz.cast(this.creationToken()));
            }
            case "PerformanceMode": {
                return Optional.ofNullable(clazz.cast(this.performanceModeAsString()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ThroughputMode": {
                return Optional.ofNullable(clazz.cast(this.throughputModeAsString()));
            }
            case "ProvisionedThroughputInMibps": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputInMibps()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private String creationToken;
        private String performanceMode;
        private Boolean encrypted;
        private String kmsKeyId;
        private String throughputMode;
        private Double provisionedThroughputInMibps;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemRequest model) {
            super(model);
            this.creationToken(model.creationToken);
            this.performanceMode(model.performanceMode);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.throughputMode(model.throughputMode);
            this.provisionedThroughputInMibps(model.provisionedThroughputInMibps);
        }

        public final String getCreationToken() {
            return this.creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode.toString());
            return this;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getThroughputMode() {
            return this.throughputMode;
        }

        @Override
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode.toString());
            return this;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        public final Double getProvisionedThroughputInMibps() {
            return this.provisionedThroughputInMibps;
        }

        @Override
        public final Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        public final void setProvisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFileSystemRequest build() {
            return new CreateFileSystemRequest(this);
        }
    }

    public static interface Builder
    extends EfsRequest.Builder,
    CopyableBuilder<Builder, CreateFileSystemRequest> {
        public Builder creationToken(String var1);

        public Builder performanceMode(String var1);

        public Builder performanceMode(PerformanceMode var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder throughputMode(String var1);

        public Builder throughputMode(ThroughputMode var1);

        public Builder provisionedThroughputInMibps(Double var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

