/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.FileSystemSize;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FileSystemSizeMarshaller {
    private static final MarshallingInfo<Long> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").isBinary(false).build();
    private static final FileSystemSizeMarshaller INSTANCE = new FileSystemSizeMarshaller();

    private FileSystemSizeMarshaller() {
    }

    public static FileSystemSizeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FileSystemSize fileSystemSize, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)fileSystemSize, (String)"fileSystemSize");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)fileSystemSize.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)fileSystemSize.timestamp(), TIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

