/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.EfsResponse;
import software.amazon.awssdk.services.efs.model.FileSystemDescription;
import software.amazon.awssdk.services.efs.model.FileSystemDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFileSystemsResponse
extends EfsResponse
implements ToCopyableBuilder<Builder, DescribeFileSystemsResponse> {
    private final String marker;
    private final List<FileSystemDescription> fileSystems;
    private final String nextMarker;

    private DescribeFileSystemsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.fileSystems = builder.fileSystems;
        this.nextMarker = builder.nextMarker;
    }

    public String marker() {
        return this.marker;
    }

    public List<FileSystemDescription> fileSystems() {
        return this.fileSystems;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsResponse)) {
            return false;
        }
        DescribeFileSystemsResponse other = (DescribeFileSystemsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.fileSystems(), other.fileSystems()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFileSystemsResponse").add("Marker", (Object)this.marker()).add("FileSystems", this.fileSystems()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "FileSystems": {
                return Optional.ofNullable(clazz.cast(this.fileSystems()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EfsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<FileSystemDescription> fileSystems = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsResponse model) {
            super(model);
            this.marker(model.marker);
            this.fileSystems(model.fileSystems);
            this.nextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<FileSystemDescription.Builder> getFileSystems() {
            return this.fileSystems != null ? (Collection)this.fileSystems.stream().map(FileSystemDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fileSystems(Collection<FileSystemDescription> fileSystems) {
            this.fileSystems = FileSystemDescriptionsCopier.copy(fileSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(FileSystemDescription ... fileSystems) {
            this.fileSystems(Arrays.asList(fileSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(Consumer<FileSystemDescription.Builder> ... fileSystems) {
            this.fileSystems(Stream.of(fileSystems).map(c -> (FileSystemDescription)((FileSystemDescription.Builder)FileSystemDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFileSystems(Collection<FileSystemDescription.BuilderImpl> fileSystems) {
            this.fileSystems = FileSystemDescriptionsCopier.copyFromBuilder(fileSystems);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeFileSystemsResponse build() {
            return new DescribeFileSystemsResponse(this);
        }
    }

    public static interface Builder
    extends EfsResponse.Builder,
    CopyableBuilder<Builder, DescribeFileSystemsResponse> {
        public Builder marker(String var1);

        public Builder fileSystems(Collection<FileSystemDescription> var1);

        public Builder fileSystems(FileSystemDescription ... var1);

        public Builder fileSystems(Consumer<FileSystemDescription.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

