/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LinearConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LinearConfiguration> {
    private static final SdkField<Double> STEP_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("stepPercent").getter(LinearConfiguration.getter(LinearConfiguration::stepPercent)).setter(LinearConfiguration.setter(Builder::stepPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepPercent").build()}).build();
    private static final SdkField<Integer> STEP_BAKE_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("stepBakeTimeInMinutes").getter(LinearConfiguration.getter(LinearConfiguration::stepBakeTimeInMinutes)).setter(LinearConfiguration.setter(Builder::stepBakeTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepBakeTimeInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_PERCENT_FIELD, STEP_BAKE_TIME_IN_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LinearConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double stepPercent;
    private final Integer stepBakeTimeInMinutes;

    private LinearConfiguration(BuilderImpl builder) {
        this.stepPercent = builder.stepPercent;
        this.stepBakeTimeInMinutes = builder.stepBakeTimeInMinutes;
    }

    public final Double stepPercent() {
        return this.stepPercent;
    }

    public final Integer stepBakeTimeInMinutes() {
        return this.stepBakeTimeInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepBakeTimeInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinearConfiguration)) {
            return false;
        }
        LinearConfiguration other = (LinearConfiguration)obj;
        return Objects.equals(this.stepPercent(), other.stepPercent()) && Objects.equals(this.stepBakeTimeInMinutes(), other.stepBakeTimeInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"LinearConfiguration").add("StepPercent", (Object)this.stepPercent()).add("StepBakeTimeInMinutes", (Object)this.stepBakeTimeInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stepPercent": {
                return Optional.ofNullable(clazz.cast(this.stepPercent()));
            }
            case "stepBakeTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.stepBakeTimeInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stepPercent", STEP_PERCENT_FIELD);
        map.put("stepBakeTimeInMinutes", STEP_BAKE_TIME_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinearConfiguration, T> g) {
        return obj -> g.apply((LinearConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double stepPercent;
        private Integer stepBakeTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(LinearConfiguration model) {
            this.stepPercent(model.stepPercent);
            this.stepBakeTimeInMinutes(model.stepBakeTimeInMinutes);
        }

        public final Double getStepPercent() {
            return this.stepPercent;
        }

        public final void setStepPercent(Double stepPercent) {
            this.stepPercent = stepPercent;
        }

        @Override
        public final Builder stepPercent(Double stepPercent) {
            this.stepPercent = stepPercent;
            return this;
        }

        public final Integer getStepBakeTimeInMinutes() {
            return this.stepBakeTimeInMinutes;
        }

        public final void setStepBakeTimeInMinutes(Integer stepBakeTimeInMinutes) {
            this.stepBakeTimeInMinutes = stepBakeTimeInMinutes;
        }

        @Override
        public final Builder stepBakeTimeInMinutes(Integer stepBakeTimeInMinutes) {
            this.stepBakeTimeInMinutes = stepBakeTimeInMinutes;
            return this;
        }

        public LinearConfiguration build() {
            return new LinearConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LinearConfiguration> {
        public Builder stepPercent(Double var1);

        public Builder stepBakeTimeInMinutes(Integer var1);
    }
}

