/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayServiceConfiguration;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayServiceConfigurationsCopier;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayServiceStatus;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ECSExpressGatewayService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ECSExpressGatewayService> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(ECSExpressGatewayService.getter(ECSExpressGatewayService::cluster)).setter(ECSExpressGatewayService.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(ECSExpressGatewayService.getter(ECSExpressGatewayService::serviceName)).setter(ECSExpressGatewayService.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceArn").getter(ECSExpressGatewayService.getter(ECSExpressGatewayService::serviceArn)).setter(ECSExpressGatewayService.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()}).build();
    private static final SdkField<String> INFRASTRUCTURE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("infrastructureRoleArn").getter(ECSExpressGatewayService.getter(ECSExpressGatewayService::infrastructureRoleArn)).setter(ECSExpressGatewayService.setter(Builder::infrastructureRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureRoleArn").build()}).build();
    private static final SdkField<ExpressGatewayServiceStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(ECSExpressGatewayService.getter(ECSExpressGatewayService::status)).setter(ECSExpressGatewayService.setter(Builder::status)).constructor(ExpressGatewayServiceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> CURRENT_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentDeployment").getter(ECSExpressGatewayService.getter(ECSExpressGatewayService::currentDeployment)).setter(ECSExpressGatewayService.setter(Builder::currentDeployment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentDeployment").build()}).build();
    private static final SdkField<List<ExpressGatewayServiceConfiguration>> ACTIVE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activeConfigurations").getter(ECSExpressGatewayService.getter(ECSExpressGatewayService::activeConfigurations)).setter(ECSExpressGatewayService.setter(Builder::activeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpressGatewayServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(ECSExpressGatewayService.getter(ECSExpressGatewayService::tags)).setter(ECSExpressGatewayService.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ECSExpressGatewayService.getter(ECSExpressGatewayService::createdAt)).setter(ECSExpressGatewayService.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ECSExpressGatewayService.getter(ECSExpressGatewayService::updatedAt)).setter(ECSExpressGatewayService.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_NAME_FIELD, SERVICE_ARN_FIELD, INFRASTRUCTURE_ROLE_ARN_FIELD, STATUS_FIELD, CURRENT_DEPLOYMENT_FIELD, ACTIVE_CONFIGURATIONS_FIELD, TAGS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ECSExpressGatewayService.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cluster;
    private final String serviceName;
    private final String serviceArn;
    private final String infrastructureRoleArn;
    private final ExpressGatewayServiceStatus status;
    private final String currentDeployment;
    private final List<ExpressGatewayServiceConfiguration> activeConfigurations;
    private final List<Tag> tags;
    private final Instant createdAt;
    private final Instant updatedAt;

    private ECSExpressGatewayService(BuilderImpl builder) {
        this.cluster = builder.cluster;
        this.serviceName = builder.serviceName;
        this.serviceArn = builder.serviceArn;
        this.infrastructureRoleArn = builder.infrastructureRoleArn;
        this.status = builder.status;
        this.currentDeployment = builder.currentDeployment;
        this.activeConfigurations = builder.activeConfigurations;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String infrastructureRoleArn() {
        return this.infrastructureRoleArn;
    }

    public final ExpressGatewayServiceStatus status() {
        return this.status;
    }

    public final String currentDeployment() {
        return this.currentDeployment;
    }

    public final boolean hasActiveConfigurations() {
        return this.activeConfigurations != null && !(this.activeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ExpressGatewayServiceConfiguration> activeConfigurations() {
        return this.activeConfigurations;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveConfigurations() ? this.activeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSExpressGatewayService)) {
            return false;
        }
        ECSExpressGatewayService other = (ECSExpressGatewayService)obj;
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.infrastructureRoleArn(), other.infrastructureRoleArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.currentDeployment(), other.currentDeployment()) && this.hasActiveConfigurations() == other.hasActiveConfigurations() && Objects.equals(this.activeConfigurations(), other.activeConfigurations()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ECSExpressGatewayService").add("Cluster", (Object)this.cluster()).add("ServiceName", (Object)this.serviceName()).add("ServiceArn", (Object)this.serviceArn()).add("InfrastructureRoleArn", (Object)this.infrastructureRoleArn()).add("Status", (Object)this.status()).add("CurrentDeployment", (Object)this.currentDeployment()).add("ActiveConfigurations", this.hasActiveConfigurations() ? this.activeConfigurations() : null).add("Tags", this.hasTags() ? this.tags() : null).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "serviceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "infrastructureRoleArn": {
                return Optional.ofNullable(clazz.cast(this.infrastructureRoleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "currentDeployment": {
                return Optional.ofNullable(clazz.cast(this.currentDeployment()));
            }
            case "activeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.activeConfigurations()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cluster", CLUSTER_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("infrastructureRoleArn", INFRASTRUCTURE_ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("currentDeployment", CURRENT_DEPLOYMENT_FIELD);
        map.put("activeConfigurations", ACTIVE_CONFIGURATIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ECSExpressGatewayService, T> g) {
        return obj -> g.apply((ECSExpressGatewayService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cluster;
        private String serviceName;
        private String serviceArn;
        private String infrastructureRoleArn;
        private ExpressGatewayServiceStatus status;
        private String currentDeployment;
        private List<ExpressGatewayServiceConfiguration> activeConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ECSExpressGatewayService model) {
            this.cluster(model.cluster);
            this.serviceName(model.serviceName);
            this.serviceArn(model.serviceArn);
            this.infrastructureRoleArn(model.infrastructureRoleArn);
            this.status(model.status);
            this.currentDeployment(model.currentDeployment);
            this.activeConfigurations(model.activeConfigurations);
            this.tags(model.tags);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getInfrastructureRoleArn() {
            return this.infrastructureRoleArn;
        }

        public final void setInfrastructureRoleArn(String infrastructureRoleArn) {
            this.infrastructureRoleArn = infrastructureRoleArn;
        }

        @Override
        public final Builder infrastructureRoleArn(String infrastructureRoleArn) {
            this.infrastructureRoleArn = infrastructureRoleArn;
            return this;
        }

        public final ExpressGatewayServiceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ExpressGatewayServiceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ExpressGatewayServiceStatus status) {
            this.status = status;
            return this;
        }

        public final String getCurrentDeployment() {
            return this.currentDeployment;
        }

        public final void setCurrentDeployment(String currentDeployment) {
            this.currentDeployment = currentDeployment;
        }

        @Override
        public final Builder currentDeployment(String currentDeployment) {
            this.currentDeployment = currentDeployment;
            return this;
        }

        public final List<ExpressGatewayServiceConfiguration.Builder> getActiveConfigurations() {
            List<ExpressGatewayServiceConfiguration.Builder> result = ExpressGatewayServiceConfigurationsCopier.copyToBuilder(this.activeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveConfigurations(Collection<ExpressGatewayServiceConfiguration.BuilderImpl> activeConfigurations) {
            this.activeConfigurations = ExpressGatewayServiceConfigurationsCopier.copyFromBuilder(activeConfigurations);
        }

        @Override
        public final Builder activeConfigurations(Collection<ExpressGatewayServiceConfiguration> activeConfigurations) {
            this.activeConfigurations = ExpressGatewayServiceConfigurationsCopier.copy(activeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeConfigurations(ExpressGatewayServiceConfiguration ... activeConfigurations) {
            this.activeConfigurations(Arrays.asList(activeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeConfigurations(Consumer<ExpressGatewayServiceConfiguration.Builder> ... activeConfigurations) {
            this.activeConfigurations(Stream.of(activeConfigurations).map(c -> (ExpressGatewayServiceConfiguration)((ExpressGatewayServiceConfiguration.Builder)ExpressGatewayServiceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ECSExpressGatewayService build() {
            return new ECSExpressGatewayService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ECSExpressGatewayService> {
        public Builder cluster(String var1);

        public Builder serviceName(String var1);

        public Builder serviceArn(String var1);

        public Builder infrastructureRoleArn(String var1);

        public Builder status(ExpressGatewayServiceStatus var1);

        default public Builder status(Consumer<ExpressGatewayServiceStatus.Builder> status) {
            return this.status((ExpressGatewayServiceStatus)((ExpressGatewayServiceStatus.Builder)ExpressGatewayServiceStatus.builder().applyMutation(status)).build());
        }

        public Builder currentDeployment(String var1);

        public Builder activeConfigurations(Collection<ExpressGatewayServiceConfiguration> var1);

        public Builder activeConfigurations(ExpressGatewayServiceConfiguration ... var1);

        public Builder activeConfigurations(Consumer<ExpressGatewayServiceConfiguration.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

