/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse;

public class ListTaskDefinitionFamiliesPublisher
implements SdkPublisher<ListTaskDefinitionFamiliesResponse> {
    private final EcsAsyncClient client;
    private final ListTaskDefinitionFamiliesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTaskDefinitionFamiliesPublisher(EcsAsyncClient client, ListTaskDefinitionFamiliesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTaskDefinitionFamiliesPublisher(EcsAsyncClient client, ListTaskDefinitionFamiliesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTaskDefinitionFamiliesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTaskDefinitionFamiliesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> families() {
        return this.flatMapIterable(response -> response.families());
    }

    private class ListTaskDefinitionFamiliesResponseFetcher
    implements AsyncPageFetcher<ListTaskDefinitionFamiliesResponse> {
        private ListTaskDefinitionFamiliesResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskDefinitionFamiliesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTaskDefinitionFamiliesResponse> nextPage(ListTaskDefinitionFamiliesResponse previousPage) {
            if (previousPage == null) {
                return ListTaskDefinitionFamiliesPublisher.this.client.listTaskDefinitionFamilies(ListTaskDefinitionFamiliesPublisher.this.firstRequest);
            }
            return ListTaskDefinitionFamiliesPublisher.this.client.listTaskDefinitionFamilies((ListTaskDefinitionFamiliesRequest)((Object)ListTaskDefinitionFamiliesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

