/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.AccessType;
import software.amazon.awssdk.services.ecs.model.ManagedCertificate;
import software.amazon.awssdk.services.ecs.model.ManagedListener;
import software.amazon.awssdk.services.ecs.model.ManagedListenerRule;
import software.amazon.awssdk.services.ecs.model.ManagedLoadBalancer;
import software.amazon.awssdk.services.ecs.model.ManagedSecurityGroup;
import software.amazon.awssdk.services.ecs.model.ManagedSecurityGroupsCopier;
import software.amazon.awssdk.services.ecs.model.ManagedTargetGroup;
import software.amazon.awssdk.services.ecs.model.ManagedTargetGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedIngressPath
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedIngressPath> {
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessType").getter(ManagedIngressPath.getter(ManagedIngressPath::accessTypeAsString)).setter(ManagedIngressPath.setter(Builder::accessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessType").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(ManagedIngressPath.getter(ManagedIngressPath::endpoint)).setter(ManagedIngressPath.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<ManagedLoadBalancer> LOAD_BALANCER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("loadBalancer").getter(ManagedIngressPath.getter(ManagedIngressPath::loadBalancer)).setter(ManagedIngressPath.setter(Builder::loadBalancer)).constructor(ManagedLoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancer").build()}).build();
    private static final SdkField<List<ManagedSecurityGroup>> LOAD_BALANCER_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loadBalancerSecurityGroups").getter(ManagedIngressPath.getter(ManagedIngressPath::loadBalancerSecurityGroups)).setter(ManagedIngressPath.setter(Builder::loadBalancerSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ManagedCertificate> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("certificate").getter(ManagedIngressPath.getter(ManagedIngressPath::certificate)).setter(ManagedIngressPath.setter(Builder::certificate)).constructor(ManagedCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()}).build();
    private static final SdkField<ManagedListener> LISTENER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("listener").getter(ManagedIngressPath.getter(ManagedIngressPath::listener)).setter(ManagedIngressPath.setter(Builder::listener)).constructor(ManagedListener::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listener").build()}).build();
    private static final SdkField<ManagedListenerRule> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rule").getter(ManagedIngressPath.getter(ManagedIngressPath::rule)).setter(ManagedIngressPath.setter(Builder::rule)).constructor(ManagedListenerRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()}).build();
    private static final SdkField<List<ManagedTargetGroup>> TARGET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetGroups").getter(ManagedIngressPath.getter(ManagedIngressPath::targetGroups)).setter(ManagedIngressPath.setter(Builder::targetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedTargetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPE_FIELD, ENDPOINT_FIELD, LOAD_BALANCER_FIELD, LOAD_BALANCER_SECURITY_GROUPS_FIELD, CERTIFICATE_FIELD, LISTENER_FIELD, RULE_FIELD, TARGET_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedIngressPath.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accessType;
    private final String endpoint;
    private final ManagedLoadBalancer loadBalancer;
    private final List<ManagedSecurityGroup> loadBalancerSecurityGroups;
    private final ManagedCertificate certificate;
    private final ManagedListener listener;
    private final ManagedListenerRule rule;
    private final List<ManagedTargetGroup> targetGroups;

    private ManagedIngressPath(BuilderImpl builder) {
        this.accessType = builder.accessType;
        this.endpoint = builder.endpoint;
        this.loadBalancer = builder.loadBalancer;
        this.loadBalancerSecurityGroups = builder.loadBalancerSecurityGroups;
        this.certificate = builder.certificate;
        this.listener = builder.listener;
        this.rule = builder.rule;
        this.targetGroups = builder.targetGroups;
    }

    public final AccessType accessType() {
        return AccessType.fromValue(this.accessType);
    }

    public final String accessTypeAsString() {
        return this.accessType;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final ManagedLoadBalancer loadBalancer() {
        return this.loadBalancer;
    }

    public final boolean hasLoadBalancerSecurityGroups() {
        return this.loadBalancerSecurityGroups != null && !(this.loadBalancerSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<ManagedSecurityGroup> loadBalancerSecurityGroups() {
        return this.loadBalancerSecurityGroups;
    }

    public final ManagedCertificate certificate() {
        return this.certificate;
    }

    public final ManagedListener listener() {
        return this.listener;
    }

    public final ManagedListenerRule rule() {
        return this.rule;
    }

    public final boolean hasTargetGroups() {
        return this.targetGroups != null && !(this.targetGroups instanceof SdkAutoConstructList);
    }

    public final List<ManagedTargetGroup> targetGroups() {
        return this.targetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancer());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancerSecurityGroups() ? this.loadBalancerSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.listener());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetGroups() ? this.targetGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedIngressPath)) {
            return false;
        }
        ManagedIngressPath other = (ManagedIngressPath)obj;
        return Objects.equals(this.accessTypeAsString(), other.accessTypeAsString()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.loadBalancer(), other.loadBalancer()) && this.hasLoadBalancerSecurityGroups() == other.hasLoadBalancerSecurityGroups() && Objects.equals(this.loadBalancerSecurityGroups(), other.loadBalancerSecurityGroups()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.listener(), other.listener()) && Objects.equals(this.rule(), other.rule()) && this.hasTargetGroups() == other.hasTargetGroups() && Objects.equals(this.targetGroups(), other.targetGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedIngressPath").add("AccessType", (Object)this.accessTypeAsString()).add("Endpoint", (Object)this.endpoint()).add("LoadBalancer", (Object)this.loadBalancer()).add("LoadBalancerSecurityGroups", this.hasLoadBalancerSecurityGroups() ? this.loadBalancerSecurityGroups() : null).add("Certificate", (Object)this.certificate()).add("Listener", (Object)this.listener()).add("Rule", (Object)this.rule()).add("TargetGroups", this.hasTargetGroups() ? this.targetGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessType": {
                return Optional.ofNullable(clazz.cast(this.accessTypeAsString()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "loadBalancer": {
                return Optional.ofNullable(clazz.cast(this.loadBalancer()));
            }
            case "loadBalancerSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerSecurityGroups()));
            }
            case "certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "listener": {
                return Optional.ofNullable(clazz.cast(this.listener()));
            }
            case "rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "targetGroups": {
                return Optional.ofNullable(clazz.cast(this.targetGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessType", ACCESS_TYPE_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("loadBalancer", LOAD_BALANCER_FIELD);
        map.put("loadBalancerSecurityGroups", LOAD_BALANCER_SECURITY_GROUPS_FIELD);
        map.put("certificate", CERTIFICATE_FIELD);
        map.put("listener", LISTENER_FIELD);
        map.put("rule", RULE_FIELD);
        map.put("targetGroups", TARGET_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedIngressPath, T> g) {
        return obj -> g.apply((ManagedIngressPath)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessType;
        private String endpoint;
        private ManagedLoadBalancer loadBalancer;
        private List<ManagedSecurityGroup> loadBalancerSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private ManagedCertificate certificate;
        private ManagedListener listener;
        private ManagedListenerRule rule;
        private List<ManagedTargetGroup> targetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedIngressPath model) {
            this.accessType(model.accessType);
            this.endpoint(model.endpoint);
            this.loadBalancer(model.loadBalancer);
            this.loadBalancerSecurityGroups(model.loadBalancerSecurityGroups);
            this.certificate(model.certificate);
            this.listener(model.listener);
            this.rule(model.rule);
            this.targetGroups(model.targetGroups);
        }

        public final String getAccessType() {
            return this.accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(AccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final ManagedLoadBalancer.Builder getLoadBalancer() {
            return this.loadBalancer != null ? this.loadBalancer.toBuilder() : null;
        }

        public final void setLoadBalancer(ManagedLoadBalancer.BuilderImpl loadBalancer) {
            this.loadBalancer = loadBalancer != null ? loadBalancer.build() : null;
        }

        @Override
        public final Builder loadBalancer(ManagedLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public final List<ManagedSecurityGroup.Builder> getLoadBalancerSecurityGroups() {
            List<ManagedSecurityGroup.Builder> result = ManagedSecurityGroupsCopier.copyToBuilder(this.loadBalancerSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancerSecurityGroups(Collection<ManagedSecurityGroup.BuilderImpl> loadBalancerSecurityGroups) {
            this.loadBalancerSecurityGroups = ManagedSecurityGroupsCopier.copyFromBuilder(loadBalancerSecurityGroups);
        }

        @Override
        public final Builder loadBalancerSecurityGroups(Collection<ManagedSecurityGroup> loadBalancerSecurityGroups) {
            this.loadBalancerSecurityGroups = ManagedSecurityGroupsCopier.copy(loadBalancerSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerSecurityGroups(ManagedSecurityGroup ... loadBalancerSecurityGroups) {
            this.loadBalancerSecurityGroups(Arrays.asList(loadBalancerSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerSecurityGroups(Consumer<ManagedSecurityGroup.Builder> ... loadBalancerSecurityGroups) {
            this.loadBalancerSecurityGroups(Stream.of(loadBalancerSecurityGroups).map(c -> (ManagedSecurityGroup)((ManagedSecurityGroup.Builder)ManagedSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ManagedCertificate.Builder getCertificate() {
            return this.certificate != null ? this.certificate.toBuilder() : null;
        }

        public final void setCertificate(ManagedCertificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        @Override
        public final Builder certificate(ManagedCertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public final ManagedListener.Builder getListener() {
            return this.listener != null ? this.listener.toBuilder() : null;
        }

        public final void setListener(ManagedListener.BuilderImpl listener) {
            this.listener = listener != null ? listener.build() : null;
        }

        @Override
        public final Builder listener(ManagedListener listener) {
            this.listener = listener;
            return this;
        }

        public final ManagedListenerRule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(ManagedListenerRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(ManagedListenerRule rule) {
            this.rule = rule;
            return this;
        }

        public final List<ManagedTargetGroup.Builder> getTargetGroups() {
            List<ManagedTargetGroup.Builder> result = ManagedTargetGroupsCopier.copyToBuilder(this.targetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetGroups(Collection<ManagedTargetGroup.BuilderImpl> targetGroups) {
            this.targetGroups = ManagedTargetGroupsCopier.copyFromBuilder(targetGroups);
        }

        @Override
        public final Builder targetGroups(Collection<ManagedTargetGroup> targetGroups) {
            this.targetGroups = ManagedTargetGroupsCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(ManagedTargetGroup ... targetGroups) {
            this.targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(Consumer<ManagedTargetGroup.Builder> ... targetGroups) {
            this.targetGroups(Stream.of(targetGroups).map(c -> (ManagedTargetGroup)((ManagedTargetGroup.Builder)ManagedTargetGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ManagedIngressPath build() {
            return new ManagedIngressPath(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedIngressPath> {
        public Builder accessType(String var1);

        public Builder accessType(AccessType var1);

        public Builder endpoint(String var1);

        public Builder loadBalancer(ManagedLoadBalancer var1);

        default public Builder loadBalancer(Consumer<ManagedLoadBalancer.Builder> loadBalancer) {
            return this.loadBalancer((ManagedLoadBalancer)((ManagedLoadBalancer.Builder)ManagedLoadBalancer.builder().applyMutation(loadBalancer)).build());
        }

        public Builder loadBalancerSecurityGroups(Collection<ManagedSecurityGroup> var1);

        public Builder loadBalancerSecurityGroups(ManagedSecurityGroup ... var1);

        public Builder loadBalancerSecurityGroups(Consumer<ManagedSecurityGroup.Builder> ... var1);

        public Builder certificate(ManagedCertificate var1);

        default public Builder certificate(Consumer<ManagedCertificate.Builder> certificate) {
            return this.certificate((ManagedCertificate)((ManagedCertificate.Builder)ManagedCertificate.builder().applyMutation(certificate)).build());
        }

        public Builder listener(ManagedListener var1);

        default public Builder listener(Consumer<ManagedListener.Builder> listener) {
            return this.listener((ManagedListener)((ManagedListener.Builder)ManagedListener.builder().applyMutation(listener)).build());
        }

        public Builder rule(ManagedListenerRule var1);

        default public Builder rule(Consumer<ManagedListenerRule.Builder> rule) {
            return this.rule((ManagedListenerRule)((ManagedListenerRule.Builder)ManagedListenerRule.builder().applyMutation(rule)).build());
        }

        public Builder targetGroups(Collection<ManagedTargetGroup> var1);

        public Builder targetGroups(ManagedTargetGroup ... var1);

        public Builder targetGroups(Consumer<ManagedTargetGroup.Builder> ... var1);
    }
}

