/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayContainer;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayScalingTarget;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayServiceNetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.IngressPathSummariesCopier;
import software.amazon.awssdk.services.ecs.model.IngressPathSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpressGatewayServiceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpressGatewayServiceConfiguration> {
    private static final SdkField<String> SERVICE_REVISION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRevisionArn").getter(ExpressGatewayServiceConfiguration.getter(ExpressGatewayServiceConfiguration::serviceRevisionArn)).setter(ExpressGatewayServiceConfiguration.setter(Builder::serviceRevisionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRevisionArn").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(ExpressGatewayServiceConfiguration.getter(ExpressGatewayServiceConfiguration::executionRoleArn)).setter(ExpressGatewayServiceConfiguration.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskRoleArn").getter(ExpressGatewayServiceConfiguration.getter(ExpressGatewayServiceConfiguration::taskRoleArn)).setter(ExpressGatewayServiceConfiguration.setter(Builder::taskRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()}).build();
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpu").getter(ExpressGatewayServiceConfiguration.getter(ExpressGatewayServiceConfiguration::cpu)).setter(ExpressGatewayServiceConfiguration.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memory").getter(ExpressGatewayServiceConfiguration.getter(ExpressGatewayServiceConfiguration::memory)).setter(ExpressGatewayServiceConfiguration.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<ExpressGatewayServiceNetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(ExpressGatewayServiceConfiguration.getter(ExpressGatewayServiceConfiguration::networkConfiguration)).setter(ExpressGatewayServiceConfiguration.setter(Builder::networkConfiguration)).constructor(ExpressGatewayServiceNetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("healthCheckPath").getter(ExpressGatewayServiceConfiguration.getter(ExpressGatewayServiceConfiguration::healthCheckPath)).setter(ExpressGatewayServiceConfiguration.setter(Builder::healthCheckPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckPath").build()}).build();
    private static final SdkField<ExpressGatewayContainer> PRIMARY_CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("primaryContainer").getter(ExpressGatewayServiceConfiguration.getter(ExpressGatewayServiceConfiguration::primaryContainer)).setter(ExpressGatewayServiceConfiguration.setter(Builder::primaryContainer)).constructor(ExpressGatewayContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryContainer").build()}).build();
    private static final SdkField<ExpressGatewayScalingTarget> SCALING_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalingTarget").getter(ExpressGatewayServiceConfiguration.getter(ExpressGatewayServiceConfiguration::scalingTarget)).setter(ExpressGatewayServiceConfiguration.setter(Builder::scalingTarget)).constructor(ExpressGatewayScalingTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingTarget").build()}).build();
    private static final SdkField<List<IngressPathSummary>> INGRESS_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ingressPaths").getter(ExpressGatewayServiceConfiguration.getter(ExpressGatewayServiceConfiguration::ingressPaths)).setter(ExpressGatewayServiceConfiguration.setter(Builder::ingressPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IngressPathSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ExpressGatewayServiceConfiguration.getter(ExpressGatewayServiceConfiguration::createdAt)).setter(ExpressGatewayServiceConfiguration.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_REVISION_ARN_FIELD, EXECUTION_ROLE_ARN_FIELD, TASK_ROLE_ARN_FIELD, CPU_FIELD, MEMORY_FIELD, NETWORK_CONFIGURATION_FIELD, HEALTH_CHECK_PATH_FIELD, PRIMARY_CONTAINER_FIELD, SCALING_TARGET_FIELD, INGRESS_PATHS_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExpressGatewayServiceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceRevisionArn;
    private final String executionRoleArn;
    private final String taskRoleArn;
    private final String cpu;
    private final String memory;
    private final ExpressGatewayServiceNetworkConfiguration networkConfiguration;
    private final String healthCheckPath;
    private final ExpressGatewayContainer primaryContainer;
    private final ExpressGatewayScalingTarget scalingTarget;
    private final List<IngressPathSummary> ingressPaths;
    private final Instant createdAt;

    private ExpressGatewayServiceConfiguration(BuilderImpl builder) {
        this.serviceRevisionArn = builder.serviceRevisionArn;
        this.executionRoleArn = builder.executionRoleArn;
        this.taskRoleArn = builder.taskRoleArn;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.networkConfiguration = builder.networkConfiguration;
        this.healthCheckPath = builder.healthCheckPath;
        this.primaryContainer = builder.primaryContainer;
        this.scalingTarget = builder.scalingTarget;
        this.ingressPaths = builder.ingressPaths;
        this.createdAt = builder.createdAt;
    }

    public final String serviceRevisionArn() {
        return this.serviceRevisionArn;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String taskRoleArn() {
        return this.taskRoleArn;
    }

    public final String cpu() {
        return this.cpu;
    }

    public final String memory() {
        return this.memory;
    }

    public final ExpressGatewayServiceNetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final String healthCheckPath() {
        return this.healthCheckPath;
    }

    public final ExpressGatewayContainer primaryContainer() {
        return this.primaryContainer;
    }

    public final ExpressGatewayScalingTarget scalingTarget() {
        return this.scalingTarget;
    }

    public final boolean hasIngressPaths() {
        return this.ingressPaths != null && !(this.ingressPaths instanceof SdkAutoConstructList);
    }

    public final List<IngressPathSummary> ingressPaths() {
        return this.ingressPaths;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRevisionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryContainer());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIngressPaths() ? this.ingressPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpressGatewayServiceConfiguration)) {
            return false;
        }
        ExpressGatewayServiceConfiguration other = (ExpressGatewayServiceConfiguration)obj;
        return Objects.equals(this.serviceRevisionArn(), other.serviceRevisionArn()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.taskRoleArn(), other.taskRoleArn()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.primaryContainer(), other.primaryContainer()) && Objects.equals(this.scalingTarget(), other.scalingTarget()) && this.hasIngressPaths() == other.hasIngressPaths() && Objects.equals(this.ingressPaths(), other.ingressPaths()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"ExpressGatewayServiceConfiguration").add("ServiceRevisionArn", (Object)this.serviceRevisionArn()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("TaskRoleArn", (Object)this.taskRoleArn()).add("Cpu", (Object)this.cpu()).add("Memory", (Object)this.memory()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("HealthCheckPath", (Object)this.healthCheckPath()).add("PrimaryContainer", (Object)this.primaryContainer()).add("ScalingTarget", (Object)this.scalingTarget()).add("IngressPaths", this.hasIngressPaths() ? this.ingressPaths() : null).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceRevisionArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRevisionArn()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "taskRoleArn": {
                return Optional.ofNullable(clazz.cast(this.taskRoleArn()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "healthCheckPath": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPath()));
            }
            case "primaryContainer": {
                return Optional.ofNullable(clazz.cast(this.primaryContainer()));
            }
            case "scalingTarget": {
                return Optional.ofNullable(clazz.cast(this.scalingTarget()));
            }
            case "ingressPaths": {
                return Optional.ofNullable(clazz.cast(this.ingressPaths()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceRevisionArn", SERVICE_REVISION_ARN_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("taskRoleArn", TASK_ROLE_ARN_FIELD);
        map.put("cpu", CPU_FIELD);
        map.put("memory", MEMORY_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("healthCheckPath", HEALTH_CHECK_PATH_FIELD);
        map.put("primaryContainer", PRIMARY_CONTAINER_FIELD);
        map.put("scalingTarget", SCALING_TARGET_FIELD);
        map.put("ingressPaths", INGRESS_PATHS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpressGatewayServiceConfiguration, T> g) {
        return obj -> g.apply((ExpressGatewayServiceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceRevisionArn;
        private String executionRoleArn;
        private String taskRoleArn;
        private String cpu;
        private String memory;
        private ExpressGatewayServiceNetworkConfiguration networkConfiguration;
        private String healthCheckPath;
        private ExpressGatewayContainer primaryContainer;
        private ExpressGatewayScalingTarget scalingTarget;
        private List<IngressPathSummary> ingressPaths = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpressGatewayServiceConfiguration model) {
            this.serviceRevisionArn(model.serviceRevisionArn);
            this.executionRoleArn(model.executionRoleArn);
            this.taskRoleArn(model.taskRoleArn);
            this.cpu(model.cpu);
            this.memory(model.memory);
            this.networkConfiguration(model.networkConfiguration);
            this.healthCheckPath(model.healthCheckPath);
            this.primaryContainer(model.primaryContainer);
            this.scalingTarget(model.scalingTarget);
            this.ingressPaths(model.ingressPaths);
            this.createdAt(model.createdAt);
        }

        public final String getServiceRevisionArn() {
            return this.serviceRevisionArn;
        }

        public final void setServiceRevisionArn(String serviceRevisionArn) {
            this.serviceRevisionArn = serviceRevisionArn;
        }

        @Override
        public final Builder serviceRevisionArn(String serviceRevisionArn) {
            this.serviceRevisionArn = serviceRevisionArn;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final String getCpu() {
            return this.cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getMemory() {
            return this.memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final ExpressGatewayServiceNetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(ExpressGatewayServiceNetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(ExpressGatewayServiceNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final ExpressGatewayContainer.Builder getPrimaryContainer() {
            return this.primaryContainer != null ? this.primaryContainer.toBuilder() : null;
        }

        public final void setPrimaryContainer(ExpressGatewayContainer.BuilderImpl primaryContainer) {
            this.primaryContainer = primaryContainer != null ? primaryContainer.build() : null;
        }

        @Override
        public final Builder primaryContainer(ExpressGatewayContainer primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        public final ExpressGatewayScalingTarget.Builder getScalingTarget() {
            return this.scalingTarget != null ? this.scalingTarget.toBuilder() : null;
        }

        public final void setScalingTarget(ExpressGatewayScalingTarget.BuilderImpl scalingTarget) {
            this.scalingTarget = scalingTarget != null ? scalingTarget.build() : null;
        }

        @Override
        public final Builder scalingTarget(ExpressGatewayScalingTarget scalingTarget) {
            this.scalingTarget = scalingTarget;
            return this;
        }

        public final List<IngressPathSummary.Builder> getIngressPaths() {
            List<IngressPathSummary.Builder> result = IngressPathSummariesCopier.copyToBuilder(this.ingressPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngressPaths(Collection<IngressPathSummary.BuilderImpl> ingressPaths) {
            this.ingressPaths = IngressPathSummariesCopier.copyFromBuilder(ingressPaths);
        }

        @Override
        public final Builder ingressPaths(Collection<IngressPathSummary> ingressPaths) {
            this.ingressPaths = IngressPathSummariesCopier.copy(ingressPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPaths(IngressPathSummary ... ingressPaths) {
            this.ingressPaths(Arrays.asList(ingressPaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPaths(Consumer<IngressPathSummary.Builder> ... ingressPaths) {
            this.ingressPaths(Stream.of(ingressPaths).map(c -> (IngressPathSummary)((IngressPathSummary.Builder)IngressPathSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public ExpressGatewayServiceConfiguration build() {
            return new ExpressGatewayServiceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpressGatewayServiceConfiguration> {
        public Builder serviceRevisionArn(String var1);

        public Builder executionRoleArn(String var1);

        public Builder taskRoleArn(String var1);

        public Builder cpu(String var1);

        public Builder memory(String var1);

        public Builder networkConfiguration(ExpressGatewayServiceNetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<ExpressGatewayServiceNetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((ExpressGatewayServiceNetworkConfiguration)((ExpressGatewayServiceNetworkConfiguration.Builder)ExpressGatewayServiceNetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder healthCheckPath(String var1);

        public Builder primaryContainer(ExpressGatewayContainer var1);

        default public Builder primaryContainer(Consumer<ExpressGatewayContainer.Builder> primaryContainer) {
            return this.primaryContainer((ExpressGatewayContainer)((ExpressGatewayContainer.Builder)ExpressGatewayContainer.builder().applyMutation(primaryContainer)).build());
        }

        public Builder scalingTarget(ExpressGatewayScalingTarget var1);

        default public Builder scalingTarget(Consumer<ExpressGatewayScalingTarget.Builder> scalingTarget) {
            return this.scalingTarget((ExpressGatewayScalingTarget)((ExpressGatewayScalingTarget.Builder)ExpressGatewayScalingTarget.builder().applyMutation(scalingTarget)).build());
        }

        public Builder ingressPaths(Collection<IngressPathSummary> var1);

        public Builder ingressPaths(IngressPathSummary ... var1);

        public Builder ingressPaths(Consumer<IngressPathSummary.Builder> ... var1);

        public Builder createdAt(Instant var1);
    }
}

