/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ManagedAutoScaling;
import software.amazon.awssdk.services.ecs.model.ManagedIngressPath;
import software.amazon.awssdk.services.ecs.model.ManagedIngressPathsCopier;
import software.amazon.awssdk.services.ecs.model.ManagedLogGroup;
import software.amazon.awssdk.services.ecs.model.ManagedLogGroupsCopier;
import software.amazon.awssdk.services.ecs.model.ManagedMetricAlarm;
import software.amazon.awssdk.services.ecs.model.ManagedMetricAlarmsCopier;
import software.amazon.awssdk.services.ecs.model.ManagedSecurityGroup;
import software.amazon.awssdk.services.ecs.model.ManagedSecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ECSManagedResources
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ECSManagedResources> {
    private static final SdkField<List<ManagedIngressPath>> INGRESS_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ingressPaths").getter(ECSManagedResources.getter(ECSManagedResources::ingressPaths)).setter(ECSManagedResources.setter(Builder::ingressPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedIngressPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ManagedAutoScaling> AUTO_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoScaling").getter(ECSManagedResources.getter(ECSManagedResources::autoScaling)).setter(ECSManagedResources.setter(Builder::autoScaling)).constructor(ManagedAutoScaling::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScaling").build()}).build();
    private static final SdkField<List<ManagedMetricAlarm>> METRIC_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricAlarms").getter(ECSManagedResources.getter(ECSManagedResources::metricAlarms)).setter(ECSManagedResources.setter(Builder::metricAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedMetricAlarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ManagedSecurityGroup>> SERVICE_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceSecurityGroups").getter(ECSManagedResources.getter(ECSManagedResources::serviceSecurityGroups)).setter(ECSManagedResources.setter(Builder::serviceSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ManagedLogGroup>> LOG_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroups").getter(ECSManagedResources.getter(ECSManagedResources::logGroups)).setter(ECSManagedResources.setter(Builder::logGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedLogGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGRESS_PATHS_FIELD, AUTO_SCALING_FIELD, METRIC_ALARMS_FIELD, SERVICE_SECURITY_GROUPS_FIELD, LOG_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ECSManagedResources.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ManagedIngressPath> ingressPaths;
    private final ManagedAutoScaling autoScaling;
    private final List<ManagedMetricAlarm> metricAlarms;
    private final List<ManagedSecurityGroup> serviceSecurityGroups;
    private final List<ManagedLogGroup> logGroups;

    private ECSManagedResources(BuilderImpl builder) {
        this.ingressPaths = builder.ingressPaths;
        this.autoScaling = builder.autoScaling;
        this.metricAlarms = builder.metricAlarms;
        this.serviceSecurityGroups = builder.serviceSecurityGroups;
        this.logGroups = builder.logGroups;
    }

    public final boolean hasIngressPaths() {
        return this.ingressPaths != null && !(this.ingressPaths instanceof SdkAutoConstructList);
    }

    public final List<ManagedIngressPath> ingressPaths() {
        return this.ingressPaths;
    }

    public final ManagedAutoScaling autoScaling() {
        return this.autoScaling;
    }

    public final boolean hasMetricAlarms() {
        return this.metricAlarms != null && !(this.metricAlarms instanceof SdkAutoConstructList);
    }

    public final List<ManagedMetricAlarm> metricAlarms() {
        return this.metricAlarms;
    }

    public final boolean hasServiceSecurityGroups() {
        return this.serviceSecurityGroups != null && !(this.serviceSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<ManagedSecurityGroup> serviceSecurityGroups() {
        return this.serviceSecurityGroups;
    }

    public final boolean hasLogGroups() {
        return this.logGroups != null && !(this.logGroups instanceof SdkAutoConstructList);
    }

    public final List<ManagedLogGroup> logGroups() {
        return this.logGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIngressPaths() ? this.ingressPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricAlarms() ? this.metricAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceSecurityGroups() ? this.serviceSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroups() ? this.logGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSManagedResources)) {
            return false;
        }
        ECSManagedResources other = (ECSManagedResources)obj;
        return this.hasIngressPaths() == other.hasIngressPaths() && Objects.equals(this.ingressPaths(), other.ingressPaths()) && Objects.equals(this.autoScaling(), other.autoScaling()) && this.hasMetricAlarms() == other.hasMetricAlarms() && Objects.equals(this.metricAlarms(), other.metricAlarms()) && this.hasServiceSecurityGroups() == other.hasServiceSecurityGroups() && Objects.equals(this.serviceSecurityGroups(), other.serviceSecurityGroups()) && this.hasLogGroups() == other.hasLogGroups() && Objects.equals(this.logGroups(), other.logGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ECSManagedResources").add("IngressPaths", this.hasIngressPaths() ? this.ingressPaths() : null).add("AutoScaling", (Object)this.autoScaling()).add("MetricAlarms", this.hasMetricAlarms() ? this.metricAlarms() : null).add("ServiceSecurityGroups", this.hasServiceSecurityGroups() ? this.serviceSecurityGroups() : null).add("LogGroups", this.hasLogGroups() ? this.logGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ingressPaths": {
                return Optional.ofNullable(clazz.cast(this.ingressPaths()));
            }
            case "autoScaling": {
                return Optional.ofNullable(clazz.cast(this.autoScaling()));
            }
            case "metricAlarms": {
                return Optional.ofNullable(clazz.cast(this.metricAlarms()));
            }
            case "serviceSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.serviceSecurityGroups()));
            }
            case "logGroups": {
                return Optional.ofNullable(clazz.cast(this.logGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ingressPaths", INGRESS_PATHS_FIELD);
        map.put("autoScaling", AUTO_SCALING_FIELD);
        map.put("metricAlarms", METRIC_ALARMS_FIELD);
        map.put("serviceSecurityGroups", SERVICE_SECURITY_GROUPS_FIELD);
        map.put("logGroups", LOG_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ECSManagedResources, T> g) {
        return obj -> g.apply((ECSManagedResources)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ManagedIngressPath> ingressPaths = DefaultSdkAutoConstructList.getInstance();
        private ManagedAutoScaling autoScaling;
        private List<ManagedMetricAlarm> metricAlarms = DefaultSdkAutoConstructList.getInstance();
        private List<ManagedSecurityGroup> serviceSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<ManagedLogGroup> logGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ECSManagedResources model) {
            this.ingressPaths(model.ingressPaths);
            this.autoScaling(model.autoScaling);
            this.metricAlarms(model.metricAlarms);
            this.serviceSecurityGroups(model.serviceSecurityGroups);
            this.logGroups(model.logGroups);
        }

        public final List<ManagedIngressPath.Builder> getIngressPaths() {
            List<ManagedIngressPath.Builder> result = ManagedIngressPathsCopier.copyToBuilder(this.ingressPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngressPaths(Collection<ManagedIngressPath.BuilderImpl> ingressPaths) {
            this.ingressPaths = ManagedIngressPathsCopier.copyFromBuilder(ingressPaths);
        }

        @Override
        public final Builder ingressPaths(Collection<ManagedIngressPath> ingressPaths) {
            this.ingressPaths = ManagedIngressPathsCopier.copy(ingressPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPaths(ManagedIngressPath ... ingressPaths) {
            this.ingressPaths(Arrays.asList(ingressPaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPaths(Consumer<ManagedIngressPath.Builder> ... ingressPaths) {
            this.ingressPaths(Stream.of(ingressPaths).map(c -> (ManagedIngressPath)((ManagedIngressPath.Builder)ManagedIngressPath.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ManagedAutoScaling.Builder getAutoScaling() {
            return this.autoScaling != null ? this.autoScaling.toBuilder() : null;
        }

        public final void setAutoScaling(ManagedAutoScaling.BuilderImpl autoScaling) {
            this.autoScaling = autoScaling != null ? autoScaling.build() : null;
        }

        @Override
        public final Builder autoScaling(ManagedAutoScaling autoScaling) {
            this.autoScaling = autoScaling;
            return this;
        }

        public final List<ManagedMetricAlarm.Builder> getMetricAlarms() {
            List<ManagedMetricAlarm.Builder> result = ManagedMetricAlarmsCopier.copyToBuilder(this.metricAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricAlarms(Collection<ManagedMetricAlarm.BuilderImpl> metricAlarms) {
            this.metricAlarms = ManagedMetricAlarmsCopier.copyFromBuilder(metricAlarms);
        }

        @Override
        public final Builder metricAlarms(Collection<ManagedMetricAlarm> metricAlarms) {
            this.metricAlarms = ManagedMetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(ManagedMetricAlarm ... metricAlarms) {
            this.metricAlarms(Arrays.asList(metricAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(Consumer<ManagedMetricAlarm.Builder> ... metricAlarms) {
            this.metricAlarms(Stream.of(metricAlarms).map(c -> (ManagedMetricAlarm)((ManagedMetricAlarm.Builder)ManagedMetricAlarm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ManagedSecurityGroup.Builder> getServiceSecurityGroups() {
            List<ManagedSecurityGroup.Builder> result = ManagedSecurityGroupsCopier.copyToBuilder(this.serviceSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceSecurityGroups(Collection<ManagedSecurityGroup.BuilderImpl> serviceSecurityGroups) {
            this.serviceSecurityGroups = ManagedSecurityGroupsCopier.copyFromBuilder(serviceSecurityGroups);
        }

        @Override
        public final Builder serviceSecurityGroups(Collection<ManagedSecurityGroup> serviceSecurityGroups) {
            this.serviceSecurityGroups = ManagedSecurityGroupsCopier.copy(serviceSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSecurityGroups(ManagedSecurityGroup ... serviceSecurityGroups) {
            this.serviceSecurityGroups(Arrays.asList(serviceSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSecurityGroups(Consumer<ManagedSecurityGroup.Builder> ... serviceSecurityGroups) {
            this.serviceSecurityGroups(Stream.of(serviceSecurityGroups).map(c -> (ManagedSecurityGroup)((ManagedSecurityGroup.Builder)ManagedSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ManagedLogGroup.Builder> getLogGroups() {
            List<ManagedLogGroup.Builder> result = ManagedLogGroupsCopier.copyToBuilder(this.logGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogGroups(Collection<ManagedLogGroup.BuilderImpl> logGroups) {
            this.logGroups = ManagedLogGroupsCopier.copyFromBuilder(logGroups);
        }

        @Override
        public final Builder logGroups(Collection<ManagedLogGroup> logGroups) {
            this.logGroups = ManagedLogGroupsCopier.copy(logGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(ManagedLogGroup ... logGroups) {
            this.logGroups(Arrays.asList(logGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(Consumer<ManagedLogGroup.Builder> ... logGroups) {
            this.logGroups(Stream.of(logGroups).map(c -> (ManagedLogGroup)((ManagedLogGroup.Builder)ManagedLogGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ECSManagedResources build() {
            return new ECSManagedResources(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ECSManagedResources> {
        public Builder ingressPaths(Collection<ManagedIngressPath> var1);

        public Builder ingressPaths(ManagedIngressPath ... var1);

        public Builder ingressPaths(Consumer<ManagedIngressPath.Builder> ... var1);

        public Builder autoScaling(ManagedAutoScaling var1);

        default public Builder autoScaling(Consumer<ManagedAutoScaling.Builder> autoScaling) {
            return this.autoScaling((ManagedAutoScaling)((ManagedAutoScaling.Builder)ManagedAutoScaling.builder().applyMutation(autoScaling)).build());
        }

        public Builder metricAlarms(Collection<ManagedMetricAlarm> var1);

        public Builder metricAlarms(ManagedMetricAlarm ... var1);

        public Builder metricAlarms(Consumer<ManagedMetricAlarm.Builder> ... var1);

        public Builder serviceSecurityGroups(Collection<ManagedSecurityGroup> var1);

        public Builder serviceSecurityGroups(ManagedSecurityGroup ... var1);

        public Builder serviceSecurityGroups(Consumer<ManagedSecurityGroup.Builder> ... var1);

        public Builder logGroups(Collection<ManagedLogGroup> var1);

        public Builder logGroups(ManagedLogGroup ... var1);

        public Builder logGroups(Consumer<ManagedLogGroup.Builder> ... var1);
    }
}

