/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ContainerInstance;
import software.amazon.awssdk.services.ecs.model.ContainerInstancesCopier;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.Failure;
import software.amazon.awssdk.services.ecs.model.FailuresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeContainerInstancesResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, DescribeContainerInstancesResponse> {
    private static final SdkField<List<ContainerInstance>> CONTAINER_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerInstances").getter(DescribeContainerInstancesResponse.getter(DescribeContainerInstancesResponse::containerInstances)).setter(DescribeContainerInstancesResponse.setter(Builder::containerInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(DescribeContainerInstancesResponse.getter(DescribeContainerInstancesResponse::failures)).setter(DescribeContainerInstancesResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Failure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_INSTANCES_FIELD, FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeContainerInstancesResponse.memberNameToFieldInitializer();
    private final List<ContainerInstance> containerInstances;
    private final List<Failure> failures;

    private DescribeContainerInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.containerInstances = builder.containerInstances;
        this.failures = builder.failures;
    }

    public final boolean hasContainerInstances() {
        return this.containerInstances != null && !(this.containerInstances instanceof SdkAutoConstructList);
    }

    public final List<ContainerInstance> containerInstances() {
        return this.containerInstances;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<Failure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerInstances() ? this.containerInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContainerInstancesResponse)) {
            return false;
        }
        DescribeContainerInstancesResponse other = (DescribeContainerInstancesResponse)((Object)obj);
        return this.hasContainerInstances() == other.hasContainerInstances() && Objects.equals(this.containerInstances(), other.containerInstances()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeContainerInstancesResponse").add("ContainerInstances", this.hasContainerInstances() ? this.containerInstances() : null).add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerInstances": {
                return Optional.ofNullable(clazz.cast(this.containerInstances()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("containerInstances", CONTAINER_INSTANCES_FIELD);
        map.put("failures", FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeContainerInstancesResponse, T> g) {
        return obj -> g.apply((DescribeContainerInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<ContainerInstance> containerInstances = DefaultSdkAutoConstructList.getInstance();
        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContainerInstancesResponse model) {
            super(model);
            this.containerInstances(model.containerInstances);
            this.failures(model.failures);
        }

        public final List<ContainerInstance.Builder> getContainerInstances() {
            List<ContainerInstance.Builder> result = ContainerInstancesCopier.copyToBuilder(this.containerInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerInstances(Collection<ContainerInstance.BuilderImpl> containerInstances) {
            this.containerInstances = ContainerInstancesCopier.copyFromBuilder(containerInstances);
        }

        @Override
        public final Builder containerInstances(Collection<ContainerInstance> containerInstances) {
            this.containerInstances = ContainerInstancesCopier.copy(containerInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerInstances(ContainerInstance ... containerInstances) {
            this.containerInstances(Arrays.asList(containerInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerInstances(Consumer<ContainerInstance.Builder> ... containerInstances) {
            this.containerInstances(Stream.of(containerInstances).map(c -> (ContainerInstance)((ContainerInstance.Builder)ContainerInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Failure.Builder> getFailures() {
            List<Failure.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (Failure)((Failure.Builder)Failure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeContainerInstancesResponse build() {
            return new DescribeContainerInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeContainerInstancesResponse> {
        public Builder containerInstances(Collection<ContainerInstance> var1);

        public Builder containerInstances(ContainerInstance ... var1);

        public Builder containerInstances(Consumer<ContainerInstance.Builder> ... var1);

        public Builder failures(Collection<Failure> var1);

        public Builder failures(Failure ... var1);

        public Builder failures(Consumer<Failure.Builder> ... var1);
    }
}

