/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceRevisionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceRevisionSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ServiceRevisionSummary.getter(ServiceRevisionSummary::arn)).setter(ServiceRevisionSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Integer> REQUESTED_TASK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("requestedTaskCount").getter(ServiceRevisionSummary.getter(ServiceRevisionSummary::requestedTaskCount)).setter(ServiceRevisionSummary.setter(Builder::requestedTaskCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedTaskCount").build()}).build();
    private static final SdkField<Integer> RUNNING_TASK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("runningTaskCount").getter(ServiceRevisionSummary.getter(ServiceRevisionSummary::runningTaskCount)).setter(ServiceRevisionSummary.setter(Builder::runningTaskCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningTaskCount").build()}).build();
    private static final SdkField<Integer> PENDING_TASK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("pendingTaskCount").getter(ServiceRevisionSummary.getter(ServiceRevisionSummary::pendingTaskCount)).setter(ServiceRevisionSummary.setter(Builder::pendingTaskCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingTaskCount").build()}).build();
    private static final SdkField<Double> REQUESTED_TEST_TRAFFIC_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("requestedTestTrafficWeight").getter(ServiceRevisionSummary.getter(ServiceRevisionSummary::requestedTestTrafficWeight)).setter(ServiceRevisionSummary.setter(Builder::requestedTestTrafficWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedTestTrafficWeight").build()}).build();
    private static final SdkField<Double> REQUESTED_PRODUCTION_TRAFFIC_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("requestedProductionTrafficWeight").getter(ServiceRevisionSummary.getter(ServiceRevisionSummary::requestedProductionTrafficWeight)).setter(ServiceRevisionSummary.setter(Builder::requestedProductionTrafficWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedProductionTrafficWeight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, REQUESTED_TASK_COUNT_FIELD, RUNNING_TASK_COUNT_FIELD, PENDING_TASK_COUNT_FIELD, REQUESTED_TEST_TRAFFIC_WEIGHT_FIELD, REQUESTED_PRODUCTION_TRAFFIC_WEIGHT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceRevisionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Integer requestedTaskCount;
    private final Integer runningTaskCount;
    private final Integer pendingTaskCount;
    private final Double requestedTestTrafficWeight;
    private final Double requestedProductionTrafficWeight;

    private ServiceRevisionSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.requestedTaskCount = builder.requestedTaskCount;
        this.runningTaskCount = builder.runningTaskCount;
        this.pendingTaskCount = builder.pendingTaskCount;
        this.requestedTestTrafficWeight = builder.requestedTestTrafficWeight;
        this.requestedProductionTrafficWeight = builder.requestedProductionTrafficWeight;
    }

    public final String arn() {
        return this.arn;
    }

    public final Integer requestedTaskCount() {
        return this.requestedTaskCount;
    }

    public final Integer runningTaskCount() {
        return this.runningTaskCount;
    }

    public final Integer pendingTaskCount() {
        return this.pendingTaskCount;
    }

    public final Double requestedTestTrafficWeight() {
        return this.requestedTestTrafficWeight;
    }

    public final Double requestedProductionTrafficWeight() {
        return this.requestedProductionTrafficWeight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedTestTrafficWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedProductionTrafficWeight());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceRevisionSummary)) {
            return false;
        }
        ServiceRevisionSummary other = (ServiceRevisionSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.requestedTaskCount(), other.requestedTaskCount()) && Objects.equals(this.runningTaskCount(), other.runningTaskCount()) && Objects.equals(this.pendingTaskCount(), other.pendingTaskCount()) && Objects.equals(this.requestedTestTrafficWeight(), other.requestedTestTrafficWeight()) && Objects.equals(this.requestedProductionTrafficWeight(), other.requestedProductionTrafficWeight());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceRevisionSummary").add("Arn", (Object)this.arn()).add("RequestedTaskCount", (Object)this.requestedTaskCount()).add("RunningTaskCount", (Object)this.runningTaskCount()).add("PendingTaskCount", (Object)this.pendingTaskCount()).add("RequestedTestTrafficWeight", (Object)this.requestedTestTrafficWeight()).add("RequestedProductionTrafficWeight", (Object)this.requestedProductionTrafficWeight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "requestedTaskCount": {
                return Optional.ofNullable(clazz.cast(this.requestedTaskCount()));
            }
            case "runningTaskCount": {
                return Optional.ofNullable(clazz.cast(this.runningTaskCount()));
            }
            case "pendingTaskCount": {
                return Optional.ofNullable(clazz.cast(this.pendingTaskCount()));
            }
            case "requestedTestTrafficWeight": {
                return Optional.ofNullable(clazz.cast(this.requestedTestTrafficWeight()));
            }
            case "requestedProductionTrafficWeight": {
                return Optional.ofNullable(clazz.cast(this.requestedProductionTrafficWeight()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("requestedTaskCount", REQUESTED_TASK_COUNT_FIELD);
        map.put("runningTaskCount", RUNNING_TASK_COUNT_FIELD);
        map.put("pendingTaskCount", PENDING_TASK_COUNT_FIELD);
        map.put("requestedTestTrafficWeight", REQUESTED_TEST_TRAFFIC_WEIGHT_FIELD);
        map.put("requestedProductionTrafficWeight", REQUESTED_PRODUCTION_TRAFFIC_WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceRevisionSummary, T> g) {
        return obj -> g.apply((ServiceRevisionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Integer requestedTaskCount;
        private Integer runningTaskCount;
        private Integer pendingTaskCount;
        private Double requestedTestTrafficWeight;
        private Double requestedProductionTrafficWeight;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceRevisionSummary model) {
            this.arn(model.arn);
            this.requestedTaskCount(model.requestedTaskCount);
            this.runningTaskCount(model.runningTaskCount);
            this.pendingTaskCount(model.pendingTaskCount);
            this.requestedTestTrafficWeight(model.requestedTestTrafficWeight);
            this.requestedProductionTrafficWeight(model.requestedProductionTrafficWeight);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getRequestedTaskCount() {
            return this.requestedTaskCount;
        }

        public final void setRequestedTaskCount(Integer requestedTaskCount) {
            this.requestedTaskCount = requestedTaskCount;
        }

        @Override
        public final Builder requestedTaskCount(Integer requestedTaskCount) {
            this.requestedTaskCount = requestedTaskCount;
            return this;
        }

        public final Integer getRunningTaskCount() {
            return this.runningTaskCount;
        }

        public final void setRunningTaskCount(Integer runningTaskCount) {
            this.runningTaskCount = runningTaskCount;
        }

        @Override
        public final Builder runningTaskCount(Integer runningTaskCount) {
            this.runningTaskCount = runningTaskCount;
            return this;
        }

        public final Integer getPendingTaskCount() {
            return this.pendingTaskCount;
        }

        public final void setPendingTaskCount(Integer pendingTaskCount) {
            this.pendingTaskCount = pendingTaskCount;
        }

        @Override
        public final Builder pendingTaskCount(Integer pendingTaskCount) {
            this.pendingTaskCount = pendingTaskCount;
            return this;
        }

        public final Double getRequestedTestTrafficWeight() {
            return this.requestedTestTrafficWeight;
        }

        public final void setRequestedTestTrafficWeight(Double requestedTestTrafficWeight) {
            this.requestedTestTrafficWeight = requestedTestTrafficWeight;
        }

        @Override
        public final Builder requestedTestTrafficWeight(Double requestedTestTrafficWeight) {
            this.requestedTestTrafficWeight = requestedTestTrafficWeight;
            return this;
        }

        public final Double getRequestedProductionTrafficWeight() {
            return this.requestedProductionTrafficWeight;
        }

        public final void setRequestedProductionTrafficWeight(Double requestedProductionTrafficWeight) {
            this.requestedProductionTrafficWeight = requestedProductionTrafficWeight;
        }

        @Override
        public final Builder requestedProductionTrafficWeight(Double requestedProductionTrafficWeight) {
            this.requestedProductionTrafficWeight = requestedProductionTrafficWeight;
            return this;
        }

        public ServiceRevisionSummary build() {
            return new ServiceRevisionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceRevisionSummary> {
        public Builder arn(String var1);

        public Builder requestedTaskCount(Integer var1);

        public Builder runningTaskCount(Integer var1);

        public Builder pendingTaskCount(Integer var1);

        public Builder requestedTestTrafficWeight(Double var1);

        public Builder requestedProductionTrafficWeight(Double var1);
    }
}

