/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ManagedAgentName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedAgent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedAgent> {
    private static final SdkField<Instant> LAST_STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStartedAt").getter(ManagedAgent.getter(ManagedAgent::lastStartedAt)).setter(ManagedAgent.setter(Builder::lastStartedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartedAt").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ManagedAgent.getter(ManagedAgent::nameAsString)).setter(ManagedAgent.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(ManagedAgent.getter(ManagedAgent::reason)).setter(ManagedAgent.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastStatus").getter(ManagedAgent.getter(ManagedAgent::lastStatus)).setter(ManagedAgent.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_STARTED_AT_FIELD, NAME_FIELD, REASON_FIELD, LAST_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedAgent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant lastStartedAt;
    private final String name;
    private final String reason;
    private final String lastStatus;

    private ManagedAgent(BuilderImpl builder) {
        this.lastStartedAt = builder.lastStartedAt;
        this.name = builder.name;
        this.reason = builder.reason;
        this.lastStatus = builder.lastStatus;
    }

    public final Instant lastStartedAt() {
        return this.lastStartedAt;
    }

    public final ManagedAgentName name() {
        return ManagedAgentName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final String reason() {
        return this.reason;
    }

    public final String lastStatus() {
        return this.lastStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedAgent)) {
            return false;
        }
        ManagedAgent other = (ManagedAgent)obj;
        return Objects.equals(this.lastStartedAt(), other.lastStartedAt()) && Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.lastStatus(), other.lastStatus());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedAgent").add("LastStartedAt", (Object)this.lastStartedAt()).add("Name", (Object)this.nameAsString()).add("Reason", (Object)this.reason()).add("LastStatus", (Object)this.lastStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lastStartedAt": {
                return Optional.ofNullable(clazz.cast(this.lastStartedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "lastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lastStartedAt", LAST_STARTED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("lastStatus", LAST_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedAgent, T> g) {
        return obj -> g.apply((ManagedAgent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant lastStartedAt;
        private String name;
        private String reason;
        private String lastStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedAgent model) {
            this.lastStartedAt(model.lastStartedAt);
            this.name(model.name);
            this.reason(model.reason);
            this.lastStatus(model.lastStatus);
        }

        public final Instant getLastStartedAt() {
            return this.lastStartedAt;
        }

        public final void setLastStartedAt(Instant lastStartedAt) {
            this.lastStartedAt = lastStartedAt;
        }

        @Override
        public final Builder lastStartedAt(Instant lastStartedAt) {
            this.lastStartedAt = lastStartedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ManagedAgentName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        public ManagedAgent build() {
            return new ManagedAgent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedAgent> {
        public Builder lastStartedAt(Instant var1);

        public Builder name(String var1);

        public Builder name(ManagedAgentName var1);

        public Builder reason(String var1);

        public Builder lastStatus(String var1);
    }
}

