/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateExpressGatewayServiceRequest extends EcsRequest implements
        ToCopyableBuilder<UpdateExpressGatewayServiceRequest.Builder, UpdateExpressGatewayServiceRequest> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceArn").getter(getter(UpdateExpressGatewayServiceRequest::serviceArn))
            .setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(UpdateExpressGatewayServiceRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("healthCheckPath").getter(getter(UpdateExpressGatewayServiceRequest::healthCheckPath))
            .setter(setter(Builder::healthCheckPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckPath").build()).build();

    private static final SdkField<ExpressGatewayContainer> PRIMARY_CONTAINER_FIELD = SdkField
            .<ExpressGatewayContainer> builder(MarshallingType.SDK_POJO).memberName("primaryContainer")
            .getter(getter(UpdateExpressGatewayServiceRequest::primaryContainer)).setter(setter(Builder::primaryContainer))
            .constructor(ExpressGatewayContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryContainer").build()).build();

    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskRoleArn").getter(getter(UpdateExpressGatewayServiceRequest::taskRoleArn))
            .setter(setter(Builder::taskRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()).build();

    private static final SdkField<ExpressGatewayServiceNetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<ExpressGatewayServiceNetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(UpdateExpressGatewayServiceRequest::networkConfiguration))
            .setter(setter(Builder::networkConfiguration)).constructor(ExpressGatewayServiceNetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<String> CPU_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cpu")
            .getter(getter(UpdateExpressGatewayServiceRequest::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final SdkField<String> MEMORY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("memory")
            .getter(getter(UpdateExpressGatewayServiceRequest::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<ExpressGatewayScalingTarget> SCALING_TARGET_FIELD = SdkField
            .<ExpressGatewayScalingTarget> builder(MarshallingType.SDK_POJO).memberName("scalingTarget")
            .getter(getter(UpdateExpressGatewayServiceRequest::scalingTarget)).setter(setter(Builder::scalingTarget))
            .constructor(ExpressGatewayScalingTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD,
            EXECUTION_ROLE_ARN_FIELD, HEALTH_CHECK_PATH_FIELD, PRIMARY_CONTAINER_FIELD, TASK_ROLE_ARN_FIELD,
            NETWORK_CONFIGURATION_FIELD, CPU_FIELD, MEMORY_FIELD, SCALING_TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceArn;

    private final String executionRoleArn;

    private final String healthCheckPath;

    private final ExpressGatewayContainer primaryContainer;

    private final String taskRoleArn;

    private final ExpressGatewayServiceNetworkConfiguration networkConfiguration;

    private final String cpu;

    private final String memory;

    private final ExpressGatewayScalingTarget scalingTarget;

    private UpdateExpressGatewayServiceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceArn = builder.serviceArn;
        this.executionRoleArn = builder.executionRoleArn;
        this.healthCheckPath = builder.healthCheckPath;
        this.primaryContainer = builder.primaryContainer;
        this.taskRoleArn = builder.taskRoleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.scalingTarget = builder.scalingTarget;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Express service to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Express service to update.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task execution role for the Express service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task execution role for the Express service.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The path on the container for Application Load Balancer health checks.
     * </p>
     * 
     * @return The path on the container for Application Load Balancer health checks.
     */
    public final String healthCheckPath() {
        return healthCheckPath;
    }

    /**
     * <p>
     * The primary container configuration for the Express service.
     * </p>
     * 
     * @return The primary container configuration for the Express service.
     */
    public final ExpressGatewayContainer primaryContainer() {
        return primaryContainer;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role for containers in this task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role for containers in this task.
     */
    public final String taskRoleArn() {
        return taskRoleArn;
    }

    /**
     * <p>
     * The network configuration for the Express service tasks. By default, the network configuration for an Express
     * service uses the default VPC.
     * </p>
     * 
     * @return The network configuration for the Express service tasks. By default, the network configuration for an
     *         Express service uses the default VPC.
     */
    public final ExpressGatewayServiceNetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The number of CPU units used by the task.
     * </p>
     * 
     * @return The number of CPU units used by the task.
     */
    public final String cpu() {
        return cpu;
    }

    /**
     * <p>
     * The amount of memory (in MiB) used by the task.
     * </p>
     * 
     * @return The amount of memory (in MiB) used by the task.
     */
    public final String memory() {
        return memory;
    }

    /**
     * <p>
     * The auto-scaling configuration for the Express service.
     * </p>
     * 
     * @return The auto-scaling configuration for the Express service.
     */
    public final ExpressGatewayScalingTarget scalingTarget() {
        return scalingTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(primaryContainer());
        hashCode = 31 * hashCode + Objects.hashCode(taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(scalingTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExpressGatewayServiceRequest)) {
            return false;
        }
        UpdateExpressGatewayServiceRequest other = (UpdateExpressGatewayServiceRequest) obj;
        return Objects.equals(serviceArn(), other.serviceArn()) && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(healthCheckPath(), other.healthCheckPath())
                && Objects.equals(primaryContainer(), other.primaryContainer())
                && Objects.equals(taskRoleArn(), other.taskRoleArn())
                && Objects.equals(networkConfiguration(), other.networkConfiguration()) && Objects.equals(cpu(), other.cpu())
                && Objects.equals(memory(), other.memory()) && Objects.equals(scalingTarget(), other.scalingTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateExpressGatewayServiceRequest").add("ServiceArn", serviceArn())
                .add("ExecutionRoleArn", executionRoleArn()).add("HealthCheckPath", healthCheckPath())
                .add("PrimaryContainer", primaryContainer()).add("TaskRoleArn", taskRoleArn())
                .add("NetworkConfiguration", networkConfiguration()).add("Cpu", cpu()).add("Memory", memory())
                .add("ScalingTarget", scalingTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "healthCheckPath":
            return Optional.ofNullable(clazz.cast(healthCheckPath()));
        case "primaryContainer":
            return Optional.ofNullable(clazz.cast(primaryContainer()));
        case "taskRoleArn":
            return Optional.ofNullable(clazz.cast(taskRoleArn()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "scalingTarget":
            return Optional.ofNullable(clazz.cast(scalingTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("healthCheckPath", HEALTH_CHECK_PATH_FIELD);
        map.put("primaryContainer", PRIMARY_CONTAINER_FIELD);
        map.put("taskRoleArn", TASK_ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("cpu", CPU_FIELD);
        map.put("memory", MEMORY_FIELD);
        map.put("scalingTarget", SCALING_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateExpressGatewayServiceRequest, T> g) {
        return obj -> g.apply((UpdateExpressGatewayServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateExpressGatewayServiceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Express service to update.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) of the Express service to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task execution role for the Express service.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the task execution role for the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The path on the container for Application Load Balancer health checks.
         * </p>
         * 
         * @param healthCheckPath
         *        The path on the container for Application Load Balancer health checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPath(String healthCheckPath);

        /**
         * <p>
         * The primary container configuration for the Express service.
         * </p>
         * 
         * @param primaryContainer
         *        The primary container configuration for the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryContainer(ExpressGatewayContainer primaryContainer);

        /**
         * <p>
         * The primary container configuration for the Express service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressGatewayContainer.Builder} avoiding
         * the need to create one manually via {@link ExpressGatewayContainer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayContainer.Builder#build()} is called immediately
         * and its result is passed to {@link #primaryContainer(ExpressGatewayContainer)}.
         * 
         * @param primaryContainer
         *        a consumer that will call methods on {@link ExpressGatewayContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryContainer(ExpressGatewayContainer)
         */
        default Builder primaryContainer(Consumer<ExpressGatewayContainer.Builder> primaryContainer) {
            return primaryContainer(ExpressGatewayContainer.builder().applyMutation(primaryContainer).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role for containers in this task.
         * </p>
         * 
         * @param taskRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role for containers in this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRoleArn(String taskRoleArn);

        /**
         * <p>
         * The network configuration for the Express service tasks. By default, the network configuration for an Express
         * service uses the default VPC.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for the Express service tasks. By default, the network configuration for an
         *        Express service uses the default VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(ExpressGatewayServiceNetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for the Express service tasks. By default, the network configuration for an Express
         * service uses the default VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExpressGatewayServiceNetworkConfiguration.Builder} avoiding the need to create one manually via
         * {@link ExpressGatewayServiceNetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayServiceNetworkConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #networkConfiguration(ExpressGatewayServiceNetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link ExpressGatewayServiceNetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(ExpressGatewayServiceNetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<ExpressGatewayServiceNetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(ExpressGatewayServiceNetworkConfiguration.builder().applyMutation(networkConfiguration)
                    .build());
        }

        /**
         * <p>
         * The number of CPU units used by the task.
         * </p>
         * 
         * @param cpu
         *        The number of CPU units used by the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(String cpu);

        /**
         * <p>
         * The amount of memory (in MiB) used by the task.
         * </p>
         * 
         * @param memory
         *        The amount of memory (in MiB) used by the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(String memory);

        /**
         * <p>
         * The auto-scaling configuration for the Express service.
         * </p>
         * 
         * @param scalingTarget
         *        The auto-scaling configuration for the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingTarget(ExpressGatewayScalingTarget scalingTarget);

        /**
         * <p>
         * The auto-scaling configuration for the Express service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressGatewayScalingTarget.Builder}
         * avoiding the need to create one manually via {@link ExpressGatewayScalingTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayScalingTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #scalingTarget(ExpressGatewayScalingTarget)}.
         * 
         * @param scalingTarget
         *        a consumer that will call methods on {@link ExpressGatewayScalingTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingTarget(ExpressGatewayScalingTarget)
         */
        default Builder scalingTarget(Consumer<ExpressGatewayScalingTarget.Builder> scalingTarget) {
            return scalingTarget(ExpressGatewayScalingTarget.builder().applyMutation(scalingTarget).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String serviceArn;

        private String executionRoleArn;

        private String healthCheckPath;

        private ExpressGatewayContainer primaryContainer;

        private String taskRoleArn;

        private ExpressGatewayServiceNetworkConfiguration networkConfiguration;

        private String cpu;

        private String memory;

        private ExpressGatewayScalingTarget scalingTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExpressGatewayServiceRequest model) {
            super(model);
            serviceArn(model.serviceArn);
            executionRoleArn(model.executionRoleArn);
            healthCheckPath(model.healthCheckPath);
            primaryContainer(model.primaryContainer);
            taskRoleArn(model.taskRoleArn);
            networkConfiguration(model.networkConfiguration);
            cpu(model.cpu);
            memory(model.memory);
            scalingTarget(model.scalingTarget);
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getHealthCheckPath() {
            return healthCheckPath;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final ExpressGatewayContainer.Builder getPrimaryContainer() {
            return primaryContainer != null ? primaryContainer.toBuilder() : null;
        }

        public final void setPrimaryContainer(ExpressGatewayContainer.BuilderImpl primaryContainer) {
            this.primaryContainer = primaryContainer != null ? primaryContainer.build() : null;
        }

        @Override
        public final Builder primaryContainer(ExpressGatewayContainer primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        public final String getTaskRoleArn() {
            return taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final ExpressGatewayServiceNetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(ExpressGatewayServiceNetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(ExpressGatewayServiceNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getCpu() {
            return cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getMemory() {
            return memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final ExpressGatewayScalingTarget.Builder getScalingTarget() {
            return scalingTarget != null ? scalingTarget.toBuilder() : null;
        }

        public final void setScalingTarget(ExpressGatewayScalingTarget.BuilderImpl scalingTarget) {
            this.scalingTarget = scalingTarget != null ? scalingTarget.build() : null;
        }

        @Override
        public final Builder scalingTarget(ExpressGatewayScalingTarget scalingTarget) {
            this.scalingTarget = scalingTarget;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExpressGatewayServiceRequest build() {
            return new UpdateExpressGatewayServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
