/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The entry point into the Express service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedIngressPath implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedIngressPath.Builder, ManagedIngressPath> {
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessType").getter(getter(ManagedIngressPath::accessTypeAsString)).setter(setter(Builder::accessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessType").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(ManagedIngressPath::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<ManagedLoadBalancer> LOAD_BALANCER_FIELD = SdkField
            .<ManagedLoadBalancer> builder(MarshallingType.SDK_POJO).memberName("loadBalancer")
            .getter(getter(ManagedIngressPath::loadBalancer)).setter(setter(Builder::loadBalancer))
            .constructor(ManagedLoadBalancer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancer").build()).build();

    private static final SdkField<List<ManagedSecurityGroup>> LOAD_BALANCER_SECURITY_GROUPS_FIELD = SdkField
            .<List<ManagedSecurityGroup>> builder(MarshallingType.LIST)
            .memberName("loadBalancerSecurityGroups")
            .getter(getter(ManagedIngressPath::loadBalancerSecurityGroups))
            .setter(setter(Builder::loadBalancerSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ManagedCertificate> CERTIFICATE_FIELD = SdkField
            .<ManagedCertificate> builder(MarshallingType.SDK_POJO).memberName("certificate")
            .getter(getter(ManagedIngressPath::certificate)).setter(setter(Builder::certificate))
            .constructor(ManagedCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()).build();

    private static final SdkField<ManagedListener> LISTENER_FIELD = SdkField.<ManagedListener> builder(MarshallingType.SDK_POJO)
            .memberName("listener").getter(getter(ManagedIngressPath::listener)).setter(setter(Builder::listener))
            .constructor(ManagedListener::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listener").build()).build();

    private static final SdkField<ManagedListenerRule> RULE_FIELD = SdkField
            .<ManagedListenerRule> builder(MarshallingType.SDK_POJO).memberName("rule").getter(getter(ManagedIngressPath::rule))
            .setter(setter(Builder::rule)).constructor(ManagedListenerRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()).build();

    private static final SdkField<List<ManagedTargetGroup>> TARGET_GROUPS_FIELD = SdkField
            .<List<ManagedTargetGroup>> builder(MarshallingType.LIST)
            .memberName("targetGroups")
            .getter(getter(ManagedIngressPath::targetGroups))
            .setter(setter(Builder::targetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedTargetGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedTargetGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPE_FIELD,
            ENDPOINT_FIELD, LOAD_BALANCER_FIELD, LOAD_BALANCER_SECURITY_GROUPS_FIELD, CERTIFICATE_FIELD, LISTENER_FIELD,
            RULE_FIELD, TARGET_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessType;

    private final String endpoint;

    private final ManagedLoadBalancer loadBalancer;

    private final List<ManagedSecurityGroup> loadBalancerSecurityGroups;

    private final ManagedCertificate certificate;

    private final ManagedListener listener;

    private final ManagedListenerRule rule;

    private final List<ManagedTargetGroup> targetGroups;

    private ManagedIngressPath(BuilderImpl builder) {
        this.accessType = builder.accessType;
        this.endpoint = builder.endpoint;
        this.loadBalancer = builder.loadBalancer;
        this.loadBalancerSecurityGroups = builder.loadBalancerSecurityGroups;
        this.certificate = builder.certificate;
        this.listener = builder.listener;
        this.rule = builder.rule;
        this.targetGroups = builder.targetGroups;
    }

    /**
     * <p>
     * The type of access to the endpoint for the Express service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessType} will
     * return {@link AccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTypeAsString}.
     * </p>
     * 
     * @return The type of access to the endpoint for the Express service.
     * @see AccessType
     */
    public final AccessType accessType() {
        return AccessType.fromValue(accessType);
    }

    /**
     * <p>
     * The type of access to the endpoint for the Express service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessType} will
     * return {@link AccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTypeAsString}.
     * </p>
     * 
     * @return The type of access to the endpoint for the Express service.
     * @see AccessType
     */
    public final String accessTypeAsString() {
        return accessType;
    }

    /**
     * <p>
     * The endpoint for access to the Express service.
     * </p>
     * 
     * @return The endpoint for access to the Express service.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The Application Load Balancer associated with the Express service.
     * </p>
     * 
     * @return The Application Load Balancer associated with the Express service.
     */
    public final ManagedLoadBalancer loadBalancer() {
        return loadBalancer;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancerSecurityGroups property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLoadBalancerSecurityGroups() {
        return loadBalancerSecurityGroups != null && !(loadBalancerSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups associated with the Application Load Balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancerSecurityGroups} method.
     * </p>
     * 
     * @return The security groups associated with the Application Load Balancer.
     */
    public final List<ManagedSecurityGroup> loadBalancerSecurityGroups() {
        return loadBalancerSecurityGroups;
    }

    /**
     * <p>
     * The ACM certificate for the Express service's domain.
     * </p>
     * 
     * @return The ACM certificate for the Express service's domain.
     */
    public final ManagedCertificate certificate() {
        return certificate;
    }

    /**
     * <p>
     * The listeners associated with the Application Load Balancer.
     * </p>
     * 
     * @return The listeners associated with the Application Load Balancer.
     */
    public final ManagedListener listener() {
        return listener;
    }

    /**
     * <p>
     * The listener rules for the Application Load Balancer.
     * </p>
     * 
     * @return The listener rules for the Application Load Balancer.
     */
    public final ManagedListenerRule rule() {
        return rule;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetGroups() {
        return targetGroups != null && !(targetGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target groups associated with the Application Load Balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetGroups} method.
     * </p>
     * 
     * @return The target groups associated with the Application Load Balancer.
     */
    public final List<ManagedTargetGroup> targetGroups() {
        return targetGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancer());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancerSecurityGroups() ? loadBalancerSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(listener());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetGroups() ? targetGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedIngressPath)) {
            return false;
        }
        ManagedIngressPath other = (ManagedIngressPath) obj;
        return Objects.equals(accessTypeAsString(), other.accessTypeAsString()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(loadBalancer(), other.loadBalancer())
                && hasLoadBalancerSecurityGroups() == other.hasLoadBalancerSecurityGroups()
                && Objects.equals(loadBalancerSecurityGroups(), other.loadBalancerSecurityGroups())
                && Objects.equals(certificate(), other.certificate()) && Objects.equals(listener(), other.listener())
                && Objects.equals(rule(), other.rule()) && hasTargetGroups() == other.hasTargetGroups()
                && Objects.equals(targetGroups(), other.targetGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedIngressPath").add("AccessType", accessTypeAsString()).add("Endpoint", endpoint())
                .add("LoadBalancer", loadBalancer())
                .add("LoadBalancerSecurityGroups", hasLoadBalancerSecurityGroups() ? loadBalancerSecurityGroups() : null)
                .add("Certificate", certificate()).add("Listener", listener()).add("Rule", rule())
                .add("TargetGroups", hasTargetGroups() ? targetGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessType":
            return Optional.ofNullable(clazz.cast(accessTypeAsString()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "loadBalancer":
            return Optional.ofNullable(clazz.cast(loadBalancer()));
        case "loadBalancerSecurityGroups":
            return Optional.ofNullable(clazz.cast(loadBalancerSecurityGroups()));
        case "certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "listener":
            return Optional.ofNullable(clazz.cast(listener()));
        case "rule":
            return Optional.ofNullable(clazz.cast(rule()));
        case "targetGroups":
            return Optional.ofNullable(clazz.cast(targetGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessType", ACCESS_TYPE_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("loadBalancer", LOAD_BALANCER_FIELD);
        map.put("loadBalancerSecurityGroups", LOAD_BALANCER_SECURITY_GROUPS_FIELD);
        map.put("certificate", CERTIFICATE_FIELD);
        map.put("listener", LISTENER_FIELD);
        map.put("rule", RULE_FIELD);
        map.put("targetGroups", TARGET_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedIngressPath, T> g) {
        return obj -> g.apply((ManagedIngressPath) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedIngressPath> {
        /**
         * <p>
         * The type of access to the endpoint for the Express service.
         * </p>
         * 
         * @param accessType
         *        The type of access to the endpoint for the Express service.
         * @see AccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessType
         */
        Builder accessType(String accessType);

        /**
         * <p>
         * The type of access to the endpoint for the Express service.
         * </p>
         * 
         * @param accessType
         *        The type of access to the endpoint for the Express service.
         * @see AccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessType
         */
        Builder accessType(AccessType accessType);

        /**
         * <p>
         * The endpoint for access to the Express service.
         * </p>
         * 
         * @param endpoint
         *        The endpoint for access to the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The Application Load Balancer associated with the Express service.
         * </p>
         * 
         * @param loadBalancer
         *        The Application Load Balancer associated with the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancer(ManagedLoadBalancer loadBalancer);

        /**
         * <p>
         * The Application Load Balancer associated with the Express service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedLoadBalancer.Builder} avoiding the
         * need to create one manually via {@link ManagedLoadBalancer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedLoadBalancer.Builder#build()} is called immediately and
         * its result is passed to {@link #loadBalancer(ManagedLoadBalancer)}.
         * 
         * @param loadBalancer
         *        a consumer that will call methods on {@link ManagedLoadBalancer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancer(ManagedLoadBalancer)
         */
        default Builder loadBalancer(Consumer<ManagedLoadBalancer.Builder> loadBalancer) {
            return loadBalancer(ManagedLoadBalancer.builder().applyMutation(loadBalancer).build());
        }

        /**
         * <p>
         * The security groups associated with the Application Load Balancer.
         * </p>
         * 
         * @param loadBalancerSecurityGroups
         *        The security groups associated with the Application Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerSecurityGroups(Collection<ManagedSecurityGroup> loadBalancerSecurityGroups);

        /**
         * <p>
         * The security groups associated with the Application Load Balancer.
         * </p>
         * 
         * @param loadBalancerSecurityGroups
         *        The security groups associated with the Application Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerSecurityGroups(ManagedSecurityGroup... loadBalancerSecurityGroups);

        /**
         * <p>
         * The security groups associated with the Application Load Balancer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ManagedSecurityGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ecs.model.ManagedSecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ManagedSecurityGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #loadBalancerSecurityGroups(List<ManagedSecurityGroup>)}.
         * 
         * @param loadBalancerSecurityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ManagedSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerSecurityGroups(java.util.Collection<ManagedSecurityGroup>)
         */
        Builder loadBalancerSecurityGroups(Consumer<ManagedSecurityGroup.Builder>... loadBalancerSecurityGroups);

        /**
         * <p>
         * The ACM certificate for the Express service's domain.
         * </p>
         * 
         * @param certificate
         *        The ACM certificate for the Express service's domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(ManagedCertificate certificate);

        /**
         * <p>
         * The ACM certificate for the Express service's domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedCertificate.Builder} avoiding the
         * need to create one manually via {@link ManagedCertificate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedCertificate.Builder#build()} is called immediately and its
         * result is passed to {@link #certificate(ManagedCertificate)}.
         * 
         * @param certificate
         *        a consumer that will call methods on {@link ManagedCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificate(ManagedCertificate)
         */
        default Builder certificate(Consumer<ManagedCertificate.Builder> certificate) {
            return certificate(ManagedCertificate.builder().applyMutation(certificate).build());
        }

        /**
         * <p>
         * The listeners associated with the Application Load Balancer.
         * </p>
         * 
         * @param listener
         *        The listeners associated with the Application Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listener(ManagedListener listener);

        /**
         * <p>
         * The listeners associated with the Application Load Balancer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedListener.Builder} avoiding the
         * need to create one manually via {@link ManagedListener#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedListener.Builder#build()} is called immediately and its
         * result is passed to {@link #listener(ManagedListener)}.
         * 
         * @param listener
         *        a consumer that will call methods on {@link ManagedListener.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listener(ManagedListener)
         */
        default Builder listener(Consumer<ManagedListener.Builder> listener) {
            return listener(ManagedListener.builder().applyMutation(listener).build());
        }

        /**
         * <p>
         * The listener rules for the Application Load Balancer.
         * </p>
         * 
         * @param rule
         *        The listener rules for the Application Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(ManagedListenerRule rule);

        /**
         * <p>
         * The listener rules for the Application Load Balancer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedListenerRule.Builder} avoiding the
         * need to create one manually via {@link ManagedListenerRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedListenerRule.Builder#build()} is called immediately and
         * its result is passed to {@link #rule(ManagedListenerRule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link ManagedListenerRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(ManagedListenerRule)
         */
        default Builder rule(Consumer<ManagedListenerRule.Builder> rule) {
            return rule(ManagedListenerRule.builder().applyMutation(rule).build());
        }

        /**
         * <p>
         * The target groups associated with the Application Load Balancer.
         * </p>
         * 
         * @param targetGroups
         *        The target groups associated with the Application Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(Collection<ManagedTargetGroup> targetGroups);

        /**
         * <p>
         * The target groups associated with the Application Load Balancer.
         * </p>
         * 
         * @param targetGroups
         *        The target groups associated with the Application Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(ManagedTargetGroup... targetGroups);

        /**
         * <p>
         * The target groups associated with the Application Load Balancer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ManagedTargetGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ManagedTargetGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ManagedTargetGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #targetGroups(List<ManagedTargetGroup>)}.
         * 
         * @param targetGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ManagedTargetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetGroups(java.util.Collection<ManagedTargetGroup>)
         */
        Builder targetGroups(Consumer<ManagedTargetGroup.Builder>... targetGroups);
    }

    static final class BuilderImpl implements Builder {
        private String accessType;

        private String endpoint;

        private ManagedLoadBalancer loadBalancer;

        private List<ManagedSecurityGroup> loadBalancerSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private ManagedCertificate certificate;

        private ManagedListener listener;

        private ManagedListenerRule rule;

        private List<ManagedTargetGroup> targetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedIngressPath model) {
            accessType(model.accessType);
            endpoint(model.endpoint);
            loadBalancer(model.loadBalancer);
            loadBalancerSecurityGroups(model.loadBalancerSecurityGroups);
            certificate(model.certificate);
            listener(model.listener);
            rule(model.rule);
            targetGroups(model.targetGroups);
        }

        public final String getAccessType() {
            return accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(AccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final ManagedLoadBalancer.Builder getLoadBalancer() {
            return loadBalancer != null ? loadBalancer.toBuilder() : null;
        }

        public final void setLoadBalancer(ManagedLoadBalancer.BuilderImpl loadBalancer) {
            this.loadBalancer = loadBalancer != null ? loadBalancer.build() : null;
        }

        @Override
        public final Builder loadBalancer(ManagedLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public final List<ManagedSecurityGroup.Builder> getLoadBalancerSecurityGroups() {
            List<ManagedSecurityGroup.Builder> result = ManagedSecurityGroupsCopier
                    .copyToBuilder(this.loadBalancerSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancerSecurityGroups(Collection<ManagedSecurityGroup.BuilderImpl> loadBalancerSecurityGroups) {
            this.loadBalancerSecurityGroups = ManagedSecurityGroupsCopier.copyFromBuilder(loadBalancerSecurityGroups);
        }

        @Override
        public final Builder loadBalancerSecurityGroups(Collection<ManagedSecurityGroup> loadBalancerSecurityGroups) {
            this.loadBalancerSecurityGroups = ManagedSecurityGroupsCopier.copy(loadBalancerSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerSecurityGroups(ManagedSecurityGroup... loadBalancerSecurityGroups) {
            loadBalancerSecurityGroups(Arrays.asList(loadBalancerSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerSecurityGroups(Consumer<ManagedSecurityGroup.Builder>... loadBalancerSecurityGroups) {
            loadBalancerSecurityGroups(Stream.of(loadBalancerSecurityGroups)
                    .map(c -> ManagedSecurityGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ManagedCertificate.Builder getCertificate() {
            return certificate != null ? certificate.toBuilder() : null;
        }

        public final void setCertificate(ManagedCertificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        @Override
        public final Builder certificate(ManagedCertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public final ManagedListener.Builder getListener() {
            return listener != null ? listener.toBuilder() : null;
        }

        public final void setListener(ManagedListener.BuilderImpl listener) {
            this.listener = listener != null ? listener.build() : null;
        }

        @Override
        public final Builder listener(ManagedListener listener) {
            this.listener = listener;
            return this;
        }

        public final ManagedListenerRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(ManagedListenerRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(ManagedListenerRule rule) {
            this.rule = rule;
            return this;
        }

        public final List<ManagedTargetGroup.Builder> getTargetGroups() {
            List<ManagedTargetGroup.Builder> result = ManagedTargetGroupsCopier.copyToBuilder(this.targetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetGroups(Collection<ManagedTargetGroup.BuilderImpl> targetGroups) {
            this.targetGroups = ManagedTargetGroupsCopier.copyFromBuilder(targetGroups);
        }

        @Override
        public final Builder targetGroups(Collection<ManagedTargetGroup> targetGroups) {
            this.targetGroups = ManagedTargetGroupsCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(ManagedTargetGroup... targetGroups) {
            targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(Consumer<ManagedTargetGroup.Builder>... targetGroups) {
            targetGroups(Stream.of(targetGroups).map(c -> ManagedTargetGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ManagedIngressPath build() {
            return new ManagedIngressPath(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
