/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The entry point into an Express service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngressPathSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IngressPathSummary.Builder, IngressPathSummary> {
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessType").getter(getter(IngressPathSummary::accessTypeAsString)).setter(setter(Builder::accessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessType").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(IngressPathSummary::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPE_FIELD,
            ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessType;

    private final String endpoint;

    private IngressPathSummary(BuilderImpl builder) {
        this.accessType = builder.accessType;
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * The type of access to the endpoint for the Express service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessType} will
     * return {@link AccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTypeAsString}.
     * </p>
     * 
     * @return The type of access to the endpoint for the Express service.
     * @see AccessType
     */
    public final AccessType accessType() {
        return AccessType.fromValue(accessType);
    }

    /**
     * <p>
     * The type of access to the endpoint for the Express service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessType} will
     * return {@link AccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTypeAsString}.
     * </p>
     * 
     * @return The type of access to the endpoint for the Express service.
     * @see AccessType
     */
    public final String accessTypeAsString() {
        return accessType;
    }

    /**
     * <p>
     * The endpoint for access to the service.
     * </p>
     * 
     * @return The endpoint for access to the service.
     */
    public final String endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressPathSummary)) {
            return false;
        }
        IngressPathSummary other = (IngressPathSummary) obj;
        return Objects.equals(accessTypeAsString(), other.accessTypeAsString()) && Objects.equals(endpoint(), other.endpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngressPathSummary").add("AccessType", accessTypeAsString()).add("Endpoint", endpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessType":
            return Optional.ofNullable(clazz.cast(accessTypeAsString()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessType", ACCESS_TYPE_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressPathSummary, T> g) {
        return obj -> g.apply((IngressPathSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngressPathSummary> {
        /**
         * <p>
         * The type of access to the endpoint for the Express service.
         * </p>
         * 
         * @param accessType
         *        The type of access to the endpoint for the Express service.
         * @see AccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessType
         */
        Builder accessType(String accessType);

        /**
         * <p>
         * The type of access to the endpoint for the Express service.
         * </p>
         * 
         * @param accessType
         *        The type of access to the endpoint for the Express service.
         * @see AccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessType
         */
        Builder accessType(AccessType accessType);

        /**
         * <p>
         * The endpoint for access to the service.
         * </p>
         * 
         * @param endpoint
         *        The endpoint for access to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);
    }

    static final class BuilderImpl implements Builder {
        private String accessType;

        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressPathSummary model) {
            accessType(model.accessType);
            endpoint(model.endpoint);
        }

        public final String getAccessType() {
            return accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(AccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public IngressPathSummary build() {
            return new IngressPathSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
