/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The repository credentials for private registry authentication to pass to the container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpressGatewayRepositoryCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<ExpressGatewayRepositoryCredentials.Builder, ExpressGatewayRepositoryCredentials> {
    private static final SdkField<String> CREDENTIALS_PARAMETER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsParameter").getter(getter(ExpressGatewayRepositoryCredentials::credentialsParameter))
            .setter(setter(Builder::credentialsParameter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsParameter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_PARAMETER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String credentialsParameter;

    private ExpressGatewayRepositoryCredentials(BuilderImpl builder) {
        this.credentialsParameter = builder.credentialsParameter;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
     */
    public final String credentialsParameter() {
        return credentialsParameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentialsParameter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpressGatewayRepositoryCredentials)) {
            return false;
        }
        ExpressGatewayRepositoryCredentials other = (ExpressGatewayRepositoryCredentials) obj;
        return Objects.equals(credentialsParameter(), other.credentialsParameter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpressGatewayRepositoryCredentials").add("CredentialsParameter", credentialsParameter())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "credentialsParameter":
            return Optional.ofNullable(clazz.cast(credentialsParameter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("credentialsParameter", CREDENTIALS_PARAMETER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpressGatewayRepositoryCredentials, T> g) {
        return obj -> g.apply((ExpressGatewayRepositoryCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpressGatewayRepositoryCredentials> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
         * </p>
         * 
         * @param credentialsParameter
         *        The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsParameter(String credentialsParameter);
    }

    static final class BuilderImpl implements Builder {
        private String credentialsParameter;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpressGatewayRepositoryCredentials model) {
            credentialsParameter(model.credentialsParameter);
        }

        public final String getCredentialsParameter() {
            return credentialsParameter;
        }

        public final void setCredentialsParameter(String credentialsParameter) {
            this.credentialsParameter = credentialsParameter;
        }

        @Override
        public final Builder credentialsParameter(String credentialsParameter) {
            this.credentialsParameter = credentialsParameter;
            return this;
        }

        @Override
        public ExpressGatewayRepositoryCredentials build() {
            return new ExpressGatewayRepositoryCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
