/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the configuration for the primary container in an Express service. This container receives traffic from the
 * Application Load Balancer and runs your application code.
 * </p>
 * <p>
 * The container configuration includes the container image, port mapping, logging settings, environment variables, and
 * secrets. The container image is the only required parameter, with sensible defaults provided for other settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpressGatewayContainer implements SdkPojo, Serializable,
        ToCopyableBuilder<ExpressGatewayContainer.Builder, ExpressGatewayContainer> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("image")
            .getter(getter(ExpressGatewayContainer::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("containerPort").getter(getter(ExpressGatewayContainer::containerPort))
            .setter(setter(Builder::containerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPort").build()).build();

    private static final SdkField<ExpressGatewayServiceAwsLogsConfiguration> AWS_LOGS_CONFIGURATION_FIELD = SdkField
            .<ExpressGatewayServiceAwsLogsConfiguration> builder(MarshallingType.SDK_POJO).memberName("awsLogsConfiguration")
            .getter(getter(ExpressGatewayContainer::awsLogsConfiguration)).setter(setter(Builder::awsLogsConfiguration))
            .constructor(ExpressGatewayServiceAwsLogsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLogsConfiguration").build())
            .build();

    private static final SdkField<ExpressGatewayRepositoryCredentials> REPOSITORY_CREDENTIALS_FIELD = SdkField
            .<ExpressGatewayRepositoryCredentials> builder(MarshallingType.SDK_POJO).memberName("repositoryCredentials")
            .getter(getter(ExpressGatewayContainer::repositoryCredentials)).setter(setter(Builder::repositoryCredentials))
            .constructor(ExpressGatewayRepositoryCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCredentials").build())
            .build();

    private static final SdkField<List<String>> COMMAND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("command")
            .getter(getter(ExpressGatewayContainer::command))
            .setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<KeyValuePair>> ENVIRONMENT_FIELD = SdkField
            .<List<KeyValuePair>> builder(MarshallingType.LIST)
            .memberName("environment")
            .getter(getter(ExpressGatewayContainer::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Secret>> SECRETS_FIELD = SdkField
            .<List<Secret>> builder(MarshallingType.LIST)
            .memberName("secrets")
            .getter(getter(ExpressGatewayContainer::secrets))
            .setter(setter(Builder::secrets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secrets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Secret> builder(MarshallingType.SDK_POJO)
                                            .constructor(Secret::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD,
            CONTAINER_PORT_FIELD, AWS_LOGS_CONFIGURATION_FIELD, REPOSITORY_CREDENTIALS_FIELD, COMMAND_FIELD, ENVIRONMENT_FIELD,
            SECRETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String image;

    private final Integer containerPort;

    private final ExpressGatewayServiceAwsLogsConfiguration awsLogsConfiguration;

    private final ExpressGatewayRepositoryCredentials repositoryCredentials;

    private final List<String> command;

    private final List<KeyValuePair> environment;

    private final List<Secret> secrets;

    private ExpressGatewayContainer(BuilderImpl builder) {
        this.image = builder.image;
        this.containerPort = builder.containerPort;
        this.awsLogsConfiguration = builder.awsLogsConfiguration;
        this.repositoryCredentials = builder.repositoryCredentials;
        this.command = builder.command;
        this.environment = builder.environment;
        this.secrets = builder.secrets;
    }

    /**
     * <p>
     * The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker
     * Hub registry are available by default. Other repositories are specified with either
     * <code>repository-url/image:tag</code> or <code>repository-url/image@digest</code>.
     * </p>
     * <p>
     * For Express services, the image typically contains a web application that listens on the specified container
     * port. The image can be stored in Amazon ECR, Docker Hub, or any other container registry accessible to your
     * execution role.
     * </p>
     * 
     * @return The image used to start a container. This string is passed directly to the Docker daemon. Images in the
     *         Docker Hub registry are available by default. Other repositories are specified with either
     *         <code>repository-url/image:tag</code> or <code>repository-url/image@digest</code>.</p>
     *         <p>
     *         For Express services, the image typically contains a web application that listens on the specified
     *         container port. The image can be stored in Amazon ECR, Docker Hub, or any other container registry
     *         accessible to your execution role.
     */
    public final String image() {
        return image;
    }

    /**
     * <p>
     * The port number on the container that receives traffic from the load balancer. Default is 80.
     * </p>
     * 
     * @return The port number on the container that receives traffic from the load balancer. Default is 80.
     */
    public final Integer containerPort() {
        return containerPort;
    }

    /**
     * <p>
     * The log configuration for the container.
     * </p>
     * 
     * @return The log configuration for the container.
     */
    public final ExpressGatewayServiceAwsLogsConfiguration awsLogsConfiguration() {
        return awsLogsConfiguration;
    }

    /**
     * <p>
     * The configuration for repository credentials for private registry authentication.
     * </p>
     * 
     * @return The configuration for repository credentials for private registry authentication.
     */
    public final ExpressGatewayRepositoryCredentials repositoryCredentials() {
        return repositoryCredentials;
    }

    /**
     * For responses, this returns true if the service returned a value for the Command property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCommand() {
        return command != null && !(command instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The command that is passed to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommand} method.
     * </p>
     * 
     * @return The command that is passed to the container.
     */
    public final List<String> command() {
        return command;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environment property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The environment variables to pass to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironment} method.
     * </p>
     * 
     * @return The environment variables to pass to the container.
     */
    public final List<KeyValuePair> environment() {
        return environment;
    }

    /**
     * For responses, this returns true if the service returned a value for the Secrets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSecrets() {
        return secrets != null && !(secrets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The secrets to pass to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecrets} method.
     * </p>
     * 
     * @return The secrets to pass to the container.
     */
    public final List<Secret> secrets() {
        return secrets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(awsLogsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommand() ? command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecrets() ? secrets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpressGatewayContainer)) {
            return false;
        }
        ExpressGatewayContainer other = (ExpressGatewayContainer) obj;
        return Objects.equals(image(), other.image()) && Objects.equals(containerPort(), other.containerPort())
                && Objects.equals(awsLogsConfiguration(), other.awsLogsConfiguration())
                && Objects.equals(repositoryCredentials(), other.repositoryCredentials()) && hasCommand() == other.hasCommand()
                && Objects.equals(command(), other.command()) && hasEnvironment() == other.hasEnvironment()
                && Objects.equals(environment(), other.environment()) && hasSecrets() == other.hasSecrets()
                && Objects.equals(secrets(), other.secrets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpressGatewayContainer").add("Image", image()).add("ContainerPort", containerPort())
                .add("AwsLogsConfiguration", awsLogsConfiguration()).add("RepositoryCredentials", repositoryCredentials())
                .add("Command", hasCommand() ? command() : null).add("Environment", hasEnvironment() ? environment() : null)
                .add("Secrets", hasSecrets() ? secrets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "containerPort":
            return Optional.ofNullable(clazz.cast(containerPort()));
        case "awsLogsConfiguration":
            return Optional.ofNullable(clazz.cast(awsLogsConfiguration()));
        case "repositoryCredentials":
            return Optional.ofNullable(clazz.cast(repositoryCredentials()));
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "secrets":
            return Optional.ofNullable(clazz.cast(secrets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("image", IMAGE_FIELD);
        map.put("containerPort", CONTAINER_PORT_FIELD);
        map.put("awsLogsConfiguration", AWS_LOGS_CONFIGURATION_FIELD);
        map.put("repositoryCredentials", REPOSITORY_CREDENTIALS_FIELD);
        map.put("command", COMMAND_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("secrets", SECRETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpressGatewayContainer, T> g) {
        return obj -> g.apply((ExpressGatewayContainer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpressGatewayContainer> {
        /**
         * <p>
         * The image used to start a container. This string is passed directly to the Docker daemon. Images in the
         * Docker Hub registry are available by default. Other repositories are specified with either
         * <code>repository-url/image:tag</code> or <code>repository-url/image@digest</code>.
         * </p>
         * <p>
         * For Express services, the image typically contains a web application that listens on the specified container
         * port. The image can be stored in Amazon ECR, Docker Hub, or any other container registry accessible to your
         * execution role.
         * </p>
         * 
         * @param image
         *        The image used to start a container. This string is passed directly to the Docker daemon. Images in
         *        the Docker Hub registry are available by default. Other repositories are specified with either
         *        <code>repository-url/image:tag</code> or <code>repository-url/image@digest</code>.</p>
         *        <p>
         *        For Express services, the image typically contains a web application that listens on the specified
         *        container port. The image can be stored in Amazon ECR, Docker Hub, or any other container registry
         *        accessible to your execution role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The port number on the container that receives traffic from the load balancer. Default is 80.
         * </p>
         * 
         * @param containerPort
         *        The port number on the container that receives traffic from the load balancer. Default is 80.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPort(Integer containerPort);

        /**
         * <p>
         * The log configuration for the container.
         * </p>
         * 
         * @param awsLogsConfiguration
         *        The log configuration for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLogsConfiguration(ExpressGatewayServiceAwsLogsConfiguration awsLogsConfiguration);

        /**
         * <p>
         * The log configuration for the container.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExpressGatewayServiceAwsLogsConfiguration.Builder} avoiding the need to create one manually via
         * {@link ExpressGatewayServiceAwsLogsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayServiceAwsLogsConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #awsLogsConfiguration(ExpressGatewayServiceAwsLogsConfiguration)}.
         * 
         * @param awsLogsConfiguration
         *        a consumer that will call methods on {@link ExpressGatewayServiceAwsLogsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLogsConfiguration(ExpressGatewayServiceAwsLogsConfiguration)
         */
        default Builder awsLogsConfiguration(Consumer<ExpressGatewayServiceAwsLogsConfiguration.Builder> awsLogsConfiguration) {
            return awsLogsConfiguration(ExpressGatewayServiceAwsLogsConfiguration.builder().applyMutation(awsLogsConfiguration)
                    .build());
        }

        /**
         * <p>
         * The configuration for repository credentials for private registry authentication.
         * </p>
         * 
         * @param repositoryCredentials
         *        The configuration for repository credentials for private registry authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryCredentials(ExpressGatewayRepositoryCredentials repositoryCredentials);

        /**
         * <p>
         * The configuration for repository credentials for private registry authentication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExpressGatewayRepositoryCredentials.Builder} avoiding the need to create one manually via
         * {@link ExpressGatewayRepositoryCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayRepositoryCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #repositoryCredentials(ExpressGatewayRepositoryCredentials)}.
         * 
         * @param repositoryCredentials
         *        a consumer that will call methods on {@link ExpressGatewayRepositoryCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryCredentials(ExpressGatewayRepositoryCredentials)
         */
        default Builder repositoryCredentials(Consumer<ExpressGatewayRepositoryCredentials.Builder> repositoryCredentials) {
            return repositoryCredentials(ExpressGatewayRepositoryCredentials.builder().applyMutation(repositoryCredentials)
                    .build());
        }

        /**
         * <p>
         * The command that is passed to the container.
         * </p>
         * 
         * @param command
         *        The command that is passed to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(Collection<String> command);

        /**
         * <p>
         * The command that is passed to the container.
         * </p>
         * 
         * @param command
         *        The command that is passed to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String... command);

        /**
         * <p>
         * The environment variables to pass to the container.
         * </p>
         * 
         * @param environment
         *        The environment variables to pass to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Collection<KeyValuePair> environment);

        /**
         * <p>
         * The environment variables to pass to the container.
         * </p>
         * 
         * @param environment
         *        The environment variables to pass to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(KeyValuePair... environment);

        /**
         * <p>
         * The environment variables to pass to the container.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.KeyValuePair.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.KeyValuePair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.KeyValuePair.Builder#build()} is called immediately and its
         * result is passed to {@link #environment(List<KeyValuePair>)}.
         * 
         * @param environment
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.KeyValuePair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(java.util.Collection<KeyValuePair>)
         */
        Builder environment(Consumer<KeyValuePair.Builder>... environment);

        /**
         * <p>
         * The secrets to pass to the container.
         * </p>
         * 
         * @param secrets
         *        The secrets to pass to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secrets(Collection<Secret> secrets);

        /**
         * <p>
         * The secrets to pass to the container.
         * </p>
         * 
         * @param secrets
         *        The secrets to pass to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secrets(Secret... secrets);

        /**
         * <p>
         * The secrets to pass to the container.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Secret.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.Secret#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ecs.model.Secret.Builder#build()}
         * is called immediately and its result is passed to {@link #secrets(List<Secret>)}.
         * 
         * @param secrets
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecs.model.Secret.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secrets(java.util.Collection<Secret>)
         */
        Builder secrets(Consumer<Secret.Builder>... secrets);
    }

    static final class BuilderImpl implements Builder {
        private String image;

        private Integer containerPort;

        private ExpressGatewayServiceAwsLogsConfiguration awsLogsConfiguration;

        private ExpressGatewayRepositoryCredentials repositoryCredentials;

        private List<String> command = DefaultSdkAutoConstructList.getInstance();

        private List<KeyValuePair> environment = DefaultSdkAutoConstructList.getInstance();

        private List<Secret> secrets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExpressGatewayContainer model) {
            image(model.image);
            containerPort(model.containerPort);
            awsLogsConfiguration(model.awsLogsConfiguration);
            repositoryCredentials(model.repositoryCredentials);
            command(model.command);
            environment(model.environment);
            secrets(model.secrets);
        }

        public final String getImage() {
            return image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final Integer getContainerPort() {
            return containerPort;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final ExpressGatewayServiceAwsLogsConfiguration.Builder getAwsLogsConfiguration() {
            return awsLogsConfiguration != null ? awsLogsConfiguration.toBuilder() : null;
        }

        public final void setAwsLogsConfiguration(ExpressGatewayServiceAwsLogsConfiguration.BuilderImpl awsLogsConfiguration) {
            this.awsLogsConfiguration = awsLogsConfiguration != null ? awsLogsConfiguration.build() : null;
        }

        @Override
        public final Builder awsLogsConfiguration(ExpressGatewayServiceAwsLogsConfiguration awsLogsConfiguration) {
            this.awsLogsConfiguration = awsLogsConfiguration;
            return this;
        }

        public final ExpressGatewayRepositoryCredentials.Builder getRepositoryCredentials() {
            return repositoryCredentials != null ? repositoryCredentials.toBuilder() : null;
        }

        public final void setRepositoryCredentials(ExpressGatewayRepositoryCredentials.BuilderImpl repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials != null ? repositoryCredentials.build() : null;
        }

        @Override
        public final Builder repositoryCredentials(ExpressGatewayRepositoryCredentials repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials;
            return this;
        }

        public final Collection<String> getCommand() {
            if (command instanceof SdkAutoConstructList) {
                return null;
            }
            return command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String... command) {
            command(Arrays.asList(command));
            return this;
        }

        public final List<KeyValuePair.Builder> getEnvironment() {
            List<KeyValuePair.Builder> result = EnvironmentVariablesCopier.copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair... environment) {
            environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<KeyValuePair.Builder>... environment) {
            environment(Stream.of(environment).map(c -> KeyValuePair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Secret.Builder> getSecrets() {
            List<Secret.Builder> result = SecretListCopier.copyToBuilder(this.secrets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecrets(Collection<Secret.BuilderImpl> secrets) {
            this.secrets = SecretListCopier.copyFromBuilder(secrets);
        }

        @Override
        public final Builder secrets(Collection<Secret> secrets) {
            this.secrets = SecretListCopier.copy(secrets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Secret... secrets) {
            secrets(Arrays.asList(secrets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Consumer<Secret.Builder>... secrets) {
            secrets(Stream.of(secrets).map(c -> Secret.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExpressGatewayContainer build() {
            return new ExpressGatewayContainer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
