/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This parameter is specified when you're using Docker volumes. Docker volumes are only supported when you're using the
 * EC2 launch type. Windows containers only support the use of the <code>local</code> driver. To use bind mounts,
 * specify a <code>host</code> instead.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DockerVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DockerVolumeConfiguration.Builder, DockerVolumeConfiguration> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scope")
            .getter(getter(DockerVolumeConfiguration::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<Boolean> AUTOPROVISION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoprovision").getter(getter(DockerVolumeConfiguration::autoprovision))
            .setter(setter(Builder::autoprovision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoprovision").build()).build();

    private static final SdkField<String> DRIVER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("driver")
            .getter(getter(DockerVolumeConfiguration::driver)).setter(setter(Builder::driver))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driver").build()).build();

    private static final SdkField<Map<String, String>> DRIVER_OPTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("driverOpts")
            .getter(getter(DockerVolumeConfiguration::driverOpts))
            .setter(setter(Builder::driverOpts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driverOpts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("labels")
            .getter(getter(DockerVolumeConfiguration::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD,
            AUTOPROVISION_FIELD, DRIVER_FIELD, DRIVER_OPTS_FIELD, LABELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scope;

    private final Boolean autoprovision;

    private final String driver;

    private final Map<String, String> driverOpts;

    private final Map<String, String> labels;

    private DockerVolumeConfiguration(BuilderImpl builder) {
        this.scope = builder.scope;
        this.autoprovision = builder.autoprovision;
        this.driver = builder.driver;
        this.driverOpts = builder.driverOpts;
        this.labels = builder.labels;
    }

    /**
     * <p>
     * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
     * <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops. Docker
     * volumes that are scoped as <code>shared</code> persist after the task stops.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
     *         <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops.
     *         Docker volumes that are scoped as <code>shared</code> persist after the task stops.
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
     * <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops. Docker
     * volumes that are scoped as <code>shared</code> persist after the task stops.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
     *         <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops.
     *         Docker volumes that are scoped as <code>shared</code> persist after the task stops.
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * If this value is <code>true</code>, the Docker volume is created if it doesn't already exist.
     * </p>
     * <note>
     * <p>
     * This field is only used if the <code>scope</code> is <code>shared</code>.
     * </p>
     * </note>
     * 
     * @return If this value is <code>true</code>, the Docker volume is created if it doesn't already exist.</p> <note>
     *         <p>
     *         This field is only used if the <code>scope</code> is <code>shared</code>.
     *         </p>
     */
    public final Boolean autoprovision() {
        return autoprovision;
    }

    /**
     * <p>
     * The Docker volume driver to use. The driver value must match the driver name provided by Docker because it is
     * used for task placement. If the driver was installed using the Docker plugin CLI, use
     * <code>docker plugin ls</code> to retrieve the driver name from your container instance. If the driver was
     * installed using another method, use Docker plugin discovery to retrieve the driver name. This parameter maps to
     * <code>Driver</code> in the docker container create command and the <code>xxdriver</code> option to docker volume
     * create.
     * </p>
     * 
     * @return The Docker volume driver to use. The driver value must match the driver name provided by Docker because
     *         it is used for task placement. If the driver was installed using the Docker plugin CLI, use
     *         <code>docker plugin ls</code> to retrieve the driver name from your container instance. If the driver was
     *         installed using another method, use Docker plugin discovery to retrieve the driver name. This parameter
     *         maps to <code>Driver</code> in the docker container create command and the <code>xxdriver</code> option
     *         to docker volume create.
     */
    public final String driver() {
        return driver;
    }

    /**
     * For responses, this returns true if the service returned a value for the DriverOpts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDriverOpts() {
        return driverOpts != null && !(driverOpts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of Docker driver-specific options passed through. This parameter maps to <code>DriverOpts</code> in the
     * docker create-volume command and the <code>xxopt</code> option to docker volume create.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDriverOpts} method.
     * </p>
     * 
     * @return A map of Docker driver-specific options passed through. This parameter maps to <code>DriverOpts</code> in
     *         the docker create-volume command and the <code>xxopt</code> option to docker volume create.
     */
    public final Map<String, String> driverOpts() {
        return driverOpts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Custom metadata to add to your Docker volume. This parameter maps to <code>Labels</code> in the docker container
     * create command and the <code>xxlabel</code> option to docker volume create.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return Custom metadata to add to your Docker volume. This parameter maps to <code>Labels</code> in the docker
     *         container create command and the <code>xxlabel</code> option to docker volume create.
     */
    public final Map<String, String> labels() {
        return labels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoprovision());
        hashCode = 31 * hashCode + Objects.hashCode(driver());
        hashCode = 31 * hashCode + Objects.hashCode(hasDriverOpts() ? driverOpts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DockerVolumeConfiguration)) {
            return false;
        }
        DockerVolumeConfiguration other = (DockerVolumeConfiguration) obj;
        return Objects.equals(scopeAsString(), other.scopeAsString()) && Objects.equals(autoprovision(), other.autoprovision())
                && Objects.equals(driver(), other.driver()) && hasDriverOpts() == other.hasDriverOpts()
                && Objects.equals(driverOpts(), other.driverOpts()) && hasLabels() == other.hasLabels()
                && Objects.equals(labels(), other.labels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DockerVolumeConfiguration").add("Scope", scopeAsString()).add("Autoprovision", autoprovision())
                .add("Driver", driver()).add("DriverOpts", hasDriverOpts() ? driverOpts() : null)
                .add("Labels", hasLabels() ? labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "autoprovision":
            return Optional.ofNullable(clazz.cast(autoprovision()));
        case "driver":
            return Optional.ofNullable(clazz.cast(driver()));
        case "driverOpts":
            return Optional.ofNullable(clazz.cast(driverOpts()));
        case "labels":
            return Optional.ofNullable(clazz.cast(labels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scope", SCOPE_FIELD);
        map.put("autoprovision", AUTOPROVISION_FIELD);
        map.put("driver", DRIVER_FIELD);
        map.put("driverOpts", DRIVER_OPTS_FIELD);
        map.put("labels", LABELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DockerVolumeConfiguration, T> g) {
        return obj -> g.apply((DockerVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DockerVolumeConfiguration> {
        /**
         * <p>
         * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
         * <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops.
         * Docker volumes that are scoped as <code>shared</code> persist after the task stops.
         * </p>
         * 
         * @param scope
         *        The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
         *        <code>task</code> are automatically provisioned when the task starts and destroyed when the task
         *        stops. Docker volumes that are scoped as <code>shared</code> persist after the task stops.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
         * <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops.
         * Docker volumes that are scoped as <code>shared</code> persist after the task stops.
         * </p>
         * 
         * @param scope
         *        The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
         *        <code>task</code> are automatically provisioned when the task starts and destroyed when the task
         *        stops. Docker volumes that are scoped as <code>shared</code> persist after the task stops.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * If this value is <code>true</code>, the Docker volume is created if it doesn't already exist.
         * </p>
         * <note>
         * <p>
         * This field is only used if the <code>scope</code> is <code>shared</code>.
         * </p>
         * </note>
         * 
         * @param autoprovision
         *        If this value is <code>true</code>, the Docker volume is created if it doesn't already exist.</p>
         *        <note>
         *        <p>
         *        This field is only used if the <code>scope</code> is <code>shared</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoprovision(Boolean autoprovision);

        /**
         * <p>
         * The Docker volume driver to use. The driver value must match the driver name provided by Docker because it is
         * used for task placement. If the driver was installed using the Docker plugin CLI, use
         * <code>docker plugin ls</code> to retrieve the driver name from your container instance. If the driver was
         * installed using another method, use Docker plugin discovery to retrieve the driver name. This parameter maps
         * to <code>Driver</code> in the docker container create command and the <code>xxdriver</code> option to docker
         * volume create.
         * </p>
         * 
         * @param driver
         *        The Docker volume driver to use. The driver value must match the driver name provided by Docker
         *        because it is used for task placement. If the driver was installed using the Docker plugin CLI, use
         *        <code>docker plugin ls</code> to retrieve the driver name from your container instance. If the driver
         *        was installed using another method, use Docker plugin discovery to retrieve the driver name. This
         *        parameter maps to <code>Driver</code> in the docker container create command and the
         *        <code>xxdriver</code> option to docker volume create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driver(String driver);

        /**
         * <p>
         * A map of Docker driver-specific options passed through. This parameter maps to <code>DriverOpts</code> in the
         * docker create-volume command and the <code>xxopt</code> option to docker volume create.
         * </p>
         * 
         * @param driverOpts
         *        A map of Docker driver-specific options passed through. This parameter maps to <code>DriverOpts</code>
         *        in the docker create-volume command and the <code>xxopt</code> option to docker volume create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driverOpts(Map<String, String> driverOpts);

        /**
         * <p>
         * Custom metadata to add to your Docker volume. This parameter maps to <code>Labels</code> in the docker
         * container create command and the <code>xxlabel</code> option to docker volume create.
         * </p>
         * 
         * @param labels
         *        Custom metadata to add to your Docker volume. This parameter maps to <code>Labels</code> in the docker
         *        container create command and the <code>xxlabel</code> option to docker volume create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Map<String, String> labels);
    }

    static final class BuilderImpl implements Builder {
        private String scope;

        private Boolean autoprovision;

        private String driver;

        private Map<String, String> driverOpts = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DockerVolumeConfiguration model) {
            scope(model.scope);
            autoprovision(model.autoprovision);
            driver(model.driver);
            driverOpts(model.driverOpts);
            labels(model.labels);
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final Boolean getAutoprovision() {
            return autoprovision;
        }

        public final void setAutoprovision(Boolean autoprovision) {
            this.autoprovision = autoprovision;
        }

        @Override
        public final Builder autoprovision(Boolean autoprovision) {
            this.autoprovision = autoprovision;
            return this;
        }

        public final String getDriver() {
            return driver;
        }

        public final void setDriver(String driver) {
            this.driver = driver;
        }

        @Override
        public final Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        public final Map<String, String> getDriverOpts() {
            if (driverOpts instanceof SdkAutoConstructMap) {
                return null;
            }
            return driverOpts;
        }

        public final void setDriverOpts(Map<String, String> driverOpts) {
            this.driverOpts = StringMapCopier.copy(driverOpts);
        }

        @Override
        public final Builder driverOpts(Map<String, String> driverOpts) {
            this.driverOpts = StringMapCopier.copy(driverOpts);
            return this;
        }

        public final Map<String, String> getLabels() {
            if (labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return labels;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = StringMapCopier.copy(labels);
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = StringMapCopier.copy(labels);
            return this;
        }

        @Override
        public DockerVolumeConfiguration build() {
            return new DockerVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
