/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClusterSettingName {
    CONTAINER_INSIGHTS("containerInsights"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClusterSettingName> VALUE_MAP;
    private final String value;

    private ClusterSettingName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClusterSettingName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClusterSettingName> knownValues() {
        EnumSet<ClusterSettingName> knownValues = EnumSet.allOf(ClusterSettingName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClusterSettingName.class, ClusterSettingName::toString);
    }
}

