/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The auto scaling configuration created by Amazon ECS for an Express service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedAutoScaling implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedAutoScaling.Builder, ManagedAutoScaling> {
    private static final SdkField<ManagedScalableTarget> SCALABLE_TARGET_FIELD = SdkField
            .<ManagedScalableTarget> builder(MarshallingType.SDK_POJO).memberName("scalableTarget")
            .getter(getter(ManagedAutoScaling::scalableTarget)).setter(setter(Builder::scalableTarget))
            .constructor(ManagedScalableTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalableTarget").build()).build();

    private static final SdkField<List<ManagedApplicationAutoScalingPolicy>> APPLICATION_AUTO_SCALING_POLICIES_FIELD = SdkField
            .<List<ManagedApplicationAutoScalingPolicy>> builder(MarshallingType.LIST)
            .memberName("applicationAutoScalingPolicies")
            .getter(getter(ManagedAutoScaling::applicationAutoScalingPolicies))
            .setter(setter(Builder::applicationAutoScalingPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationAutoScalingPolicies")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedApplicationAutoScalingPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedApplicationAutoScalingPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALABLE_TARGET_FIELD,
            APPLICATION_AUTO_SCALING_POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ManagedScalableTarget scalableTarget;

    private final List<ManagedApplicationAutoScalingPolicy> applicationAutoScalingPolicies;

    private ManagedAutoScaling(BuilderImpl builder) {
        this.scalableTarget = builder.scalableTarget;
        this.applicationAutoScalingPolicies = builder.applicationAutoScalingPolicies;
    }

    /**
     * <p>
     * Represents a scalable target.
     * </p>
     * 
     * @return Represents a scalable target.
     */
    public final ManagedScalableTarget scalableTarget() {
        return scalableTarget;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationAutoScalingPolicies property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasApplicationAutoScalingPolicies() {
        return applicationAutoScalingPolicies != null && !(applicationAutoScalingPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The policy used for auto scaling.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationAutoScalingPolicies} method.
     * </p>
     * 
     * @return The policy used for auto scaling.
     */
    public final List<ManagedApplicationAutoScalingPolicy> applicationAutoScalingPolicies() {
        return applicationAutoScalingPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalableTarget());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasApplicationAutoScalingPolicies() ? applicationAutoScalingPolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedAutoScaling)) {
            return false;
        }
        ManagedAutoScaling other = (ManagedAutoScaling) obj;
        return Objects.equals(scalableTarget(), other.scalableTarget())
                && hasApplicationAutoScalingPolicies() == other.hasApplicationAutoScalingPolicies()
                && Objects.equals(applicationAutoScalingPolicies(), other.applicationAutoScalingPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ManagedAutoScaling")
                .add("ScalableTarget", scalableTarget())
                .add("ApplicationAutoScalingPolicies",
                        hasApplicationAutoScalingPolicies() ? applicationAutoScalingPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scalableTarget":
            return Optional.ofNullable(clazz.cast(scalableTarget()));
        case "applicationAutoScalingPolicies":
            return Optional.ofNullable(clazz.cast(applicationAutoScalingPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scalableTarget", SCALABLE_TARGET_FIELD);
        map.put("applicationAutoScalingPolicies", APPLICATION_AUTO_SCALING_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedAutoScaling, T> g) {
        return obj -> g.apply((ManagedAutoScaling) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedAutoScaling> {
        /**
         * <p>
         * Represents a scalable target.
         * </p>
         * 
         * @param scalableTarget
         *        Represents a scalable target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalableTarget(ManagedScalableTarget scalableTarget);

        /**
         * <p>
         * Represents a scalable target.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedScalableTarget.Builder} avoiding
         * the need to create one manually via {@link ManagedScalableTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedScalableTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #scalableTarget(ManagedScalableTarget)}.
         * 
         * @param scalableTarget
         *        a consumer that will call methods on {@link ManagedScalableTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalableTarget(ManagedScalableTarget)
         */
        default Builder scalableTarget(Consumer<ManagedScalableTarget.Builder> scalableTarget) {
            return scalableTarget(ManagedScalableTarget.builder().applyMutation(scalableTarget).build());
        }

        /**
         * <p>
         * The policy used for auto scaling.
         * </p>
         * 
         * @param applicationAutoScalingPolicies
         *        The policy used for auto scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationAutoScalingPolicies(Collection<ManagedApplicationAutoScalingPolicy> applicationAutoScalingPolicies);

        /**
         * <p>
         * The policy used for auto scaling.
         * </p>
         * 
         * @param applicationAutoScalingPolicies
         *        The policy used for auto scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationAutoScalingPolicies(ManagedApplicationAutoScalingPolicy... applicationAutoScalingPolicies);

        /**
         * <p>
         * The policy used for auto scaling.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ManagedApplicationAutoScalingPolicy.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.ManagedApplicationAutoScalingPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ManagedApplicationAutoScalingPolicy.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #applicationAutoScalingPolicies(List<ManagedApplicationAutoScalingPolicy>)}.
         * 
         * @param applicationAutoScalingPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ManagedApplicationAutoScalingPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationAutoScalingPolicies(java.util.Collection<ManagedApplicationAutoScalingPolicy>)
         */
        Builder applicationAutoScalingPolicies(
                Consumer<ManagedApplicationAutoScalingPolicy.Builder>... applicationAutoScalingPolicies);
    }

    static final class BuilderImpl implements Builder {
        private ManagedScalableTarget scalableTarget;

        private List<ManagedApplicationAutoScalingPolicy> applicationAutoScalingPolicies = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedAutoScaling model) {
            scalableTarget(model.scalableTarget);
            applicationAutoScalingPolicies(model.applicationAutoScalingPolicies);
        }

        public final ManagedScalableTarget.Builder getScalableTarget() {
            return scalableTarget != null ? scalableTarget.toBuilder() : null;
        }

        public final void setScalableTarget(ManagedScalableTarget.BuilderImpl scalableTarget) {
            this.scalableTarget = scalableTarget != null ? scalableTarget.build() : null;
        }

        @Override
        public final Builder scalableTarget(ManagedScalableTarget scalableTarget) {
            this.scalableTarget = scalableTarget;
            return this;
        }

        public final List<ManagedApplicationAutoScalingPolicy.Builder> getApplicationAutoScalingPolicies() {
            List<ManagedApplicationAutoScalingPolicy.Builder> result = ManagedApplicationAutoScalingPoliciesCopier
                    .copyToBuilder(this.applicationAutoScalingPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationAutoScalingPolicies(
                Collection<ManagedApplicationAutoScalingPolicy.BuilderImpl> applicationAutoScalingPolicies) {
            this.applicationAutoScalingPolicies = ManagedApplicationAutoScalingPoliciesCopier
                    .copyFromBuilder(applicationAutoScalingPolicies);
        }

        @Override
        public final Builder applicationAutoScalingPolicies(
                Collection<ManagedApplicationAutoScalingPolicy> applicationAutoScalingPolicies) {
            this.applicationAutoScalingPolicies = ManagedApplicationAutoScalingPoliciesCopier
                    .copy(applicationAutoScalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationAutoScalingPolicies(ManagedApplicationAutoScalingPolicy... applicationAutoScalingPolicies) {
            applicationAutoScalingPolicies(Arrays.asList(applicationAutoScalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationAutoScalingPolicies(
                Consumer<ManagedApplicationAutoScalingPolicy.Builder>... applicationAutoScalingPolicies) {
            applicationAutoScalingPolicies(Stream.of(applicationAutoScalingPolicies)
                    .map(c -> ManagedApplicationAutoScalingPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ManagedAutoScaling build() {
            return new ManagedAutoScaling(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
