/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on an Elastic Inference accelerator task override. This parameter is used to override the Elastic Inference
 * accelerator specified in the task definition. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html">Working with Amazon Elastic
 * Inference on Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceAcceleratorOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceAcceleratorOverride.Builder, InferenceAcceleratorOverride> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceName").getter(getter(InferenceAcceleratorOverride::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()).build();

    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceType").getter(getter(InferenceAcceleratorOverride::deviceType))
            .setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD,
            DEVICE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final String deviceType;

    private InferenceAcceleratorOverride(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.deviceType = builder.deviceType;
    }

    /**
     * <p>
     * The Elastic Inference accelerator device name to override for the task. This parameter must match a
     * <code>deviceName</code> specified in the task definition.
     * </p>
     * 
     * @return The Elastic Inference accelerator device name to override for the task. This parameter must match a
     *         <code>deviceName</code> specified in the task definition.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The Elastic Inference accelerator type to use.
     * </p>
     * 
     * @return The Elastic Inference accelerator type to use.
     */
    public final String deviceType() {
        return deviceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceAcceleratorOverride)) {
            return false;
        }
        InferenceAcceleratorOverride other = (InferenceAcceleratorOverride) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(deviceType(), other.deviceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceAcceleratorOverride").add("DeviceName", deviceName()).add("DeviceType", deviceType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "deviceType":
            return Optional.ofNullable(clazz.cast(deviceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deviceName", DEVICE_NAME_FIELD);
        map.put("deviceType", DEVICE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceAcceleratorOverride, T> g) {
        return obj -> g.apply((InferenceAcceleratorOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceAcceleratorOverride> {
        /**
         * <p>
         * The Elastic Inference accelerator device name to override for the task. This parameter must match a
         * <code>deviceName</code> specified in the task definition.
         * </p>
         * 
         * @param deviceName
         *        The Elastic Inference accelerator device name to override for the task. This parameter must match a
         *        <code>deviceName</code> specified in the task definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The Elastic Inference accelerator type to use.
         * </p>
         * 
         * @param deviceType
         *        The Elastic Inference accelerator type to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceType(String deviceType);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private String deviceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceAcceleratorOverride model) {
            deviceName(model.deviceName);
            deviceType(model.deviceType);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Override
        public InferenceAcceleratorOverride build() {
            return new InferenceAcceleratorOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
