/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a specific configuration revision of an Express service, containing all the settings and parameters for
 * that revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpressGatewayServiceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExpressGatewayServiceConfiguration.Builder, ExpressGatewayServiceConfiguration> {
    private static final SdkField<String> SERVICE_REVISION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRevisionArn").getter(getter(ExpressGatewayServiceConfiguration::serviceRevisionArn))
            .setter(setter(Builder::serviceRevisionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRevisionArn").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(ExpressGatewayServiceConfiguration::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskRoleArn").getter(getter(ExpressGatewayServiceConfiguration::taskRoleArn))
            .setter(setter(Builder::taskRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()).build();

    private static final SdkField<String> CPU_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cpu")
            .getter(getter(ExpressGatewayServiceConfiguration::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final SdkField<String> MEMORY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("memory")
            .getter(getter(ExpressGatewayServiceConfiguration::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<ExpressGatewayServiceNetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<ExpressGatewayServiceNetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(ExpressGatewayServiceConfiguration::networkConfiguration))
            .setter(setter(Builder::networkConfiguration)).constructor(ExpressGatewayServiceNetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("healthCheckPath").getter(getter(ExpressGatewayServiceConfiguration::healthCheckPath))
            .setter(setter(Builder::healthCheckPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckPath").build()).build();

    private static final SdkField<ExpressGatewayContainer> PRIMARY_CONTAINER_FIELD = SdkField
            .<ExpressGatewayContainer> builder(MarshallingType.SDK_POJO).memberName("primaryContainer")
            .getter(getter(ExpressGatewayServiceConfiguration::primaryContainer)).setter(setter(Builder::primaryContainer))
            .constructor(ExpressGatewayContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryContainer").build()).build();

    private static final SdkField<ExpressGatewayScalingTarget> SCALING_TARGET_FIELD = SdkField
            .<ExpressGatewayScalingTarget> builder(MarshallingType.SDK_POJO).memberName("scalingTarget")
            .getter(getter(ExpressGatewayServiceConfiguration::scalingTarget)).setter(setter(Builder::scalingTarget))
            .constructor(ExpressGatewayScalingTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingTarget").build()).build();

    private static final SdkField<List<IngressPathSummary>> INGRESS_PATHS_FIELD = SdkField
            .<List<IngressPathSummary>> builder(MarshallingType.LIST)
            .memberName("ingressPaths")
            .getter(getter(ExpressGatewayServiceConfiguration::ingressPaths))
            .setter(setter(Builder::ingressPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IngressPathSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IngressPathSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ExpressGatewayServiceConfiguration::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_REVISION_ARN_FIELD,
            EXECUTION_ROLE_ARN_FIELD, TASK_ROLE_ARN_FIELD, CPU_FIELD, MEMORY_FIELD, NETWORK_CONFIGURATION_FIELD,
            HEALTH_CHECK_PATH_FIELD, PRIMARY_CONTAINER_FIELD, SCALING_TARGET_FIELD, INGRESS_PATHS_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceRevisionArn;

    private final String executionRoleArn;

    private final String taskRoleArn;

    private final String cpu;

    private final String memory;

    private final ExpressGatewayServiceNetworkConfiguration networkConfiguration;

    private final String healthCheckPath;

    private final ExpressGatewayContainer primaryContainer;

    private final ExpressGatewayScalingTarget scalingTarget;

    private final List<IngressPathSummary> ingressPaths;

    private final Instant createdAt;

    private ExpressGatewayServiceConfiguration(BuilderImpl builder) {
        this.serviceRevisionArn = builder.serviceRevisionArn;
        this.executionRoleArn = builder.executionRoleArn;
        this.taskRoleArn = builder.taskRoleArn;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.networkConfiguration = builder.networkConfiguration;
        this.healthCheckPath = builder.healthCheckPath;
        this.primaryContainer = builder.primaryContainer;
        this.scalingTarget = builder.scalingTarget;
        this.ingressPaths = builder.ingressPaths;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The ARN of the service revision.
     * </p>
     * 
     * @return The ARN of the service revision.
     */
    public final String serviceRevisionArn() {
        return serviceRevisionArn;
    }

    /**
     * <p>
     * The ARN of the task execution role for the service revision.
     * </p>
     * 
     * @return The ARN of the task execution role for the service revision.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The ARN of the task role for the service revision.
     * </p>
     * 
     * @return The ARN of the task role for the service revision.
     */
    public final String taskRoleArn() {
        return taskRoleArn;
    }

    /**
     * <p>
     * The CPU allocation for tasks in this service revision.
     * </p>
     * 
     * @return The CPU allocation for tasks in this service revision.
     */
    public final String cpu() {
        return cpu;
    }

    /**
     * <p>
     * The memory allocation for tasks in this service revision.
     * </p>
     * 
     * @return The memory allocation for tasks in this service revision.
     */
    public final String memory() {
        return memory;
    }

    /**
     * <p>
     * The network configuration for tasks in this service revision.
     * </p>
     * 
     * @return The network configuration for tasks in this service revision.
     */
    public final ExpressGatewayServiceNetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The health check path for this service revision.
     * </p>
     * 
     * @return The health check path for this service revision.
     */
    public final String healthCheckPath() {
        return healthCheckPath;
    }

    /**
     * <p>
     * The primary container configuration for this service revision.
     * </p>
     * 
     * @return The primary container configuration for this service revision.
     */
    public final ExpressGatewayContainer primaryContainer() {
        return primaryContainer;
    }

    /**
     * <p>
     * The auto-scaling configuration for this service revision.
     * </p>
     * 
     * @return The auto-scaling configuration for this service revision.
     */
    public final ExpressGatewayScalingTarget scalingTarget() {
        return scalingTarget;
    }

    /**
     * For responses, this returns true if the service returned a value for the IngressPaths property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIngressPaths() {
        return ingressPaths != null && !(ingressPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The entry point into this service revision.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIngressPaths} method.
     * </p>
     * 
     * @return The entry point into this service revision.
     */
    public final List<IngressPathSummary> ingressPaths() {
        return ingressPaths;
    }

    /**
     * <p>
     * The Unix timestamp for when this service revision was created.
     * </p>
     * 
     * @return The Unix timestamp for when this service revision was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceRevisionArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(primaryContainer());
        hashCode = 31 * hashCode + Objects.hashCode(scalingTarget());
        hashCode = 31 * hashCode + Objects.hashCode(hasIngressPaths() ? ingressPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpressGatewayServiceConfiguration)) {
            return false;
        }
        ExpressGatewayServiceConfiguration other = (ExpressGatewayServiceConfiguration) obj;
        return Objects.equals(serviceRevisionArn(), other.serviceRevisionArn())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(taskRoleArn(), other.taskRoleArn()) && Objects.equals(cpu(), other.cpu())
                && Objects.equals(memory(), other.memory())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(healthCheckPath(), other.healthCheckPath())
                && Objects.equals(primaryContainer(), other.primaryContainer())
                && Objects.equals(scalingTarget(), other.scalingTarget()) && hasIngressPaths() == other.hasIngressPaths()
                && Objects.equals(ingressPaths(), other.ingressPaths()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpressGatewayServiceConfiguration").add("ServiceRevisionArn", serviceRevisionArn())
                .add("ExecutionRoleArn", executionRoleArn()).add("TaskRoleArn", taskRoleArn()).add("Cpu", cpu())
                .add("Memory", memory()).add("NetworkConfiguration", networkConfiguration())
                .add("HealthCheckPath", healthCheckPath()).add("PrimaryContainer", primaryContainer())
                .add("ScalingTarget", scalingTarget()).add("IngressPaths", hasIngressPaths() ? ingressPaths() : null)
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceRevisionArn":
            return Optional.ofNullable(clazz.cast(serviceRevisionArn()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "taskRoleArn":
            return Optional.ofNullable(clazz.cast(taskRoleArn()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "healthCheckPath":
            return Optional.ofNullable(clazz.cast(healthCheckPath()));
        case "primaryContainer":
            return Optional.ofNullable(clazz.cast(primaryContainer()));
        case "scalingTarget":
            return Optional.ofNullable(clazz.cast(scalingTarget()));
        case "ingressPaths":
            return Optional.ofNullable(clazz.cast(ingressPaths()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceRevisionArn", SERVICE_REVISION_ARN_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("taskRoleArn", TASK_ROLE_ARN_FIELD);
        map.put("cpu", CPU_FIELD);
        map.put("memory", MEMORY_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("healthCheckPath", HEALTH_CHECK_PATH_FIELD);
        map.put("primaryContainer", PRIMARY_CONTAINER_FIELD);
        map.put("scalingTarget", SCALING_TARGET_FIELD);
        map.put("ingressPaths", INGRESS_PATHS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpressGatewayServiceConfiguration, T> g) {
        return obj -> g.apply((ExpressGatewayServiceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpressGatewayServiceConfiguration> {
        /**
         * <p>
         * The ARN of the service revision.
         * </p>
         * 
         * @param serviceRevisionArn
         *        The ARN of the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRevisionArn(String serviceRevisionArn);

        /**
         * <p>
         * The ARN of the task execution role for the service revision.
         * </p>
         * 
         * @param executionRoleArn
         *        The ARN of the task execution role for the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The ARN of the task role for the service revision.
         * </p>
         * 
         * @param taskRoleArn
         *        The ARN of the task role for the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRoleArn(String taskRoleArn);

        /**
         * <p>
         * The CPU allocation for tasks in this service revision.
         * </p>
         * 
         * @param cpu
         *        The CPU allocation for tasks in this service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(String cpu);

        /**
         * <p>
         * The memory allocation for tasks in this service revision.
         * </p>
         * 
         * @param memory
         *        The memory allocation for tasks in this service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(String memory);

        /**
         * <p>
         * The network configuration for tasks in this service revision.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for tasks in this service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(ExpressGatewayServiceNetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for tasks in this service revision.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExpressGatewayServiceNetworkConfiguration.Builder} avoiding the need to create one manually via
         * {@link ExpressGatewayServiceNetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayServiceNetworkConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #networkConfiguration(ExpressGatewayServiceNetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link ExpressGatewayServiceNetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(ExpressGatewayServiceNetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<ExpressGatewayServiceNetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(ExpressGatewayServiceNetworkConfiguration.builder().applyMutation(networkConfiguration)
                    .build());
        }

        /**
         * <p>
         * The health check path for this service revision.
         * </p>
         * 
         * @param healthCheckPath
         *        The health check path for this service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPath(String healthCheckPath);

        /**
         * <p>
         * The primary container configuration for this service revision.
         * </p>
         * 
         * @param primaryContainer
         *        The primary container configuration for this service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryContainer(ExpressGatewayContainer primaryContainer);

        /**
         * <p>
         * The primary container configuration for this service revision.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressGatewayContainer.Builder} avoiding
         * the need to create one manually via {@link ExpressGatewayContainer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayContainer.Builder#build()} is called immediately
         * and its result is passed to {@link #primaryContainer(ExpressGatewayContainer)}.
         * 
         * @param primaryContainer
         *        a consumer that will call methods on {@link ExpressGatewayContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryContainer(ExpressGatewayContainer)
         */
        default Builder primaryContainer(Consumer<ExpressGatewayContainer.Builder> primaryContainer) {
            return primaryContainer(ExpressGatewayContainer.builder().applyMutation(primaryContainer).build());
        }

        /**
         * <p>
         * The auto-scaling configuration for this service revision.
         * </p>
         * 
         * @param scalingTarget
         *        The auto-scaling configuration for this service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingTarget(ExpressGatewayScalingTarget scalingTarget);

        /**
         * <p>
         * The auto-scaling configuration for this service revision.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressGatewayScalingTarget.Builder}
         * avoiding the need to create one manually via {@link ExpressGatewayScalingTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayScalingTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #scalingTarget(ExpressGatewayScalingTarget)}.
         * 
         * @param scalingTarget
         *        a consumer that will call methods on {@link ExpressGatewayScalingTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingTarget(ExpressGatewayScalingTarget)
         */
        default Builder scalingTarget(Consumer<ExpressGatewayScalingTarget.Builder> scalingTarget) {
            return scalingTarget(ExpressGatewayScalingTarget.builder().applyMutation(scalingTarget).build());
        }

        /**
         * <p>
         * The entry point into this service revision.
         * </p>
         * 
         * @param ingressPaths
         *        The entry point into this service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPaths(Collection<IngressPathSummary> ingressPaths);

        /**
         * <p>
         * The entry point into this service revision.
         * </p>
         * 
         * @param ingressPaths
         *        The entry point into this service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPaths(IngressPathSummary... ingressPaths);

        /**
         * <p>
         * The entry point into this service revision.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.IngressPathSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.IngressPathSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.IngressPathSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #ingressPaths(List<IngressPathSummary>)}.
         * 
         * @param ingressPaths
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.IngressPathSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressPaths(java.util.Collection<IngressPathSummary>)
         */
        Builder ingressPaths(Consumer<IngressPathSummary.Builder>... ingressPaths);

        /**
         * <p>
         * The Unix timestamp for when this service revision was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp for when this service revision was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String serviceRevisionArn;

        private String executionRoleArn;

        private String taskRoleArn;

        private String cpu;

        private String memory;

        private ExpressGatewayServiceNetworkConfiguration networkConfiguration;

        private String healthCheckPath;

        private ExpressGatewayContainer primaryContainer;

        private ExpressGatewayScalingTarget scalingTarget;

        private List<IngressPathSummary> ingressPaths = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpressGatewayServiceConfiguration model) {
            serviceRevisionArn(model.serviceRevisionArn);
            executionRoleArn(model.executionRoleArn);
            taskRoleArn(model.taskRoleArn);
            cpu(model.cpu);
            memory(model.memory);
            networkConfiguration(model.networkConfiguration);
            healthCheckPath(model.healthCheckPath);
            primaryContainer(model.primaryContainer);
            scalingTarget(model.scalingTarget);
            ingressPaths(model.ingressPaths);
            createdAt(model.createdAt);
        }

        public final String getServiceRevisionArn() {
            return serviceRevisionArn;
        }

        public final void setServiceRevisionArn(String serviceRevisionArn) {
            this.serviceRevisionArn = serviceRevisionArn;
        }

        @Override
        public final Builder serviceRevisionArn(String serviceRevisionArn) {
            this.serviceRevisionArn = serviceRevisionArn;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getTaskRoleArn() {
            return taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final String getCpu() {
            return cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getMemory() {
            return memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final ExpressGatewayServiceNetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(ExpressGatewayServiceNetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(ExpressGatewayServiceNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getHealthCheckPath() {
            return healthCheckPath;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final ExpressGatewayContainer.Builder getPrimaryContainer() {
            return primaryContainer != null ? primaryContainer.toBuilder() : null;
        }

        public final void setPrimaryContainer(ExpressGatewayContainer.BuilderImpl primaryContainer) {
            this.primaryContainer = primaryContainer != null ? primaryContainer.build() : null;
        }

        @Override
        public final Builder primaryContainer(ExpressGatewayContainer primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        public final ExpressGatewayScalingTarget.Builder getScalingTarget() {
            return scalingTarget != null ? scalingTarget.toBuilder() : null;
        }

        public final void setScalingTarget(ExpressGatewayScalingTarget.BuilderImpl scalingTarget) {
            this.scalingTarget = scalingTarget != null ? scalingTarget.build() : null;
        }

        @Override
        public final Builder scalingTarget(ExpressGatewayScalingTarget scalingTarget) {
            this.scalingTarget = scalingTarget;
            return this;
        }

        public final List<IngressPathSummary.Builder> getIngressPaths() {
            List<IngressPathSummary.Builder> result = IngressPathSummariesCopier.copyToBuilder(this.ingressPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngressPaths(Collection<IngressPathSummary.BuilderImpl> ingressPaths) {
            this.ingressPaths = IngressPathSummariesCopier.copyFromBuilder(ingressPaths);
        }

        @Override
        public final Builder ingressPaths(Collection<IngressPathSummary> ingressPaths) {
            this.ingressPaths = IngressPathSummariesCopier.copy(ingressPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPaths(IngressPathSummary... ingressPaths) {
            ingressPaths(Arrays.asList(ingressPaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPaths(Consumer<IngressPathSummary.Builder>... ingressPaths) {
            ingressPaths(Stream.of(ingressPaths).map(c -> IngressPathSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public ExpressGatewayServiceConfiguration build() {
            return new ExpressGatewayServiceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
