/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the Amazon Web Services resources managed by Amazon ECS for an Express service, including ingress paths,
 * auto-scaling policies, metric alarms, and security groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ECSManagedResources implements SdkPojo, Serializable,
        ToCopyableBuilder<ECSManagedResources.Builder, ECSManagedResources> {
    private static final SdkField<List<ManagedIngressPath>> INGRESS_PATHS_FIELD = SdkField
            .<List<ManagedIngressPath>> builder(MarshallingType.LIST)
            .memberName("ingressPaths")
            .getter(getter(ECSManagedResources::ingressPaths))
            .setter(setter(Builder::ingressPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedIngressPath> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedIngressPath::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ManagedAutoScaling> AUTO_SCALING_FIELD = SdkField
            .<ManagedAutoScaling> builder(MarshallingType.SDK_POJO).memberName("autoScaling")
            .getter(getter(ECSManagedResources::autoScaling)).setter(setter(Builder::autoScaling))
            .constructor(ManagedAutoScaling::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScaling").build()).build();

    private static final SdkField<List<ManagedMetricAlarm>> METRIC_ALARMS_FIELD = SdkField
            .<List<ManagedMetricAlarm>> builder(MarshallingType.LIST)
            .memberName("metricAlarms")
            .getter(getter(ECSManagedResources::metricAlarms))
            .setter(setter(Builder::metricAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedMetricAlarm> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedMetricAlarm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ManagedSecurityGroup>> SERVICE_SECURITY_GROUPS_FIELD = SdkField
            .<List<ManagedSecurityGroup>> builder(MarshallingType.LIST)
            .memberName("serviceSecurityGroups")
            .getter(getter(ECSManagedResources::serviceSecurityGroups))
            .setter(setter(Builder::serviceSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ManagedLogGroup>> LOG_GROUPS_FIELD = SdkField
            .<List<ManagedLogGroup>> builder(MarshallingType.LIST)
            .memberName("logGroups")
            .getter(getter(ECSManagedResources::logGroups))
            .setter(setter(Builder::logGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedLogGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedLogGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGRESS_PATHS_FIELD,
            AUTO_SCALING_FIELD, METRIC_ALARMS_FIELD, SERVICE_SECURITY_GROUPS_FIELD, LOG_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ManagedIngressPath> ingressPaths;

    private final ManagedAutoScaling autoScaling;

    private final List<ManagedMetricAlarm> metricAlarms;

    private final List<ManagedSecurityGroup> serviceSecurityGroups;

    private final List<ManagedLogGroup> logGroups;

    private ECSManagedResources(BuilderImpl builder) {
        this.ingressPaths = builder.ingressPaths;
        this.autoScaling = builder.autoScaling;
        this.metricAlarms = builder.metricAlarms;
        this.serviceSecurityGroups = builder.serviceSecurityGroups;
        this.logGroups = builder.logGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the IngressPaths property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIngressPaths() {
        return ingressPaths != null && !(ingressPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ingress paths and endpoints for the Express service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIngressPaths} method.
     * </p>
     * 
     * @return The ingress paths and endpoints for the Express service.
     */
    public final List<ManagedIngressPath> ingressPaths() {
        return ingressPaths;
    }

    /**
     * <p>
     * The auto-scaling configuration and policies for the Express service.
     * </p>
     * 
     * @return The auto-scaling configuration and policies for the Express service.
     */
    public final ManagedAutoScaling autoScaling() {
        return autoScaling;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricAlarms() {
        return metricAlarms != null && !(metricAlarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CloudWatch metric alarms associated with the Express service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricAlarms} method.
     * </p>
     * 
     * @return The CloudWatch metric alarms associated with the Express service.
     */
    public final List<ManagedMetricAlarm> metricAlarms() {
        return metricAlarms;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceSecurityGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasServiceSecurityGroups() {
        return serviceSecurityGroups != null && !(serviceSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups managed by the Express service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceSecurityGroups} method.
     * </p>
     * 
     * @return The security groups managed by the Express service.
     */
    public final List<ManagedSecurityGroup> serviceSecurityGroups() {
        return serviceSecurityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogGroups() {
        return logGroups != null && !(logGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The log groups managed by the Express service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogGroups} method.
     * </p>
     * 
     * @return The log groups managed by the Express service.
     */
    public final List<ManagedLogGroup> logGroups() {
        return logGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIngressPaths() ? ingressPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoScaling());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricAlarms() ? metricAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceSecurityGroups() ? serviceSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroups() ? logGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSManagedResources)) {
            return false;
        }
        ECSManagedResources other = (ECSManagedResources) obj;
        return hasIngressPaths() == other.hasIngressPaths() && Objects.equals(ingressPaths(), other.ingressPaths())
                && Objects.equals(autoScaling(), other.autoScaling()) && hasMetricAlarms() == other.hasMetricAlarms()
                && Objects.equals(metricAlarms(), other.metricAlarms())
                && hasServiceSecurityGroups() == other.hasServiceSecurityGroups()
                && Objects.equals(serviceSecurityGroups(), other.serviceSecurityGroups())
                && hasLogGroups() == other.hasLogGroups() && Objects.equals(logGroups(), other.logGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ECSManagedResources").add("IngressPaths", hasIngressPaths() ? ingressPaths() : null)
                .add("AutoScaling", autoScaling()).add("MetricAlarms", hasMetricAlarms() ? metricAlarms() : null)
                .add("ServiceSecurityGroups", hasServiceSecurityGroups() ? serviceSecurityGroups() : null)
                .add("LogGroups", hasLogGroups() ? logGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ingressPaths":
            return Optional.ofNullable(clazz.cast(ingressPaths()));
        case "autoScaling":
            return Optional.ofNullable(clazz.cast(autoScaling()));
        case "metricAlarms":
            return Optional.ofNullable(clazz.cast(metricAlarms()));
        case "serviceSecurityGroups":
            return Optional.ofNullable(clazz.cast(serviceSecurityGroups()));
        case "logGroups":
            return Optional.ofNullable(clazz.cast(logGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ingressPaths", INGRESS_PATHS_FIELD);
        map.put("autoScaling", AUTO_SCALING_FIELD);
        map.put("metricAlarms", METRIC_ALARMS_FIELD);
        map.put("serviceSecurityGroups", SERVICE_SECURITY_GROUPS_FIELD);
        map.put("logGroups", LOG_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ECSManagedResources, T> g) {
        return obj -> g.apply((ECSManagedResources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ECSManagedResources> {
        /**
         * <p>
         * The ingress paths and endpoints for the Express service.
         * </p>
         * 
         * @param ingressPaths
         *        The ingress paths and endpoints for the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPaths(Collection<ManagedIngressPath> ingressPaths);

        /**
         * <p>
         * The ingress paths and endpoints for the Express service.
         * </p>
         * 
         * @param ingressPaths
         *        The ingress paths and endpoints for the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPaths(ManagedIngressPath... ingressPaths);

        /**
         * <p>
         * The ingress paths and endpoints for the Express service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ManagedIngressPath.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ManagedIngressPath#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ManagedIngressPath.Builder#build()} is called immediately
         * and its result is passed to {@link #ingressPaths(List<ManagedIngressPath>)}.
         * 
         * @param ingressPaths
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ManagedIngressPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressPaths(java.util.Collection<ManagedIngressPath>)
         */
        Builder ingressPaths(Consumer<ManagedIngressPath.Builder>... ingressPaths);

        /**
         * <p>
         * The auto-scaling configuration and policies for the Express service.
         * </p>
         * 
         * @param autoScaling
         *        The auto-scaling configuration and policies for the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScaling(ManagedAutoScaling autoScaling);

        /**
         * <p>
         * The auto-scaling configuration and policies for the Express service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedAutoScaling.Builder} avoiding the
         * need to create one manually via {@link ManagedAutoScaling#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedAutoScaling.Builder#build()} is called immediately and its
         * result is passed to {@link #autoScaling(ManagedAutoScaling)}.
         * 
         * @param autoScaling
         *        a consumer that will call methods on {@link ManagedAutoScaling.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScaling(ManagedAutoScaling)
         */
        default Builder autoScaling(Consumer<ManagedAutoScaling.Builder> autoScaling) {
            return autoScaling(ManagedAutoScaling.builder().applyMutation(autoScaling).build());
        }

        /**
         * <p>
         * The CloudWatch metric alarms associated with the Express service.
         * </p>
         * 
         * @param metricAlarms
         *        The CloudWatch metric alarms associated with the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(Collection<ManagedMetricAlarm> metricAlarms);

        /**
         * <p>
         * The CloudWatch metric alarms associated with the Express service.
         * </p>
         * 
         * @param metricAlarms
         *        The CloudWatch metric alarms associated with the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(ManagedMetricAlarm... metricAlarms);

        /**
         * <p>
         * The CloudWatch metric alarms associated with the Express service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ManagedMetricAlarm.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ManagedMetricAlarm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ManagedMetricAlarm.Builder#build()} is called immediately
         * and its result is passed to {@link #metricAlarms(List<ManagedMetricAlarm>)}.
         * 
         * @param metricAlarms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ManagedMetricAlarm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricAlarms(java.util.Collection<ManagedMetricAlarm>)
         */
        Builder metricAlarms(Consumer<ManagedMetricAlarm.Builder>... metricAlarms);

        /**
         * <p>
         * The security groups managed by the Express service.
         * </p>
         * 
         * @param serviceSecurityGroups
         *        The security groups managed by the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSecurityGroups(Collection<ManagedSecurityGroup> serviceSecurityGroups);

        /**
         * <p>
         * The security groups managed by the Express service.
         * </p>
         * 
         * @param serviceSecurityGroups
         *        The security groups managed by the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSecurityGroups(ManagedSecurityGroup... serviceSecurityGroups);

        /**
         * <p>
         * The security groups managed by the Express service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ManagedSecurityGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ecs.model.ManagedSecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ManagedSecurityGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceSecurityGroups(List<ManagedSecurityGroup>)}.
         * 
         * @param serviceSecurityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ManagedSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSecurityGroups(java.util.Collection<ManagedSecurityGroup>)
         */
        Builder serviceSecurityGroups(Consumer<ManagedSecurityGroup.Builder>... serviceSecurityGroups);

        /**
         * <p>
         * The log groups managed by the Express service.
         * </p>
         * 
         * @param logGroups
         *        The log groups managed by the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroups(Collection<ManagedLogGroup> logGroups);

        /**
         * <p>
         * The log groups managed by the Express service.
         * </p>
         * 
         * @param logGroups
         *        The log groups managed by the Express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroups(ManagedLogGroup... logGroups);

        /**
         * <p>
         * The log groups managed by the Express service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ManagedLogGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ManagedLogGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ManagedLogGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #logGroups(List<ManagedLogGroup>)}.
         * 
         * @param logGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ManagedLogGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logGroups(java.util.Collection<ManagedLogGroup>)
         */
        Builder logGroups(Consumer<ManagedLogGroup.Builder>... logGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<ManagedIngressPath> ingressPaths = DefaultSdkAutoConstructList.getInstance();

        private ManagedAutoScaling autoScaling;

        private List<ManagedMetricAlarm> metricAlarms = DefaultSdkAutoConstructList.getInstance();

        private List<ManagedSecurityGroup> serviceSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<ManagedLogGroup> logGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ECSManagedResources model) {
            ingressPaths(model.ingressPaths);
            autoScaling(model.autoScaling);
            metricAlarms(model.metricAlarms);
            serviceSecurityGroups(model.serviceSecurityGroups);
            logGroups(model.logGroups);
        }

        public final List<ManagedIngressPath.Builder> getIngressPaths() {
            List<ManagedIngressPath.Builder> result = ManagedIngressPathsCopier.copyToBuilder(this.ingressPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngressPaths(Collection<ManagedIngressPath.BuilderImpl> ingressPaths) {
            this.ingressPaths = ManagedIngressPathsCopier.copyFromBuilder(ingressPaths);
        }

        @Override
        public final Builder ingressPaths(Collection<ManagedIngressPath> ingressPaths) {
            this.ingressPaths = ManagedIngressPathsCopier.copy(ingressPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPaths(ManagedIngressPath... ingressPaths) {
            ingressPaths(Arrays.asList(ingressPaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPaths(Consumer<ManagedIngressPath.Builder>... ingressPaths) {
            ingressPaths(Stream.of(ingressPaths).map(c -> ManagedIngressPath.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ManagedAutoScaling.Builder getAutoScaling() {
            return autoScaling != null ? autoScaling.toBuilder() : null;
        }

        public final void setAutoScaling(ManagedAutoScaling.BuilderImpl autoScaling) {
            this.autoScaling = autoScaling != null ? autoScaling.build() : null;
        }

        @Override
        public final Builder autoScaling(ManagedAutoScaling autoScaling) {
            this.autoScaling = autoScaling;
            return this;
        }

        public final List<ManagedMetricAlarm.Builder> getMetricAlarms() {
            List<ManagedMetricAlarm.Builder> result = ManagedMetricAlarmsCopier.copyToBuilder(this.metricAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricAlarms(Collection<ManagedMetricAlarm.BuilderImpl> metricAlarms) {
            this.metricAlarms = ManagedMetricAlarmsCopier.copyFromBuilder(metricAlarms);
        }

        @Override
        public final Builder metricAlarms(Collection<ManagedMetricAlarm> metricAlarms) {
            this.metricAlarms = ManagedMetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(ManagedMetricAlarm... metricAlarms) {
            metricAlarms(Arrays.asList(metricAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(Consumer<ManagedMetricAlarm.Builder>... metricAlarms) {
            metricAlarms(Stream.of(metricAlarms).map(c -> ManagedMetricAlarm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ManagedSecurityGroup.Builder> getServiceSecurityGroups() {
            List<ManagedSecurityGroup.Builder> result = ManagedSecurityGroupsCopier.copyToBuilder(this.serviceSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceSecurityGroups(Collection<ManagedSecurityGroup.BuilderImpl> serviceSecurityGroups) {
            this.serviceSecurityGroups = ManagedSecurityGroupsCopier.copyFromBuilder(serviceSecurityGroups);
        }

        @Override
        public final Builder serviceSecurityGroups(Collection<ManagedSecurityGroup> serviceSecurityGroups) {
            this.serviceSecurityGroups = ManagedSecurityGroupsCopier.copy(serviceSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSecurityGroups(ManagedSecurityGroup... serviceSecurityGroups) {
            serviceSecurityGroups(Arrays.asList(serviceSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSecurityGroups(Consumer<ManagedSecurityGroup.Builder>... serviceSecurityGroups) {
            serviceSecurityGroups(Stream.of(serviceSecurityGroups)
                    .map(c -> ManagedSecurityGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ManagedLogGroup.Builder> getLogGroups() {
            List<ManagedLogGroup.Builder> result = ManagedLogGroupsCopier.copyToBuilder(this.logGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogGroups(Collection<ManagedLogGroup.BuilderImpl> logGroups) {
            this.logGroups = ManagedLogGroupsCopier.copyFromBuilder(logGroups);
        }

        @Override
        public final Builder logGroups(Collection<ManagedLogGroup> logGroups) {
            this.logGroups = ManagedLogGroupsCopier.copy(logGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(ManagedLogGroup... logGroups) {
            logGroups(Arrays.asList(logGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(Consumer<ManagedLogGroup.Builder>... logGroups) {
            logGroups(Stream.of(logGroups).map(c -> ManagedLogGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ECSManagedResources build() {
            return new ECSManagedResources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
