/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayServiceScalingMetric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpressGatewayScalingTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpressGatewayScalingTarget> {
    private static final SdkField<Integer> MIN_TASK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minTaskCount").getter(ExpressGatewayScalingTarget.getter(ExpressGatewayScalingTarget::minTaskCount)).setter(ExpressGatewayScalingTarget.setter(Builder::minTaskCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minTaskCount").build()}).build();
    private static final SdkField<Integer> MAX_TASK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxTaskCount").getter(ExpressGatewayScalingTarget.getter(ExpressGatewayScalingTarget::maxTaskCount)).setter(ExpressGatewayScalingTarget.setter(Builder::maxTaskCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxTaskCount").build()}).build();
    private static final SdkField<String> AUTO_SCALING_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoScalingMetric").getter(ExpressGatewayScalingTarget.getter(ExpressGatewayScalingTarget::autoScalingMetricAsString)).setter(ExpressGatewayScalingTarget.setter(Builder::autoScalingMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingMetric").build()}).build();
    private static final SdkField<Integer> AUTO_SCALING_TARGET_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("autoScalingTargetValue").getter(ExpressGatewayScalingTarget.getter(ExpressGatewayScalingTarget::autoScalingTargetValue)).setter(ExpressGatewayScalingTarget.setter(Builder::autoScalingTargetValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingTargetValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_TASK_COUNT_FIELD, MAX_TASK_COUNT_FIELD, AUTO_SCALING_METRIC_FIELD, AUTO_SCALING_TARGET_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExpressGatewayScalingTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer minTaskCount;
    private final Integer maxTaskCount;
    private final String autoScalingMetric;
    private final Integer autoScalingTargetValue;

    private ExpressGatewayScalingTarget(BuilderImpl builder) {
        this.minTaskCount = builder.minTaskCount;
        this.maxTaskCount = builder.maxTaskCount;
        this.autoScalingMetric = builder.autoScalingMetric;
        this.autoScalingTargetValue = builder.autoScalingTargetValue;
    }

    public final Integer minTaskCount() {
        return this.minTaskCount;
    }

    public final Integer maxTaskCount() {
        return this.maxTaskCount;
    }

    public final ExpressGatewayServiceScalingMetric autoScalingMetric() {
        return ExpressGatewayServiceScalingMetric.fromValue(this.autoScalingMetric);
    }

    public final String autoScalingMetricAsString() {
        return this.autoScalingMetric;
    }

    public final Integer autoScalingTargetValue() {
        return this.autoScalingTargetValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingMetricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingTargetValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpressGatewayScalingTarget)) {
            return false;
        }
        ExpressGatewayScalingTarget other = (ExpressGatewayScalingTarget)obj;
        return Objects.equals(this.minTaskCount(), other.minTaskCount()) && Objects.equals(this.maxTaskCount(), other.maxTaskCount()) && Objects.equals(this.autoScalingMetricAsString(), other.autoScalingMetricAsString()) && Objects.equals(this.autoScalingTargetValue(), other.autoScalingTargetValue());
    }

    public final String toString() {
        return ToString.builder((String)"ExpressGatewayScalingTarget").add("MinTaskCount", (Object)this.minTaskCount()).add("MaxTaskCount", (Object)this.maxTaskCount()).add("AutoScalingMetric", (Object)this.autoScalingMetricAsString()).add("AutoScalingTargetValue", (Object)this.autoScalingTargetValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "minTaskCount": {
                return Optional.ofNullable(clazz.cast(this.minTaskCount()));
            }
            case "maxTaskCount": {
                return Optional.ofNullable(clazz.cast(this.maxTaskCount()));
            }
            case "autoScalingMetric": {
                return Optional.ofNullable(clazz.cast(this.autoScalingMetricAsString()));
            }
            case "autoScalingTargetValue": {
                return Optional.ofNullable(clazz.cast(this.autoScalingTargetValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("minTaskCount", MIN_TASK_COUNT_FIELD);
        map.put("maxTaskCount", MAX_TASK_COUNT_FIELD);
        map.put("autoScalingMetric", AUTO_SCALING_METRIC_FIELD);
        map.put("autoScalingTargetValue", AUTO_SCALING_TARGET_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpressGatewayScalingTarget, T> g) {
        return obj -> g.apply((ExpressGatewayScalingTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minTaskCount;
        private Integer maxTaskCount;
        private String autoScalingMetric;
        private Integer autoScalingTargetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpressGatewayScalingTarget model) {
            this.minTaskCount(model.minTaskCount);
            this.maxTaskCount(model.maxTaskCount);
            this.autoScalingMetric(model.autoScalingMetric);
            this.autoScalingTargetValue(model.autoScalingTargetValue);
        }

        public final Integer getMinTaskCount() {
            return this.minTaskCount;
        }

        public final void setMinTaskCount(Integer minTaskCount) {
            this.minTaskCount = minTaskCount;
        }

        @Override
        public final Builder minTaskCount(Integer minTaskCount) {
            this.minTaskCount = minTaskCount;
            return this;
        }

        public final Integer getMaxTaskCount() {
            return this.maxTaskCount;
        }

        public final void setMaxTaskCount(Integer maxTaskCount) {
            this.maxTaskCount = maxTaskCount;
        }

        @Override
        public final Builder maxTaskCount(Integer maxTaskCount) {
            this.maxTaskCount = maxTaskCount;
            return this;
        }

        public final String getAutoScalingMetric() {
            return this.autoScalingMetric;
        }

        public final void setAutoScalingMetric(String autoScalingMetric) {
            this.autoScalingMetric = autoScalingMetric;
        }

        @Override
        public final Builder autoScalingMetric(String autoScalingMetric) {
            this.autoScalingMetric = autoScalingMetric;
            return this;
        }

        @Override
        public final Builder autoScalingMetric(ExpressGatewayServiceScalingMetric autoScalingMetric) {
            this.autoScalingMetric(autoScalingMetric == null ? null : autoScalingMetric.toString());
            return this;
        }

        public final Integer getAutoScalingTargetValue() {
            return this.autoScalingTargetValue;
        }

        public final void setAutoScalingTargetValue(Integer autoScalingTargetValue) {
            this.autoScalingTargetValue = autoScalingTargetValue;
        }

        @Override
        public final Builder autoScalingTargetValue(Integer autoScalingTargetValue) {
            this.autoScalingTargetValue = autoScalingTargetValue;
            return this;
        }

        public ExpressGatewayScalingTarget build() {
            return new ExpressGatewayScalingTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpressGatewayScalingTarget> {
        public Builder minTaskCount(Integer var1);

        public Builder maxTaskCount(Integer var1);

        public Builder autoScalingMetric(String var1);

        public Builder autoScalingMetric(ExpressGatewayServiceScalingMetric var1);

        public Builder autoScalingTargetValue(Integer var1);
    }
}

