/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ContainerInstanceField;
import software.amazon.awssdk.services.ecs.model.ContainerInstanceFieldListCopier;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeContainerInstancesRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, DescribeContainerInstancesRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(DescribeContainerInstancesRequest.getter(DescribeContainerInstancesRequest::cluster)).setter(DescribeContainerInstancesRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<List<String>> CONTAINER_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerInstances").getter(DescribeContainerInstancesRequest.getter(DescribeContainerInstancesRequest::containerInstances)).setter(DescribeContainerInstancesRequest.setter(Builder::containerInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("include").getter(DescribeContainerInstancesRequest.getter(DescribeContainerInstancesRequest::includeAsStrings)).setter(DescribeContainerInstancesRequest.setter(Builder::includeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, CONTAINER_INSTANCES_FIELD, INCLUDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeContainerInstancesRequest.memberNameToFieldInitializer();
    private final String cluster;
    private final List<String> containerInstances;
    private final List<String> include;

    private DescribeContainerInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.containerInstances = builder.containerInstances;
        this.include = builder.include;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final boolean hasContainerInstances() {
        return this.containerInstances != null && !(this.containerInstances instanceof SdkAutoConstructList);
    }

    public final List<String> containerInstances() {
        return this.containerInstances;
    }

    public final List<ContainerInstanceField> include() {
        return ContainerInstanceFieldListCopier.copyStringToEnum(this.include);
    }

    public final boolean hasInclude() {
        return this.include != null && !(this.include instanceof SdkAutoConstructList);
    }

    public final List<String> includeAsStrings() {
        return this.include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerInstances() ? this.containerInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclude() ? this.includeAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContainerInstancesRequest)) {
            return false;
        }
        DescribeContainerInstancesRequest other = (DescribeContainerInstancesRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && this.hasContainerInstances() == other.hasContainerInstances() && Objects.equals(this.containerInstances(), other.containerInstances()) && this.hasInclude() == other.hasInclude() && Objects.equals(this.includeAsStrings(), other.includeAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeContainerInstancesRequest").add("Cluster", (Object)this.cluster()).add("ContainerInstances", this.hasContainerInstances() ? this.containerInstances() : null).add("Include", this.hasInclude() ? this.includeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "containerInstances": {
                return Optional.ofNullable(clazz.cast(this.containerInstances()));
            }
            case "include": {
                return Optional.ofNullable(clazz.cast(this.includeAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cluster", CLUSTER_FIELD);
        map.put("containerInstances", CONTAINER_INSTANCES_FIELD);
        map.put("include", INCLUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeContainerInstancesRequest, T> g) {
        return obj -> g.apply((DescribeContainerInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private List<String> containerInstances = DefaultSdkAutoConstructList.getInstance();
        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContainerInstancesRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.containerInstances(model.containerInstances);
            this.includeWithStrings(model.include);
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final Collection<String> getContainerInstances() {
            if (this.containerInstances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerInstances;
        }

        public final void setContainerInstances(Collection<String> containerInstances) {
            this.containerInstances = StringListCopier.copy(containerInstances);
        }

        @Override
        public final Builder containerInstances(Collection<String> containerInstances) {
            this.containerInstances = StringListCopier.copy(containerInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerInstances(String ... containerInstances) {
            this.containerInstances(Arrays.asList(containerInstances));
            return this;
        }

        public final Collection<String> getInclude() {
            if (this.include instanceof SdkAutoConstructList) {
                return null;
            }
            return this.include;
        }

        public final void setInclude(Collection<String> include) {
            this.include = ContainerInstanceFieldListCopier.copy(include);
        }

        @Override
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = ContainerInstanceFieldListCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeWithStrings(String ... include) {
            this.includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        public final Builder include(Collection<ContainerInstanceField> include) {
            this.include = ContainerInstanceFieldListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(ContainerInstanceField ... include) {
            this.include(Arrays.asList(include));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeContainerInstancesRequest build() {
            return new DescribeContainerInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeContainerInstancesRequest> {
        public Builder cluster(String var1);

        public Builder containerInstances(Collection<String> var1);

        public Builder containerInstances(String ... var1);

        public Builder includeWithStrings(Collection<String> var1);

        public Builder includeWithStrings(String ... var1);

        public Builder include(Collection<ContainerInstanceField> var1);

        public Builder include(ContainerInstanceField ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

