/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The updated launch template configuration for Amazon ECS Managed Instances. You can modify the instance profile,
 * network configuration, storage settings, and instance requirements. Changes apply to new instances launched after the
 * update.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Store instance launch parameters
 * in Amazon EC2 launch templates</a> in the <i>Amazon EC2 User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceLaunchTemplateUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceLaunchTemplateUpdate.Builder, InstanceLaunchTemplateUpdate> {
    private static final SdkField<String> EC2_INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2InstanceProfileArn").getter(getter(InstanceLaunchTemplateUpdate::ec2InstanceProfileArn))
            .setter(setter(Builder::ec2InstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceProfileArn").build())
            .build();

    private static final SdkField<ManagedInstancesNetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<ManagedInstancesNetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(InstanceLaunchTemplateUpdate::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(ManagedInstancesNetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<ManagedInstancesStorageConfiguration> STORAGE_CONFIGURATION_FIELD = SdkField
            .<ManagedInstancesStorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("storageConfiguration")
            .getter(getter(InstanceLaunchTemplateUpdate::storageConfiguration)).setter(setter(Builder::storageConfiguration))
            .constructor(ManagedInstancesStorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfiguration").build())
            .build();

    private static final SdkField<String> MONITORING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitoring").getter(getter(InstanceLaunchTemplateUpdate::monitoringAsString))
            .setter(setter(Builder::monitoring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoring").build()).build();

    private static final SdkField<InstanceRequirementsRequest> INSTANCE_REQUIREMENTS_FIELD = SdkField
            .<InstanceRequirementsRequest> builder(MarshallingType.SDK_POJO).memberName("instanceRequirements")
            .getter(getter(InstanceLaunchTemplateUpdate::instanceRequirements)).setter(setter(Builder::instanceRequirements))
            .constructor(InstanceRequirementsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceRequirements").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EC2_INSTANCE_PROFILE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD, STORAGE_CONFIGURATION_FIELD, MONITORING_FIELD,
            INSTANCE_REQUIREMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ec2InstanceProfileArn;

    private final ManagedInstancesNetworkConfiguration networkConfiguration;

    private final ManagedInstancesStorageConfiguration storageConfiguration;

    private final String monitoring;

    private final InstanceRequirementsRequest instanceRequirements;

    private InstanceLaunchTemplateUpdate(BuilderImpl builder) {
        this.ec2InstanceProfileArn = builder.ec2InstanceProfileArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.storageConfiguration = builder.storageConfiguration;
        this.monitoring = builder.monitoring;
        this.instanceRequirements = builder.instanceRequirements;
    }

    /**
     * <p>
     * The updated Amazon Resource Name (ARN) of the instance profile. The new instance profile must have the necessary
     * permissions for your tasks.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/managed-instances-instance-profile.html">Amazon
     * ECS instance profile for Managed Instances</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * 
     * @return The updated Amazon Resource Name (ARN) of the instance profile. The new instance profile must have the
     *         necessary permissions for your tasks.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/managed-instances-instance-profile.html"
     *         >Amazon ECS instance profile for Managed Instances</a> in the <i>Amazon ECS Developer Guide</i>.
     */
    public final String ec2InstanceProfileArn() {
        return ec2InstanceProfileArn;
    }

    /**
     * <p>
     * The updated network configuration for Amazon ECS Managed Instances. Changes to subnets and security groups affect
     * new instances launched after the update.
     * </p>
     * 
     * @return The updated network configuration for Amazon ECS Managed Instances. Changes to subnets and security
     *         groups affect new instances launched after the update.
     */
    public final ManagedInstancesNetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The updated storage configuration for Amazon ECS Managed Instances. Changes to storage settings apply to new
     * instances launched after the update.
     * </p>
     * 
     * @return The updated storage configuration for Amazon ECS Managed Instances. Changes to storage settings apply to
     *         new instances launched after the update.
     */
    public final ManagedInstancesStorageConfiguration storageConfiguration() {
        return storageConfiguration;
    }

    /**
     * <p>
     * CloudWatch provides two categories of monitoring: basic monitoring and detailed monitoring. By default, your
     * managed instance is configured for basic monitoring. You can optionally enable detailed monitoring to help you
     * more quickly identify and act on operational issues. You can enable or turn off detailed monitoring at launch or
     * when the managed instance is running or stopped. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/detailed-monitoring-managed-instances.html"
     * >Detailed monitoring for Amazon ECS Managed Instances</a> in the Amazon ECS Developer Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitoring} will
     * return {@link ManagedInstancesMonitoringOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #monitoringAsString}.
     * </p>
     * 
     * @return CloudWatch provides two categories of monitoring: basic monitoring and detailed monitoring. By default,
     *         your managed instance is configured for basic monitoring. You can optionally enable detailed monitoring
     *         to help you more quickly identify and act on operational issues. You can enable or turn off detailed
     *         monitoring at launch or when the managed instance is running or stopped. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/detailed-monitoring-managed-instances.html"
     *         >Detailed monitoring for Amazon ECS Managed Instances</a> in the Amazon ECS Developer Guide.
     * @see ManagedInstancesMonitoringOptions
     */
    public final ManagedInstancesMonitoringOptions monitoring() {
        return ManagedInstancesMonitoringOptions.fromValue(monitoring);
    }

    /**
     * <p>
     * CloudWatch provides two categories of monitoring: basic monitoring and detailed monitoring. By default, your
     * managed instance is configured for basic monitoring. You can optionally enable detailed monitoring to help you
     * more quickly identify and act on operational issues. You can enable or turn off detailed monitoring at launch or
     * when the managed instance is running or stopped. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/detailed-monitoring-managed-instances.html"
     * >Detailed monitoring for Amazon ECS Managed Instances</a> in the Amazon ECS Developer Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitoring} will
     * return {@link ManagedInstancesMonitoringOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #monitoringAsString}.
     * </p>
     * 
     * @return CloudWatch provides two categories of monitoring: basic monitoring and detailed monitoring. By default,
     *         your managed instance is configured for basic monitoring. You can optionally enable detailed monitoring
     *         to help you more quickly identify and act on operational issues. You can enable or turn off detailed
     *         monitoring at launch or when the managed instance is running or stopped. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/detailed-monitoring-managed-instances.html"
     *         >Detailed monitoring for Amazon ECS Managed Instances</a> in the Amazon ECS Developer Guide.
     * @see ManagedInstancesMonitoringOptions
     */
    public final String monitoringAsString() {
        return monitoring;
    }

    /**
     * <p>
     * The updated instance requirements for attribute-based instance type selection. Changes to instance requirements
     * affect which instance types Amazon ECS selects for new instances.
     * </p>
     * 
     * @return The updated instance requirements for attribute-based instance type selection. Changes to instance
     *         requirements affect which instance types Amazon ECS selects for new instances.
     */
    public final InstanceRequirementsRequest instanceRequirements() {
        return instanceRequirements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(storageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRequirements());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceLaunchTemplateUpdate)) {
            return false;
        }
        InstanceLaunchTemplateUpdate other = (InstanceLaunchTemplateUpdate) obj;
        return Objects.equals(ec2InstanceProfileArn(), other.ec2InstanceProfileArn())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(storageConfiguration(), other.storageConfiguration())
                && Objects.equals(monitoringAsString(), other.monitoringAsString())
                && Objects.equals(instanceRequirements(), other.instanceRequirements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceLaunchTemplateUpdate").add("Ec2InstanceProfileArn", ec2InstanceProfileArn())
                .add("NetworkConfiguration", networkConfiguration()).add("StorageConfiguration", storageConfiguration())
                .add("Monitoring", monitoringAsString()).add("InstanceRequirements", instanceRequirements()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ec2InstanceProfileArn":
            return Optional.ofNullable(clazz.cast(ec2InstanceProfileArn()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "storageConfiguration":
            return Optional.ofNullable(clazz.cast(storageConfiguration()));
        case "monitoring":
            return Optional.ofNullable(clazz.cast(monitoringAsString()));
        case "instanceRequirements":
            return Optional.ofNullable(clazz.cast(instanceRequirements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ec2InstanceProfileArn", EC2_INSTANCE_PROFILE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("storageConfiguration", STORAGE_CONFIGURATION_FIELD);
        map.put("monitoring", MONITORING_FIELD);
        map.put("instanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceLaunchTemplateUpdate, T> g) {
        return obj -> g.apply((InstanceLaunchTemplateUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceLaunchTemplateUpdate> {
        /**
         * <p>
         * The updated Amazon Resource Name (ARN) of the instance profile. The new instance profile must have the
         * necessary permissions for your tasks.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/managed-instances-instance-profile.html"
         * >Amazon ECS instance profile for Managed Instances</a> in the <i>Amazon ECS Developer Guide</i>.
         * </p>
         * 
         * @param ec2InstanceProfileArn
         *        The updated Amazon Resource Name (ARN) of the instance profile. The new instance profile must have the
         *        necessary permissions for your tasks.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/managed-instances-instance-profile.html"
         *        >Amazon ECS instance profile for Managed Instances</a> in the <i>Amazon ECS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceProfileArn(String ec2InstanceProfileArn);

        /**
         * <p>
         * The updated network configuration for Amazon ECS Managed Instances. Changes to subnets and security groups
         * affect new instances launched after the update.
         * </p>
         * 
         * @param networkConfiguration
         *        The updated network configuration for Amazon ECS Managed Instances. Changes to subnets and security
         *        groups affect new instances launched after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(ManagedInstancesNetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The updated network configuration for Amazon ECS Managed Instances. Changes to subnets and security groups
         * affect new instances launched after the update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ManagedInstancesNetworkConfiguration.Builder} avoiding the need to create one manually via
         * {@link ManagedInstancesNetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedInstancesNetworkConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #networkConfiguration(ManagedInstancesNetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link ManagedInstancesNetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(ManagedInstancesNetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<ManagedInstancesNetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(ManagedInstancesNetworkConfiguration.builder().applyMutation(networkConfiguration)
                    .build());
        }

        /**
         * <p>
         * The updated storage configuration for Amazon ECS Managed Instances. Changes to storage settings apply to new
         * instances launched after the update.
         * </p>
         * 
         * @param storageConfiguration
         *        The updated storage configuration for Amazon ECS Managed Instances. Changes to storage settings apply
         *        to new instances launched after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfiguration(ManagedInstancesStorageConfiguration storageConfiguration);

        /**
         * <p>
         * The updated storage configuration for Amazon ECS Managed Instances. Changes to storage settings apply to new
         * instances launched after the update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ManagedInstancesStorageConfiguration.Builder} avoiding the need to create one manually via
         * {@link ManagedInstancesStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedInstancesStorageConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #storageConfiguration(ManagedInstancesStorageConfiguration)}.
         * 
         * @param storageConfiguration
         *        a consumer that will call methods on {@link ManagedInstancesStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfiguration(ManagedInstancesStorageConfiguration)
         */
        default Builder storageConfiguration(Consumer<ManagedInstancesStorageConfiguration.Builder> storageConfiguration) {
            return storageConfiguration(ManagedInstancesStorageConfiguration.builder().applyMutation(storageConfiguration)
                    .build());
        }

        /**
         * <p>
         * CloudWatch provides two categories of monitoring: basic monitoring and detailed monitoring. By default, your
         * managed instance is configured for basic monitoring. You can optionally enable detailed monitoring to help
         * you more quickly identify and act on operational issues. You can enable or turn off detailed monitoring at
         * launch or when the managed instance is running or stopped. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/detailed-monitoring-managed-instances.html"
         * >Detailed monitoring for Amazon ECS Managed Instances</a> in the Amazon ECS Developer Guide.
         * </p>
         * 
         * @param monitoring
         *        CloudWatch provides two categories of monitoring: basic monitoring and detailed monitoring. By
         *        default, your managed instance is configured for basic monitoring. You can optionally enable detailed
         *        monitoring to help you more quickly identify and act on operational issues. You can enable or turn off
         *        detailed monitoring at launch or when the managed instance is running or stopped. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/detailed-monitoring-managed-instances.html"
         *        >Detailed monitoring for Amazon ECS Managed Instances</a> in the Amazon ECS Developer Guide.
         * @see ManagedInstancesMonitoringOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedInstancesMonitoringOptions
         */
        Builder monitoring(String monitoring);

        /**
         * <p>
         * CloudWatch provides two categories of monitoring: basic monitoring and detailed monitoring. By default, your
         * managed instance is configured for basic monitoring. You can optionally enable detailed monitoring to help
         * you more quickly identify and act on operational issues. You can enable or turn off detailed monitoring at
         * launch or when the managed instance is running or stopped. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/detailed-monitoring-managed-instances.html"
         * >Detailed monitoring for Amazon ECS Managed Instances</a> in the Amazon ECS Developer Guide.
         * </p>
         * 
         * @param monitoring
         *        CloudWatch provides two categories of monitoring: basic monitoring and detailed monitoring. By
         *        default, your managed instance is configured for basic monitoring. You can optionally enable detailed
         *        monitoring to help you more quickly identify and act on operational issues. You can enable or turn off
         *        detailed monitoring at launch or when the managed instance is running or stopped. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/detailed-monitoring-managed-instances.html"
         *        >Detailed monitoring for Amazon ECS Managed Instances</a> in the Amazon ECS Developer Guide.
         * @see ManagedInstancesMonitoringOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedInstancesMonitoringOptions
         */
        Builder monitoring(ManagedInstancesMonitoringOptions monitoring);

        /**
         * <p>
         * The updated instance requirements for attribute-based instance type selection. Changes to instance
         * requirements affect which instance types Amazon ECS selects for new instances.
         * </p>
         * 
         * @param instanceRequirements
         *        The updated instance requirements for attribute-based instance type selection. Changes to instance
         *        requirements affect which instance types Amazon ECS selects for new instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements);

        /**
         * <p>
         * The updated instance requirements for attribute-based instance type selection. Changes to instance
         * requirements affect which instance types Amazon ECS selects for new instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceRequirementsRequest.Builder}
         * avoiding the need to create one manually via {@link InstanceRequirementsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceRequirementsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceRequirements(InstanceRequirementsRequest)}.
         * 
         * @param instanceRequirements
         *        a consumer that will call methods on {@link InstanceRequirementsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRequirements(InstanceRequirementsRequest)
         */
        default Builder instanceRequirements(Consumer<InstanceRequirementsRequest.Builder> instanceRequirements) {
            return instanceRequirements(InstanceRequirementsRequest.builder().applyMutation(instanceRequirements).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String ec2InstanceProfileArn;

        private ManagedInstancesNetworkConfiguration networkConfiguration;

        private ManagedInstancesStorageConfiguration storageConfiguration;

        private String monitoring;

        private InstanceRequirementsRequest instanceRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceLaunchTemplateUpdate model) {
            ec2InstanceProfileArn(model.ec2InstanceProfileArn);
            networkConfiguration(model.networkConfiguration);
            storageConfiguration(model.storageConfiguration);
            monitoring(model.monitoring);
            instanceRequirements(model.instanceRequirements);
        }

        public final String getEc2InstanceProfileArn() {
            return ec2InstanceProfileArn;
        }

        public final void setEc2InstanceProfileArn(String ec2InstanceProfileArn) {
            this.ec2InstanceProfileArn = ec2InstanceProfileArn;
        }

        @Override
        public final Builder ec2InstanceProfileArn(String ec2InstanceProfileArn) {
            this.ec2InstanceProfileArn = ec2InstanceProfileArn;
            return this;
        }

        public final ManagedInstancesNetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(ManagedInstancesNetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(ManagedInstancesNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final ManagedInstancesStorageConfiguration.Builder getStorageConfiguration() {
            return storageConfiguration != null ? storageConfiguration.toBuilder() : null;
        }

        public final void setStorageConfiguration(ManagedInstancesStorageConfiguration.BuilderImpl storageConfiguration) {
            this.storageConfiguration = storageConfiguration != null ? storageConfiguration.build() : null;
        }

        @Override
        public final Builder storageConfiguration(ManagedInstancesStorageConfiguration storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        public final String getMonitoring() {
            return monitoring;
        }

        public final void setMonitoring(String monitoring) {
            this.monitoring = monitoring;
        }

        @Override
        public final Builder monitoring(String monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        @Override
        public final Builder monitoring(ManagedInstancesMonitoringOptions monitoring) {
            this.monitoring(monitoring == null ? null : monitoring.toString());
            return this;
        }

        public final InstanceRequirementsRequest.Builder getInstanceRequirements() {
            return instanceRequirements != null ? instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirementsRequest.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        @Override
        public InstanceLaunchTemplateUpdate build() {
            return new InstanceLaunchTemplateUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
