/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse;

public class ListTaskDefinitionFamiliesIterable
implements SdkIterable<ListTaskDefinitionFamiliesResponse> {
    private final EcsClient client;
    private final ListTaskDefinitionFamiliesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTaskDefinitionFamiliesIterable(EcsClient client, ListTaskDefinitionFamiliesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTaskDefinitionFamiliesResponseFetcher();
    }

    public Iterator<ListTaskDefinitionFamiliesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> families() {
        Function<ListTaskDefinitionFamiliesResponse, Iterator> getIterator = response -> {
            if (response != null && response.families() != null) {
                return response.families().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTaskDefinitionFamiliesResponseFetcher
    implements SyncPageFetcher<ListTaskDefinitionFamiliesResponse> {
        private ListTaskDefinitionFamiliesResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskDefinitionFamiliesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTaskDefinitionFamiliesResponse nextPage(ListTaskDefinitionFamiliesResponse previousPage) {
            if (previousPage == null) {
                return ListTaskDefinitionFamiliesIterable.this.client.listTaskDefinitionFamilies(ListTaskDefinitionFamiliesIterable.this.firstRequest);
            }
            return ListTaskDefinitionFamiliesIterable.this.client.listTaskDefinitionFamilies((ListTaskDefinitionFamiliesRequest)((Object)ListTaskDefinitionFamiliesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

