/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.InstanceLaunchTemplate;
import software.amazon.awssdk.services.ecs.model.PropagateMITags;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateManagedInstancesProviderConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateManagedInstancesProviderConfiguration> {
    private static final SdkField<String> INFRASTRUCTURE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("infrastructureRoleArn").getter(CreateManagedInstancesProviderConfiguration.getter(CreateManagedInstancesProviderConfiguration::infrastructureRoleArn)).setter(CreateManagedInstancesProviderConfiguration.setter(Builder::infrastructureRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureRoleArn").build()}).build();
    private static final SdkField<InstanceLaunchTemplate> INSTANCE_LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceLaunchTemplate").getter(CreateManagedInstancesProviderConfiguration.getter(CreateManagedInstancesProviderConfiguration::instanceLaunchTemplate)).setter(CreateManagedInstancesProviderConfiguration.setter(Builder::instanceLaunchTemplate)).constructor(InstanceLaunchTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceLaunchTemplate").build()}).build();
    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propagateTags").getter(CreateManagedInstancesProviderConfiguration.getter(CreateManagedInstancesProviderConfiguration::propagateTagsAsString)).setter(CreateManagedInstancesProviderConfiguration.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFRASTRUCTURE_ROLE_ARN_FIELD, INSTANCE_LAUNCH_TEMPLATE_FIELD, PROPAGATE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateManagedInstancesProviderConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String infrastructureRoleArn;
    private final InstanceLaunchTemplate instanceLaunchTemplate;
    private final String propagateTags;

    private CreateManagedInstancesProviderConfiguration(BuilderImpl builder) {
        this.infrastructureRoleArn = builder.infrastructureRoleArn;
        this.instanceLaunchTemplate = builder.instanceLaunchTemplate;
        this.propagateTags = builder.propagateTags;
    }

    public final String infrastructureRoleArn() {
        return this.infrastructureRoleArn;
    }

    public final InstanceLaunchTemplate instanceLaunchTemplate() {
        return this.instanceLaunchTemplate;
    }

    public final PropagateMITags propagateTags() {
        return PropagateMITags.fromValue(this.propagateTags);
    }

    public final String propagateTagsAsString() {
        return this.propagateTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceLaunchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTagsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateManagedInstancesProviderConfiguration)) {
            return false;
        }
        CreateManagedInstancesProviderConfiguration other = (CreateManagedInstancesProviderConfiguration)obj;
        return Objects.equals(this.infrastructureRoleArn(), other.infrastructureRoleArn()) && Objects.equals(this.instanceLaunchTemplate(), other.instanceLaunchTemplate()) && Objects.equals(this.propagateTagsAsString(), other.propagateTagsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateManagedInstancesProviderConfiguration").add("InfrastructureRoleArn", (Object)this.infrastructureRoleArn()).add("InstanceLaunchTemplate", (Object)this.instanceLaunchTemplate()).add("PropagateTags", (Object)this.propagateTagsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "infrastructureRoleArn": {
                return Optional.ofNullable(clazz.cast(this.infrastructureRoleArn()));
            }
            case "instanceLaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.instanceLaunchTemplate()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTagsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("infrastructureRoleArn", INFRASTRUCTURE_ROLE_ARN_FIELD);
        map.put("instanceLaunchTemplate", INSTANCE_LAUNCH_TEMPLATE_FIELD);
        map.put("propagateTags", PROPAGATE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateManagedInstancesProviderConfiguration, T> g) {
        return obj -> g.apply((CreateManagedInstancesProviderConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String infrastructureRoleArn;
        private InstanceLaunchTemplate instanceLaunchTemplate;
        private String propagateTags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateManagedInstancesProviderConfiguration model) {
            this.infrastructureRoleArn(model.infrastructureRoleArn);
            this.instanceLaunchTemplate(model.instanceLaunchTemplate);
            this.propagateTags(model.propagateTags);
        }

        public final String getInfrastructureRoleArn() {
            return this.infrastructureRoleArn;
        }

        public final void setInfrastructureRoleArn(String infrastructureRoleArn) {
            this.infrastructureRoleArn = infrastructureRoleArn;
        }

        @Override
        public final Builder infrastructureRoleArn(String infrastructureRoleArn) {
            this.infrastructureRoleArn = infrastructureRoleArn;
            return this;
        }

        public final InstanceLaunchTemplate.Builder getInstanceLaunchTemplate() {
            return this.instanceLaunchTemplate != null ? this.instanceLaunchTemplate.toBuilder() : null;
        }

        public final void setInstanceLaunchTemplate(InstanceLaunchTemplate.BuilderImpl instanceLaunchTemplate) {
            this.instanceLaunchTemplate = instanceLaunchTemplate != null ? instanceLaunchTemplate.build() : null;
        }

        @Override
        public final Builder instanceLaunchTemplate(InstanceLaunchTemplate instanceLaunchTemplate) {
            this.instanceLaunchTemplate = instanceLaunchTemplate;
            return this;
        }

        public final String getPropagateTags() {
            return this.propagateTags;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateMITags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public CreateManagedInstancesProviderConfiguration build() {
            return new CreateManagedInstancesProviderConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateManagedInstancesProviderConfiguration> {
        public Builder infrastructureRoleArn(String var1);

        public Builder instanceLaunchTemplate(InstanceLaunchTemplate var1);

        default public Builder instanceLaunchTemplate(Consumer<InstanceLaunchTemplate.Builder> instanceLaunchTemplate) {
            return this.instanceLaunchTemplate((InstanceLaunchTemplate)((InstanceLaunchTemplate.Builder)InstanceLaunchTemplate.builder().applyMutation(instanceLaunchTemplate)).build());
        }

        public Builder propagateTags(String var1);

        public Builder propagateTags(PropagateMITags var1);
    }
}

