/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CpuManufacturer {
    INTEL("intel"),
    AMD("amd"),
    AMAZON_WEB_SERVICES("amazon-web-services"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CpuManufacturer> VALUE_MAP;
    private final String value;

    private CpuManufacturer(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CpuManufacturer fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CpuManufacturer> knownValues() {
        EnumSet<CpuManufacturer> knownValues = EnumSet.allOf(CpuManufacturer.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CpuManufacturer.class, CpuManufacturer::toString);
    }
}

