/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.EcsServiceClientConfiguration;
import software.amazon.awssdk.services.ecs.internal.EcsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ecs.model.AccessDeniedException;
import software.amazon.awssdk.services.ecs.model.AttributeLimitExceededException;
import software.amazon.awssdk.services.ecs.model.BlockedException;
import software.amazon.awssdk.services.ecs.model.ClientException;
import software.amazon.awssdk.services.ecs.model.ClusterContainsCapacityProviderException;
import software.amazon.awssdk.services.ecs.model.ClusterContainsContainerInstancesException;
import software.amazon.awssdk.services.ecs.model.ClusterContainsServicesException;
import software.amazon.awssdk.services.ecs.model.ClusterContainsTasksException;
import software.amazon.awssdk.services.ecs.model.ClusterNotFoundException;
import software.amazon.awssdk.services.ecs.model.ConflictException;
import software.amazon.awssdk.services.ecs.model.CreateCapacityProviderRequest;
import software.amazon.awssdk.services.ecs.model.CreateCapacityProviderResponse;
import software.amazon.awssdk.services.ecs.model.CreateClusterRequest;
import software.amazon.awssdk.services.ecs.model.CreateClusterResponse;
import software.amazon.awssdk.services.ecs.model.CreateServiceRequest;
import software.amazon.awssdk.services.ecs.model.CreateServiceResponse;
import software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.CreateTaskSetResponse;
import software.amazon.awssdk.services.ecs.model.DeleteAccountSettingRequest;
import software.amazon.awssdk.services.ecs.model.DeleteAccountSettingResponse;
import software.amazon.awssdk.services.ecs.model.DeleteAttributesRequest;
import software.amazon.awssdk.services.ecs.model.DeleteAttributesResponse;
import software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderRequest;
import software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderResponse;
import software.amazon.awssdk.services.ecs.model.DeleteClusterRequest;
import software.amazon.awssdk.services.ecs.model.DeleteClusterResponse;
import software.amazon.awssdk.services.ecs.model.DeleteServiceRequest;
import software.amazon.awssdk.services.ecs.model.DeleteServiceResponse;
import software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsRequest;
import software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsResponse;
import software.amazon.awssdk.services.ecs.model.DeleteTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.DeleteTaskSetResponse;
import software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceRequest;
import software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceResponse;
import software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionRequest;
import software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionResponse;
import software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersRequest;
import software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse;
import software.amazon.awssdk.services.ecs.model.DescribeClustersRequest;
import software.amazon.awssdk.services.ecs.model.DescribeClustersResponse;
import software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesRequest;
import software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesResponse;
import software.amazon.awssdk.services.ecs.model.DescribeServiceDeploymentsRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServiceDeploymentsResponse;
import software.amazon.awssdk.services.ecs.model.DescribeServiceRevisionsRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServiceRevisionsResponse;
import software.amazon.awssdk.services.ecs.model.DescribeServicesRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServicesResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTaskSetsRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTaskSetsResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTasksRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTasksResponse;
import software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointRequest;
import software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointResponse;
import software.amazon.awssdk.services.ecs.model.EcsException;
import software.amazon.awssdk.services.ecs.model.ExecuteCommandRequest;
import software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse;
import software.amazon.awssdk.services.ecs.model.GetTaskProtectionRequest;
import software.amazon.awssdk.services.ecs.model.GetTaskProtectionResponse;
import software.amazon.awssdk.services.ecs.model.InvalidParameterException;
import software.amazon.awssdk.services.ecs.model.LimitExceededException;
import software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest;
import software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse;
import software.amazon.awssdk.services.ecs.model.ListAttributesRequest;
import software.amazon.awssdk.services.ecs.model.ListAttributesResponse;
import software.amazon.awssdk.services.ecs.model.ListClustersRequest;
import software.amazon.awssdk.services.ecs.model.ListClustersResponse;
import software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest;
import software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse;
import software.amazon.awssdk.services.ecs.model.ListServiceDeploymentsRequest;
import software.amazon.awssdk.services.ecs.model.ListServiceDeploymentsResponse;
import software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceRequest;
import software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse;
import software.amazon.awssdk.services.ecs.model.ListServicesRequest;
import software.amazon.awssdk.services.ecs.model.ListServicesResponse;
import software.amazon.awssdk.services.ecs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ecs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse;
import software.amazon.awssdk.services.ecs.model.ListTasksRequest;
import software.amazon.awssdk.services.ecs.model.ListTasksResponse;
import software.amazon.awssdk.services.ecs.model.MissingVersionException;
import software.amazon.awssdk.services.ecs.model.NamespaceNotFoundException;
import software.amazon.awssdk.services.ecs.model.NoUpdateAvailableException;
import software.amazon.awssdk.services.ecs.model.PlatformTaskDefinitionIncompatibilityException;
import software.amazon.awssdk.services.ecs.model.PlatformUnknownException;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultRequest;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultResponse;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingRequest;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingResponse;
import software.amazon.awssdk.services.ecs.model.PutAttributesRequest;
import software.amazon.awssdk.services.ecs.model.PutAttributesResponse;
import software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersRequest;
import software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersResponse;
import software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceRequest;
import software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceResponse;
import software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionRequest;
import software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionResponse;
import software.amazon.awssdk.services.ecs.model.ResourceInUseException;
import software.amazon.awssdk.services.ecs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ecs.model.RunTaskRequest;
import software.amazon.awssdk.services.ecs.model.RunTaskResponse;
import software.amazon.awssdk.services.ecs.model.ServerException;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentNotFoundException;
import software.amazon.awssdk.services.ecs.model.ServiceNotActiveException;
import software.amazon.awssdk.services.ecs.model.ServiceNotFoundException;
import software.amazon.awssdk.services.ecs.model.StartTaskRequest;
import software.amazon.awssdk.services.ecs.model.StartTaskResponse;
import software.amazon.awssdk.services.ecs.model.StopServiceDeploymentRequest;
import software.amazon.awssdk.services.ecs.model.StopServiceDeploymentResponse;
import software.amazon.awssdk.services.ecs.model.StopTaskRequest;
import software.amazon.awssdk.services.ecs.model.StopTaskResponse;
import software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesRequest;
import software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesResponse;
import software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest;
import software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeResponse;
import software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest;
import software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeResponse;
import software.amazon.awssdk.services.ecs.model.TagResourceRequest;
import software.amazon.awssdk.services.ecs.model.TagResourceResponse;
import software.amazon.awssdk.services.ecs.model.TargetNotConnectedException;
import software.amazon.awssdk.services.ecs.model.TargetNotFoundException;
import software.amazon.awssdk.services.ecs.model.TaskSetNotFoundException;
import software.amazon.awssdk.services.ecs.model.UnsupportedFeatureException;
import software.amazon.awssdk.services.ecs.model.UntagResourceRequest;
import software.amazon.awssdk.services.ecs.model.UntagResourceResponse;
import software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderRequest;
import software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderResponse;
import software.amazon.awssdk.services.ecs.model.UpdateClusterRequest;
import software.amazon.awssdk.services.ecs.model.UpdateClusterResponse;
import software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsRequest;
import software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsResponse;
import software.amazon.awssdk.services.ecs.model.UpdateContainerAgentRequest;
import software.amazon.awssdk.services.ecs.model.UpdateContainerAgentResponse;
import software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateRequest;
import software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateResponse;
import software.amazon.awssdk.services.ecs.model.UpdateInProgressException;
import software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetResponse;
import software.amazon.awssdk.services.ecs.model.UpdateServiceRequest;
import software.amazon.awssdk.services.ecs.model.UpdateServiceResponse;
import software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionRequest;
import software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionResponse;
import software.amazon.awssdk.services.ecs.model.UpdateTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.UpdateTaskSetResponse;
import software.amazon.awssdk.services.ecs.transform.CreateCapacityProviderRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.CreateServiceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.CreateTaskSetRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteAccountSettingRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteAttributesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteCapacityProviderRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteServiceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteTaskDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteTaskSetRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeregisterContainerInstanceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeregisterTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeCapacityProvidersRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeContainerInstancesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeServiceDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeServiceRevisionsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeServicesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeTaskSetsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeTasksRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DiscoverPollEndpointRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ExecuteCommandRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.GetTaskProtectionRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListAttributesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListContainerInstancesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListServiceDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListServicesByNamespaceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListServicesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListTaskDefinitionFamiliesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListTaskDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListTasksRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.PutAccountSettingDefaultRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.PutAccountSettingRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.PutAttributesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.PutClusterCapacityProvidersRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.RegisterContainerInstanceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.RegisterTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.RunTaskRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.StartTaskRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.StopServiceDeploymentRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.StopTaskRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.SubmitAttachmentStateChangesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.SubmitContainerStateChangeRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.SubmitTaskStateChangeRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateCapacityProviderRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateClusterSettingsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateContainerAgentRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateContainerInstancesStateRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateServicePrimaryTaskSetRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateServiceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateTaskProtectionRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateTaskSetRequestMarshaller;
import software.amazon.awssdk.services.ecs.waiters.EcsWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultEcsClient
implements EcsClient {
    private static final Logger log = Logger.loggerFor(DefaultEcsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEcsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"ECS#2.36.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCapacityProviderResponse createCapacityProvider(CreateCapacityProviderRequest createCapacityProviderRequest) throws ServerException, ClientException, InvalidParameterException, LimitExceededException, UpdateInProgressException, UnsupportedFeatureException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCapacityProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCapacityProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, createCapacityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCapacityProvider");
            CreateCapacityProviderResponse createCapacityProviderResponse = (CreateCapacityProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCapacityProvider").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCapacityProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCapacityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCapacityProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$createCapacityProvider$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ServerException, ClientException, InvalidParameterException, NamespaceNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            CreateClusterResponse createClusterResponse = (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$createCluster$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServiceResponse createService(CreateServiceRequest createServiceRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, UnsupportedFeatureException, PlatformUnknownException, PlatformTaskDefinitionIncompatibilityException, AccessDeniedException, NamespaceNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, createServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateService");
            CreateServiceResponse createServiceResponse = (CreateServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$createService$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTaskSetResponse createTaskSet(CreateTaskSetRequest createTaskSetRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, UnsupportedFeatureException, PlatformUnknownException, PlatformTaskDefinitionIncompatibilityException, AccessDeniedException, ServiceNotFoundException, ServiceNotActiveException, NamespaceNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTaskSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTaskSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, createTaskSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTaskSet");
            CreateTaskSetResponse createTaskSetResponse = (CreateTaskSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTaskSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTaskSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTaskSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTaskSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$createTaskSet$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccountSettingResponse deleteAccountSetting(DeleteAccountSettingRequest deleteAccountSettingRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccountSettingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAccountSettingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, deleteAccountSettingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccountSetting");
            DeleteAccountSettingResponse deleteAccountSettingResponse = (DeleteAccountSettingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccountSetting").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAccountSettingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAccountSettingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAccountSettingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$deleteAccountSetting$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAttributesResponse deleteAttributes(DeleteAttributesRequest deleteAttributesRequest) throws ClusterNotFoundException, TargetNotFoundException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, deleteAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAttributes");
            DeleteAttributesResponse deleteAttributesResponse = (DeleteAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$deleteAttributes$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCapacityProviderResponse deleteCapacityProvider(DeleteCapacityProviderRequest deleteCapacityProviderRequest) throws ServerException, ClientException, InvalidParameterException, UnsupportedFeatureException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCapacityProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCapacityProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, deleteCapacityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCapacityProvider");
            DeleteCapacityProviderResponse deleteCapacityProviderResponse = (DeleteCapacityProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCapacityProvider").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCapacityProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCapacityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCapacityProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$deleteCapacityProvider$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, ClusterContainsCapacityProviderException, ClusterContainsContainerInstancesException, ClusterContainsServicesException, ClusterContainsTasksException, UpdateInProgressException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            DeleteClusterResponse deleteClusterResponse = (DeleteClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$deleteCluster$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceResponse deleteService(DeleteServiceRequest deleteServiceRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, ServiceNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, deleteServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteService");
            DeleteServiceResponse deleteServiceResponse = (DeleteServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$deleteService$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTaskDefinitionsResponse deleteTaskDefinitions(DeleteTaskDefinitionsRequest deleteTaskDefinitionsRequest) throws AccessDeniedException, ClientException, InvalidParameterException, ServerException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTaskDefinitionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTaskDefinitionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, deleteTaskDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTaskDefinitions");
            DeleteTaskDefinitionsResponse deleteTaskDefinitionsResponse = (DeleteTaskDefinitionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTaskDefinitions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTaskDefinitionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTaskDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTaskDefinitionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$deleteTaskDefinitions$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTaskSetResponse deleteTaskSet(DeleteTaskSetRequest deleteTaskSetRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, UnsupportedFeatureException, AccessDeniedException, ServiceNotFoundException, ServiceNotActiveException, TaskSetNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTaskSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTaskSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, deleteTaskSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTaskSet");
            DeleteTaskSetResponse deleteTaskSetResponse = (DeleteTaskSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTaskSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTaskSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTaskSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTaskSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$deleteTaskSet$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterContainerInstanceResponse deregisterContainerInstance(DeregisterContainerInstanceRequest deregisterContainerInstanceRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterContainerInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterContainerInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, deregisterContainerInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterContainerInstance");
            DeregisterContainerInstanceResponse deregisterContainerInstanceResponse = (DeregisterContainerInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterContainerInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterContainerInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterContainerInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterContainerInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$deregisterContainerInstance$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterTaskDefinitionResponse deregisterTaskDefinition(DeregisterTaskDefinitionRequest deregisterTaskDefinitionRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterTaskDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterTaskDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, deregisterTaskDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterTaskDefinition");
            DeregisterTaskDefinitionResponse deregisterTaskDefinitionResponse = (DeregisterTaskDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterTaskDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterTaskDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterTaskDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterTaskDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$deregisterTaskDefinition$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCapacityProvidersResponse describeCapacityProviders(DescribeCapacityProvidersRequest describeCapacityProvidersRequest) throws ServerException, ClientException, InvalidParameterException, UnsupportedFeatureException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCapacityProvidersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCapacityProvidersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, describeCapacityProvidersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCapacityProviders");
            DescribeCapacityProvidersResponse describeCapacityProvidersResponse = (DescribeCapacityProvidersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCapacityProviders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCapacityProvidersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCapacityProvidersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCapacityProvidersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$describeCapacityProviders$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClustersResponse describeClusters(DescribeClustersRequest describeClustersRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClustersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, describeClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusters");
            DescribeClustersResponse describeClustersResponse = (DescribeClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$describeClusters$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeContainerInstancesResponse describeContainerInstances(DescribeContainerInstancesRequest describeContainerInstancesRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContainerInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeContainerInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, describeContainerInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContainerInstances");
            DescribeContainerInstancesResponse describeContainerInstancesResponse = (DescribeContainerInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContainerInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeContainerInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeContainerInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeContainerInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$describeContainerInstances$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServiceDeploymentsResponse describeServiceDeployments(DescribeServiceDeploymentsRequest describeServiceDeploymentsRequest) throws AccessDeniedException, ClientException, ClusterNotFoundException, InvalidParameterException, ServerException, ServiceNotFoundException, UnsupportedFeatureException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServiceDeploymentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServiceDeploymentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, describeServiceDeploymentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServiceDeployments");
            DescribeServiceDeploymentsResponse describeServiceDeploymentsResponse = (DescribeServiceDeploymentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceDeployments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeServiceDeploymentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServiceDeploymentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeServiceDeploymentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$describeServiceDeployments$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServiceRevisionsResponse describeServiceRevisions(DescribeServiceRevisionsRequest describeServiceRevisionsRequest) throws AccessDeniedException, ClientException, ClusterNotFoundException, InvalidParameterException, ServerException, ServiceNotFoundException, UnsupportedFeatureException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServiceRevisionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServiceRevisionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, describeServiceRevisionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServiceRevisions");
            DescribeServiceRevisionsResponse describeServiceRevisionsResponse = (DescribeServiceRevisionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceRevisions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeServiceRevisionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServiceRevisionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeServiceRevisionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$describeServiceRevisions$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServicesResponse describeServices(DescribeServicesRequest describeServicesRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, describeServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServices");
            DescribeServicesResponse describeServicesResponse = (DescribeServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$describeServices$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTaskDefinitionResponse describeTaskDefinition(DescribeTaskDefinitionRequest describeTaskDefinitionRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTaskDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTaskDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, describeTaskDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTaskDefinition");
            DescribeTaskDefinitionResponse describeTaskDefinitionResponse = (DescribeTaskDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTaskDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTaskDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTaskDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTaskDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$describeTaskDefinition$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTaskSetsResponse describeTaskSets(DescribeTaskSetsRequest describeTaskSetsRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, UnsupportedFeatureException, AccessDeniedException, ServiceNotFoundException, ServiceNotActiveException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTaskSetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTaskSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, describeTaskSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTaskSets");
            DescribeTaskSetsResponse describeTaskSetsResponse = (DescribeTaskSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTaskSets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTaskSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTaskSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTaskSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$describeTaskSets$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTasksResponse describeTasks(DescribeTasksRequest describeTasksRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, describeTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTasks");
            DescribeTasksResponse describeTasksResponse = (DescribeTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$describeTasks$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoverPollEndpointResponse discoverPollEndpoint(DiscoverPollEndpointRequest discoverPollEndpointRequest) throws ServerException, ClientException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DiscoverPollEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)discoverPollEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, discoverPollEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DiscoverPollEndpoint");
            DiscoverPollEndpointResponse discoverPollEndpointResponse = (DiscoverPollEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DiscoverPollEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)discoverPollEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DiscoverPollEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return discoverPollEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$discoverPollEndpoint$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteCommandResponse executeCommand(ExecuteCommandRequest executeCommandRequest) throws ServerException, ClientException, InvalidParameterException, AccessDeniedException, ClusterNotFoundException, TargetNotConnectedException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteCommandResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)executeCommandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, executeCommandRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteCommand");
            ExecuteCommandResponse executeCommandResponse = (ExecuteCommandResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteCommand").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)executeCommandRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteCommandRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeCommandResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$executeCommand$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTaskProtectionResponse getTaskProtection(GetTaskProtectionRequest getTaskProtectionRequest) throws AccessDeniedException, ClientException, ClusterNotFoundException, InvalidParameterException, ResourceNotFoundException, ServerException, UnsupportedFeatureException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTaskProtectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTaskProtectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, getTaskProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTaskProtection");
            GetTaskProtectionResponse getTaskProtectionResponse = (GetTaskProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTaskProtection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTaskProtectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTaskProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTaskProtectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$getTaskProtection$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccountSettingsResponse listAccountSettings(ListAccountSettingsRequest listAccountSettingsRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAccountSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, listAccountSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccountSettings");
            ListAccountSettingsResponse listAccountSettingsResponse = (ListAccountSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAccountSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAccountSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$listAccountSettings$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAttributesResponse listAttributes(ListAttributesRequest listAttributesRequest) throws ClusterNotFoundException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, listAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAttributes");
            ListAttributesResponse listAttributesResponse = (ListAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$listAttributes$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClustersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, listClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusters");
            ListClustersResponse listClustersResponse = (ListClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$listClusters$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListContainerInstancesResponse listContainerInstances(ListContainerInstancesRequest listContainerInstancesRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListContainerInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listContainerInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, listContainerInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListContainerInstances");
            ListContainerInstancesResponse listContainerInstancesResponse = (ListContainerInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContainerInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listContainerInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListContainerInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listContainerInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$listContainerInstances$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceDeploymentsResponse listServiceDeployments(ListServiceDeploymentsRequest listServiceDeploymentsRequest) throws AccessDeniedException, ClientException, InvalidParameterException, ServerException, ServiceNotFoundException, UnsupportedFeatureException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceDeploymentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServiceDeploymentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, listServiceDeploymentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceDeployments");
            ListServiceDeploymentsResponse listServiceDeploymentsResponse = (ListServiceDeploymentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceDeployments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServiceDeploymentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceDeploymentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceDeploymentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$listServiceDeployments$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, listServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServices");
            ListServicesResponse listServicesResponse = (ListServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$listServices$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicesByNamespaceResponse listServicesByNamespace(ListServicesByNamespaceRequest listServicesByNamespaceRequest) throws ServerException, ClientException, InvalidParameterException, NamespaceNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesByNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServicesByNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, listServicesByNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServicesByNamespace");
            ListServicesByNamespaceResponse listServicesByNamespaceResponse = (ListServicesByNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServicesByNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServicesByNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServicesByNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServicesByNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$listServicesByNamespace$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ServerException, ClientException, ClusterNotFoundException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$listTagsForResource$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTaskDefinitionFamiliesResponse listTaskDefinitionFamilies(ListTaskDefinitionFamiliesRequest listTaskDefinitionFamiliesRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTaskDefinitionFamiliesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTaskDefinitionFamiliesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, listTaskDefinitionFamiliesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTaskDefinitionFamilies");
            ListTaskDefinitionFamiliesResponse listTaskDefinitionFamiliesResponse = (ListTaskDefinitionFamiliesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTaskDefinitionFamilies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTaskDefinitionFamiliesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTaskDefinitionFamiliesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTaskDefinitionFamiliesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$listTaskDefinitionFamilies$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTaskDefinitionsResponse listTaskDefinitions(ListTaskDefinitionsRequest listTaskDefinitionsRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTaskDefinitionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTaskDefinitionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, listTaskDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTaskDefinitions");
            ListTaskDefinitionsResponse listTaskDefinitionsResponse = (ListTaskDefinitionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTaskDefinitions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTaskDefinitionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTaskDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTaskDefinitionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$listTaskDefinitions$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTasksResponse listTasks(ListTasksRequest listTasksRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, ServiceNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, listTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTasks");
            ListTasksResponse listTasksResponse = (ListTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$listTasks$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountSettingResponse putAccountSetting(PutAccountSettingRequest putAccountSettingRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountSettingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountSettingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, putAccountSettingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountSetting");
            PutAccountSettingResponse putAccountSettingResponse = (PutAccountSettingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountSetting").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAccountSettingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountSettingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountSettingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$putAccountSetting$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountSettingDefaultResponse putAccountSettingDefault(PutAccountSettingDefaultRequest putAccountSettingDefaultRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountSettingDefaultResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountSettingDefaultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, putAccountSettingDefaultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountSettingDefault");
            PutAccountSettingDefaultResponse putAccountSettingDefaultResponse = (PutAccountSettingDefaultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountSettingDefault").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAccountSettingDefaultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountSettingDefaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountSettingDefaultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$putAccountSettingDefault$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAttributesResponse putAttributes(PutAttributesRequest putAttributesRequest) throws ClusterNotFoundException, TargetNotFoundException, AttributeLimitExceededException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, putAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAttributes");
            PutAttributesResponse putAttributesResponse = (PutAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$putAttributes$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutClusterCapacityProvidersResponse putClusterCapacityProviders(PutClusterCapacityProvidersRequest putClusterCapacityProvidersRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, ResourceInUseException, UpdateInProgressException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutClusterCapacityProvidersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putClusterCapacityProvidersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, putClusterCapacityProvidersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutClusterCapacityProviders");
            PutClusterCapacityProvidersResponse putClusterCapacityProvidersResponse = (PutClusterCapacityProvidersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutClusterCapacityProviders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putClusterCapacityProvidersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutClusterCapacityProvidersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putClusterCapacityProvidersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$putClusterCapacityProviders$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterContainerInstanceResponse registerContainerInstance(RegisterContainerInstanceRequest registerContainerInstanceRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterContainerInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerContainerInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, registerContainerInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterContainerInstance");
            RegisterContainerInstanceResponse registerContainerInstanceResponse = (RegisterContainerInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterContainerInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerContainerInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterContainerInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerContainerInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$registerContainerInstance$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterTaskDefinitionResponse registerTaskDefinition(RegisterTaskDefinitionRequest registerTaskDefinitionRequest) throws ServerException, ClientException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterTaskDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerTaskDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, registerTaskDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterTaskDefinition");
            RegisterTaskDefinitionResponse registerTaskDefinitionResponse = (RegisterTaskDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterTaskDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerTaskDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterTaskDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerTaskDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$registerTaskDefinition$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunTaskResponse runTask(RunTaskRequest runTaskRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, UnsupportedFeatureException, PlatformUnknownException, PlatformTaskDefinitionIncompatibilityException, AccessDeniedException, BlockedException, ConflictException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RunTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)runTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, runTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RunTask");
            RunTaskResponse runTaskResponse = (RunTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RunTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)runTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RunTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return runTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$runTask$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTaskResponse startTask(StartTaskRequest startTaskRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, UnsupportedFeatureException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, startTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTask");
            StartTaskResponse startTaskResponse = (StartTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$startTask$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopServiceDeploymentResponse stopServiceDeployment(StopServiceDeploymentRequest stopServiceDeploymentRequest) throws AccessDeniedException, ClientException, ConflictException, InvalidParameterException, ServerException, ServiceDeploymentNotFoundException, UnsupportedFeatureException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopServiceDeploymentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopServiceDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, stopServiceDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopServiceDeployment");
            StopServiceDeploymentResponse stopServiceDeploymentResponse = (StopServiceDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopServiceDeployment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopServiceDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopServiceDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopServiceDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$stopServiceDeployment$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopTaskResponse stopTask(StopTaskRequest stopTaskRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, stopTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTask");
            StopTaskResponse stopTaskResponse = (StopTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$stopTask$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmitAttachmentStateChangesResponse submitAttachmentStateChanges(SubmitAttachmentStateChangesRequest submitAttachmentStateChangesRequest) throws ServerException, ClientException, AccessDeniedException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubmitAttachmentStateChangesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)submitAttachmentStateChangesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, submitAttachmentStateChangesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubmitAttachmentStateChanges");
            SubmitAttachmentStateChangesResponse submitAttachmentStateChangesResponse = (SubmitAttachmentStateChangesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubmitAttachmentStateChanges").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)submitAttachmentStateChangesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SubmitAttachmentStateChangesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return submitAttachmentStateChangesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$submitAttachmentStateChanges$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmitContainerStateChangeResponse submitContainerStateChange(SubmitContainerStateChangeRequest submitContainerStateChangeRequest) throws ServerException, ClientException, AccessDeniedException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubmitContainerStateChangeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)submitContainerStateChangeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, submitContainerStateChangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubmitContainerStateChange");
            SubmitContainerStateChangeResponse submitContainerStateChangeResponse = (SubmitContainerStateChangeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubmitContainerStateChange").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)submitContainerStateChangeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SubmitContainerStateChangeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return submitContainerStateChangeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$submitContainerStateChange$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmitTaskStateChangeResponse submitTaskStateChange(SubmitTaskStateChangeRequest submitTaskStateChangeRequest) throws ServerException, ClientException, AccessDeniedException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubmitTaskStateChangeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)submitTaskStateChangeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, submitTaskStateChangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubmitTaskStateChange");
            SubmitTaskStateChangeResponse submitTaskStateChangeResponse = (SubmitTaskStateChangeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubmitTaskStateChange").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)submitTaskStateChangeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SubmitTaskStateChangeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return submitTaskStateChangeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$submitTaskStateChange$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServerException, ClientException, ClusterNotFoundException, ResourceNotFoundException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$tagResource$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServerException, ClientException, ClusterNotFoundException, ResourceNotFoundException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$untagResource$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCapacityProviderResponse updateCapacityProvider(UpdateCapacityProviderRequest updateCapacityProviderRequest) throws ServerException, ClientException, InvalidParameterException, UnsupportedFeatureException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCapacityProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCapacityProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, updateCapacityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCapacityProvider");
            UpdateCapacityProviderResponse updateCapacityProviderResponse = (UpdateCapacityProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCapacityProvider").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateCapacityProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCapacityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCapacityProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$updateCapacityProvider$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws ServerException, ClientException, ClusterNotFoundException, InvalidParameterException, NamespaceNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, updateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCluster");
            UpdateClusterResponse updateClusterResponse = (UpdateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$updateCluster$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateClusterSettingsResponse updateClusterSettings(UpdateClusterSettingsRequest updateClusterSettingsRequest) throws ServerException, ClientException, ClusterNotFoundException, InvalidParameterException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateClusterSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, updateClusterSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateClusterSettings");
            UpdateClusterSettingsResponse updateClusterSettingsResponse = (UpdateClusterSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateClusterSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateClusterSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateClusterSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateClusterSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$updateClusterSettings$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContainerAgentResponse updateContainerAgent(UpdateContainerAgentRequest updateContainerAgentRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, UpdateInProgressException, NoUpdateAvailableException, MissingVersionException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContainerAgentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContainerAgentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, updateContainerAgentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContainerAgent");
            UpdateContainerAgentResponse updateContainerAgentResponse = (UpdateContainerAgentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContainerAgent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateContainerAgentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateContainerAgentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateContainerAgentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$updateContainerAgent$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContainerInstancesStateResponse updateContainerInstancesState(UpdateContainerInstancesStateRequest updateContainerInstancesStateRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContainerInstancesStateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContainerInstancesStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, updateContainerInstancesStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContainerInstancesState");
            UpdateContainerInstancesStateResponse updateContainerInstancesStateResponse = (UpdateContainerInstancesStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContainerInstancesState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateContainerInstancesStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateContainerInstancesStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateContainerInstancesStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$updateContainerInstancesState$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceResponse updateService(UpdateServiceRequest updateServiceRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, ServiceNotFoundException, ServiceNotActiveException, PlatformUnknownException, PlatformTaskDefinitionIncompatibilityException, AccessDeniedException, NamespaceNotFoundException, UnsupportedFeatureException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, updateServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateService");
            UpdateServiceResponse updateServiceResponse = (UpdateServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$updateService$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServicePrimaryTaskSetResponse updateServicePrimaryTaskSet(UpdateServicePrimaryTaskSetRequest updateServicePrimaryTaskSetRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, UnsupportedFeatureException, ServiceNotFoundException, ServiceNotActiveException, TaskSetNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServicePrimaryTaskSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateServicePrimaryTaskSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, updateServicePrimaryTaskSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServicePrimaryTaskSet");
            UpdateServicePrimaryTaskSetResponse updateServicePrimaryTaskSetResponse = (UpdateServicePrimaryTaskSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServicePrimaryTaskSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateServicePrimaryTaskSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServicePrimaryTaskSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServicePrimaryTaskSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$updateServicePrimaryTaskSet$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTaskProtectionResponse updateTaskProtection(UpdateTaskProtectionRequest updateTaskProtectionRequest) throws AccessDeniedException, ClientException, ClusterNotFoundException, InvalidParameterException, ResourceNotFoundException, ServerException, UnsupportedFeatureException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTaskProtectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTaskProtectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, updateTaskProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTaskProtection");
            UpdateTaskProtectionResponse updateTaskProtectionResponse = (UpdateTaskProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTaskProtection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTaskProtectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTaskProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTaskProtectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$updateTaskProtection$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTaskSetResponse updateTaskSet(UpdateTaskSetRequest updateTaskSetRequest) throws ServerException, ClientException, InvalidParameterException, ClusterNotFoundException, UnsupportedFeatureException, AccessDeniedException, ServiceNotFoundException, ServiceNotActiveException, TaskSetNotFoundException, AwsServiceException, SdkClientException, EcsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTaskSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BlockedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                }
                case "TargetNotConnectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                }
                case "ClusterContainsServicesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                }
                case "UnsupportedFeatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "PlatformUnknownException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                }
                case "UpdateInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                }
                case "NamespaceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "ClusterContainsTasksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NoUpdateAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                }
                case "PlatformTaskDefinitionIncompatibilityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                }
                case "MissingVersionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                }
                case "ClusterContainsContainerInstancesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                }
                case "ServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "TaskSetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                }
                case "AttributeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ServiceNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "TargetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                }
                case "ServiceDeploymentNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                }
                case "ClusterContainsCapacityProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsCapacityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsCapacityProviderException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTaskSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsClient.resolveMetricPublishers(clientConfiguration, updateTaskSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTaskSet");
            UpdateTaskSetResponse updateTaskSetResponse = (UpdateTaskSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTaskSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTaskSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTaskSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTaskSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcsClient.lambda$updateTaskSet$119((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public EcsWaiter waiter() {
        return EcsWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "ecs";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        EcsServiceClientConfigurationBuilder serviceConfigBuilder = new EcsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EcsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final EcsServiceClientConfiguration serviceClientConfiguration() {
        return new EcsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTaskSet$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTaskProtection$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateServicePrimaryTaskSet$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateService$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContainerInstancesState$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContainerAgent$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateClusterSettings$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCluster$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCapacityProvider$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$submitTaskStateChange$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$submitContainerStateChange$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$submitAttachmentStateChanges$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTask$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopServiceDeployment$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTask$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$runTask$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerTaskDefinition$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerContainerInstance$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putClusterCapacityProviders$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAttributes$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountSettingDefault$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountSetting$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTasks$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTaskDefinitions$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTaskDefinitionFamilies$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServicesByNamespace$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServices$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceDeployments$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listContainerInstances$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusters$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAttributes$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccountSettings$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTaskProtection$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeCommand$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$discoverPollEndpoint$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTasks$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTaskSets$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTaskDefinition$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServices$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServiceRevisions$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServiceDeployments$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContainerInstances$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusters$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCapacityProviders$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterTaskDefinition$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterContainerInstance$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTaskSet$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTaskDefinitions$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteService$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCapacityProvider$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAttributes$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccountSetting$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTaskSet$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createService$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCapacityProvider$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

