/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Service Connect service object configuration. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the
 * <i>Amazon Elastic Container Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceConnectService implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceConnectService.Builder, ServiceConnectService> {
    private static final SdkField<String> PORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portName").getter(getter(ServiceConnectService::portName)).setter(setter(Builder::portName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portName").build()).build();

    private static final SdkField<String> DISCOVERY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("discoveryName").getter(getter(ServiceConnectService::discoveryName))
            .setter(setter(Builder::discoveryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryName").build()).build();

    private static final SdkField<List<ServiceConnectClientAlias>> CLIENT_ALIASES_FIELD = SdkField
            .<List<ServiceConnectClientAlias>> builder(MarshallingType.LIST)
            .memberName("clientAliases")
            .getter(getter(ServiceConnectService::clientAliases))
            .setter(setter(Builder::clientAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceConnectClientAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceConnectClientAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> INGRESS_PORT_OVERRIDE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ingressPortOverride").getter(getter(ServiceConnectService::ingressPortOverride))
            .setter(setter(Builder::ingressPortOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressPortOverride").build())
            .build();

    private static final SdkField<TimeoutConfiguration> TIMEOUT_FIELD = SdkField
            .<TimeoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("timeout")
            .getter(getter(ServiceConnectService::timeout)).setter(setter(Builder::timeout))
            .constructor(TimeoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()).build();

    private static final SdkField<ServiceConnectTlsConfiguration> TLS_FIELD = SdkField
            .<ServiceConnectTlsConfiguration> builder(MarshallingType.SDK_POJO).memberName("tls")
            .getter(getter(ServiceConnectService::tls)).setter(setter(Builder::tls))
            .constructor(ServiceConnectTlsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_NAME_FIELD,
            DISCOVERY_NAME_FIELD, CLIENT_ALIASES_FIELD, INGRESS_PORT_OVERRIDE_FIELD, TIMEOUT_FIELD, TLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String portName;

    private final String discoveryName;

    private final List<ServiceConnectClientAlias> clientAliases;

    private final Integer ingressPortOverride;

    private final TimeoutConfiguration timeout;

    private final ServiceConnectTlsConfiguration tls;

    private ServiceConnectService(BuilderImpl builder) {
        this.portName = builder.portName;
        this.discoveryName = builder.discoveryName;
        this.clientAliases = builder.clientAliases;
        this.ingressPortOverride = builder.ingressPortOverride;
        this.timeout = builder.timeout;
        this.tls = builder.tls;
    }

    /**
     * <p>
     * The <code>portName</code> must match the name of one of the <code>portMappings</code> from all the containers in
     * the task definition of this Amazon ECS service.
     * </p>
     * 
     * @return The <code>portName</code> must match the name of one of the <code>portMappings</code> from all the
     *         containers in the task definition of this Amazon ECS service.
     */
    public final String portName() {
        return portName;
    }

    /**
     * <p>
     * The <code>discoveryName</code> is the name of the new Cloud Map service that Amazon ECS creates for this Amazon
     * ECS service. This must be unique within the Cloud Map namespace. The name can contain up to 64 characters. The
     * name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a
     * hyphen.
     * </p>
     * <p>
     * If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used in
     * <code>portName.namespace</code>.
     * </p>
     * 
     * @return The <code>discoveryName</code> is the name of the new Cloud Map service that Amazon ECS creates for this
     *         Amazon ECS service. This must be unique within the Cloud Map namespace. The name can contain up to 64
     *         characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name
     *         can't start with a hyphen.</p>
     *         <p>
     *         If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used
     *         in <code>portName.namespace</code>.
     */
    public final String discoveryName() {
        return discoveryName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientAliases property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientAliases() {
        return clientAliases != null && !(clientAliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of client aliases for this Service Connect service. You use these to assign names that can be used by
     * client applications. The maximum number of client aliases that you can have in this list is 1.
     * </p>
     * <p>
     * Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients") can use
     * to connect to this service.
     * </p>
     * <p>
     * Each name and port mapping must be unique within the namespace.
     * </p>
     * <p>
     * For each <code>ServiceConnectService</code>, you must provide at least one <code>clientAlias</code> with one
     * <code>port</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientAliases} method.
     * </p>
     * 
     * @return The list of client aliases for this Service Connect service. You use these to assign names that can be
     *         used by client applications. The maximum number of client aliases that you can have in this list is
     *         1.</p>
     *         <p>
     *         Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients")
     *         can use to connect to this service.
     *         </p>
     *         <p>
     *         Each name and port mapping must be unique within the namespace.
     *         </p>
     *         <p>
     *         For each <code>ServiceConnectService</code>, you must provide at least one <code>clientAlias</code> with
     *         one <code>port</code>.
     */
    public final List<ServiceConnectClientAlias> clientAliases() {
        return clientAliases;
    }

    /**
     * <p>
     * The port number for the Service Connect proxy to listen on.
     * </p>
     * <p>
     * Use the value of this field to bypass the proxy for traffic on the port number specified in the named
     * <code>portMapping</code> in the task definition of this application, and then use it in your VPC security groups
     * to allow traffic into the proxy for this Amazon ECS service.
     * </p>
     * <p>
     * In <code>awsvpc</code> mode and Fargate, the default value is the container port number. The container port
     * number is in the <code>portMapping</code> in the task definition. In bridge mode, the default value is the
     * ephemeral port of the Service Connect proxy.
     * </p>
     * 
     * @return The port number for the Service Connect proxy to listen on.</p>
     *         <p>
     *         Use the value of this field to bypass the proxy for traffic on the port number specified in the named
     *         <code>portMapping</code> in the task definition of this application, and then use it in your VPC security
     *         groups to allow traffic into the proxy for this Amazon ECS service.
     *         </p>
     *         <p>
     *         In <code>awsvpc</code> mode and Fargate, the default value is the container port number. The container
     *         port number is in the <code>portMapping</code> in the task definition. In bridge mode, the default value
     *         is the ephemeral port of the Service Connect proxy.
     */
    public final Integer ingressPortOverride() {
        return ingressPortOverride;
    }

    /**
     * <p>
     * A reference to an object that represents the configured timeouts for Service Connect.
     * </p>
     * 
     * @return A reference to an object that represents the configured timeouts for Service Connect.
     */
    public final TimeoutConfiguration timeout() {
        return timeout;
    }

    /**
     * <p>
     * A reference to an object that represents a Transport Layer Security (TLS) configuration.
     * </p>
     * 
     * @return A reference to an object that represents a Transport Layer Security (TLS) configuration.
     */
    public final ServiceConnectTlsConfiguration tls() {
        return tls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(portName());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryName());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientAliases() ? clientAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ingressPortOverride());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(tls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectService)) {
            return false;
        }
        ServiceConnectService other = (ServiceConnectService) obj;
        return Objects.equals(portName(), other.portName()) && Objects.equals(discoveryName(), other.discoveryName())
                && hasClientAliases() == other.hasClientAliases() && Objects.equals(clientAliases(), other.clientAliases())
                && Objects.equals(ingressPortOverride(), other.ingressPortOverride())
                && Objects.equals(timeout(), other.timeout()) && Objects.equals(tls(), other.tls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceConnectService").add("PortName", portName()).add("DiscoveryName", discoveryName())
                .add("ClientAliases", hasClientAliases() ? clientAliases() : null)
                .add("IngressPortOverride", ingressPortOverride()).add("Timeout", timeout()).add("Tls", tls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portName":
            return Optional.ofNullable(clazz.cast(portName()));
        case "discoveryName":
            return Optional.ofNullable(clazz.cast(discoveryName()));
        case "clientAliases":
            return Optional.ofNullable(clazz.cast(clientAliases()));
        case "ingressPortOverride":
            return Optional.ofNullable(clazz.cast(ingressPortOverride()));
        case "timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "tls":
            return Optional.ofNullable(clazz.cast(tls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("portName", PORT_NAME_FIELD);
        map.put("discoveryName", DISCOVERY_NAME_FIELD);
        map.put("clientAliases", CLIENT_ALIASES_FIELD);
        map.put("ingressPortOverride", INGRESS_PORT_OVERRIDE_FIELD);
        map.put("timeout", TIMEOUT_FIELD);
        map.put("tls", TLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectService, T> g) {
        return obj -> g.apply((ServiceConnectService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceConnectService> {
        /**
         * <p>
         * The <code>portName</code> must match the name of one of the <code>portMappings</code> from all the containers
         * in the task definition of this Amazon ECS service.
         * </p>
         * 
         * @param portName
         *        The <code>portName</code> must match the name of one of the <code>portMappings</code> from all the
         *        containers in the task definition of this Amazon ECS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portName(String portName);

        /**
         * <p>
         * The <code>discoveryName</code> is the name of the new Cloud Map service that Amazon ECS creates for this
         * Amazon ECS service. This must be unique within the Cloud Map namespace. The name can contain up to 64
         * characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't
         * start with a hyphen.
         * </p>
         * <p>
         * If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used in
         * <code>portName.namespace</code>.
         * </p>
         * 
         * @param discoveryName
         *        The <code>discoveryName</code> is the name of the new Cloud Map service that Amazon ECS creates for
         *        this Amazon ECS service. This must be unique within the Cloud Map namespace. The name can contain up
         *        to 64 characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-).
         *        The name can't start with a hyphen.</p>
         *        <p>
         *        If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is
         *        used in <code>portName.namespace</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryName(String discoveryName);

        /**
         * <p>
         * The list of client aliases for this Service Connect service. You use these to assign names that can be used
         * by client applications. The maximum number of client aliases that you can have in this list is 1.
         * </p>
         * <p>
         * Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients") can
         * use to connect to this service.
         * </p>
         * <p>
         * Each name and port mapping must be unique within the namespace.
         * </p>
         * <p>
         * For each <code>ServiceConnectService</code>, you must provide at least one <code>clientAlias</code> with one
         * <code>port</code>.
         * </p>
         * 
         * @param clientAliases
         *        The list of client aliases for this Service Connect service. You use these to assign names that can be
         *        used by client applications. The maximum number of client aliases that you can have in this list is
         *        1.</p>
         *        <p>
         *        Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks
         *        ("clients") can use to connect to this service.
         *        </p>
         *        <p>
         *        Each name and port mapping must be unique within the namespace.
         *        </p>
         *        <p>
         *        For each <code>ServiceConnectService</code>, you must provide at least one <code>clientAlias</code>
         *        with one <code>port</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAliases(Collection<ServiceConnectClientAlias> clientAliases);

        /**
         * <p>
         * The list of client aliases for this Service Connect service. You use these to assign names that can be used
         * by client applications. The maximum number of client aliases that you can have in this list is 1.
         * </p>
         * <p>
         * Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients") can
         * use to connect to this service.
         * </p>
         * <p>
         * Each name and port mapping must be unique within the namespace.
         * </p>
         * <p>
         * For each <code>ServiceConnectService</code>, you must provide at least one <code>clientAlias</code> with one
         * <code>port</code>.
         * </p>
         * 
         * @param clientAliases
         *        The list of client aliases for this Service Connect service. You use these to assign names that can be
         *        used by client applications. The maximum number of client aliases that you can have in this list is
         *        1.</p>
         *        <p>
         *        Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks
         *        ("clients") can use to connect to this service.
         *        </p>
         *        <p>
         *        Each name and port mapping must be unique within the namespace.
         *        </p>
         *        <p>
         *        For each <code>ServiceConnectService</code>, you must provide at least one <code>clientAlias</code>
         *        with one <code>port</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAliases(ServiceConnectClientAlias... clientAliases);

        /**
         * <p>
         * The list of client aliases for this Service Connect service. You use these to assign names that can be used
         * by client applications. The maximum number of client aliases that you can have in this list is 1.
         * </p>
         * <p>
         * Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients") can
         * use to connect to this service.
         * </p>
         * <p>
         * Each name and port mapping must be unique within the namespace.
         * </p>
         * <p>
         * For each <code>ServiceConnectService</code>, you must provide at least one <code>clientAlias</code> with one
         * <code>port</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ServiceConnectClientAlias.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ecs.model.ServiceConnectClientAlias#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ServiceConnectClientAlias.Builder#build()} is called
         * immediately and its result is passed to {@link #clientAliases(List<ServiceConnectClientAlias>)}.
         * 
         * @param clientAliases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ServiceConnectClientAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientAliases(java.util.Collection<ServiceConnectClientAlias>)
         */
        Builder clientAliases(Consumer<ServiceConnectClientAlias.Builder>... clientAliases);

        /**
         * <p>
         * The port number for the Service Connect proxy to listen on.
         * </p>
         * <p>
         * Use the value of this field to bypass the proxy for traffic on the port number specified in the named
         * <code>portMapping</code> in the task definition of this application, and then use it in your VPC security
         * groups to allow traffic into the proxy for this Amazon ECS service.
         * </p>
         * <p>
         * In <code>awsvpc</code> mode and Fargate, the default value is the container port number. The container port
         * number is in the <code>portMapping</code> in the task definition. In bridge mode, the default value is the
         * ephemeral port of the Service Connect proxy.
         * </p>
         * 
         * @param ingressPortOverride
         *        The port number for the Service Connect proxy to listen on.</p>
         *        <p>
         *        Use the value of this field to bypass the proxy for traffic on the port number specified in the named
         *        <code>portMapping</code> in the task definition of this application, and then use it in your VPC
         *        security groups to allow traffic into the proxy for this Amazon ECS service.
         *        </p>
         *        <p>
         *        In <code>awsvpc</code> mode and Fargate, the default value is the container port number. The container
         *        port number is in the <code>portMapping</code> in the task definition. In bridge mode, the default
         *        value is the ephemeral port of the Service Connect proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPortOverride(Integer ingressPortOverride);

        /**
         * <p>
         * A reference to an object that represents the configured timeouts for Service Connect.
         * </p>
         * 
         * @param timeout
         *        A reference to an object that represents the configured timeouts for Service Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(TimeoutConfiguration timeout);

        /**
         * <p>
         * A reference to an object that represents the configured timeouts for Service Connect.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeoutConfiguration.Builder} avoiding
         * the need to create one manually via {@link TimeoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeoutConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #timeout(TimeoutConfiguration)}.
         * 
         * @param timeout
         *        a consumer that will call methods on {@link TimeoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeout(TimeoutConfiguration)
         */
        default Builder timeout(Consumer<TimeoutConfiguration.Builder> timeout) {
            return timeout(TimeoutConfiguration.builder().applyMutation(timeout).build());
        }

        /**
         * <p>
         * A reference to an object that represents a Transport Layer Security (TLS) configuration.
         * </p>
         * 
         * @param tls
         *        A reference to an object that represents a Transport Layer Security (TLS) configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tls(ServiceConnectTlsConfiguration tls);

        /**
         * <p>
         * A reference to an object that represents a Transport Layer Security (TLS) configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceConnectTlsConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServiceConnectTlsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceConnectTlsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #tls(ServiceConnectTlsConfiguration)}.
         * 
         * @param tls
         *        a consumer that will call methods on {@link ServiceConnectTlsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tls(ServiceConnectTlsConfiguration)
         */
        default Builder tls(Consumer<ServiceConnectTlsConfiguration.Builder> tls) {
            return tls(ServiceConnectTlsConfiguration.builder().applyMutation(tls).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String portName;

        private String discoveryName;

        private List<ServiceConnectClientAlias> clientAliases = DefaultSdkAutoConstructList.getInstance();

        private Integer ingressPortOverride;

        private TimeoutConfiguration timeout;

        private ServiceConnectTlsConfiguration tls;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectService model) {
            portName(model.portName);
            discoveryName(model.discoveryName);
            clientAliases(model.clientAliases);
            ingressPortOverride(model.ingressPortOverride);
            timeout(model.timeout);
            tls(model.tls);
        }

        public final String getPortName() {
            return portName;
        }

        public final void setPortName(String portName) {
            this.portName = portName;
        }

        @Override
        public final Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public final String getDiscoveryName() {
            return discoveryName;
        }

        public final void setDiscoveryName(String discoveryName) {
            this.discoveryName = discoveryName;
        }

        @Override
        public final Builder discoveryName(String discoveryName) {
            this.discoveryName = discoveryName;
            return this;
        }

        public final List<ServiceConnectClientAlias.Builder> getClientAliases() {
            List<ServiceConnectClientAlias.Builder> result = ServiceConnectClientAliasListCopier
                    .copyToBuilder(this.clientAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientAliases(Collection<ServiceConnectClientAlias.BuilderImpl> clientAliases) {
            this.clientAliases = ServiceConnectClientAliasListCopier.copyFromBuilder(clientAliases);
        }

        @Override
        public final Builder clientAliases(Collection<ServiceConnectClientAlias> clientAliases) {
            this.clientAliases = ServiceConnectClientAliasListCopier.copy(clientAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientAliases(ServiceConnectClientAlias... clientAliases) {
            clientAliases(Arrays.asList(clientAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientAliases(Consumer<ServiceConnectClientAlias.Builder>... clientAliases) {
            clientAliases(Stream.of(clientAliases).map(c -> ServiceConnectClientAlias.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIngressPortOverride() {
            return ingressPortOverride;
        }

        public final void setIngressPortOverride(Integer ingressPortOverride) {
            this.ingressPortOverride = ingressPortOverride;
        }

        @Override
        public final Builder ingressPortOverride(Integer ingressPortOverride) {
            this.ingressPortOverride = ingressPortOverride;
            return this;
        }

        public final TimeoutConfiguration.Builder getTimeout() {
            return timeout != null ? timeout.toBuilder() : null;
        }

        public final void setTimeout(TimeoutConfiguration.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public final Builder timeout(TimeoutConfiguration timeout) {
            this.timeout = timeout;
            return this;
        }

        public final ServiceConnectTlsConfiguration.Builder getTls() {
            return tls != null ? tls.toBuilder() : null;
        }

        public final void setTls(ServiceConnectTlsConfiguration.BuilderImpl tls) {
            this.tls = tls != null ? tls.build() : null;
        }

        @Override
        public final Builder tls(ServiceConnectTlsConfiguration tls) {
            this.tls = tls;
            return this;
        }

        @Override
        public ServiceConnectService build() {
            return new ServiceConnectService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
