/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.Failure;
import software.amazon.awssdk.services.ecs.model.FailuresCopier;
import software.amazon.awssdk.services.ecs.model.ServiceDeployment;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceDeploymentsResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, DescribeServiceDeploymentsResponse> {
    private static final SdkField<List<ServiceDeployment>> SERVICE_DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceDeployments").getter(DescribeServiceDeploymentsResponse.getter(DescribeServiceDeploymentsResponse::serviceDeployments)).setter(DescribeServiceDeploymentsResponse.setter(Builder::serviceDeployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDeployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(DescribeServiceDeploymentsResponse.getter(DescribeServiceDeploymentsResponse::failures)).setter(DescribeServiceDeploymentsResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Failure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_DEPLOYMENTS_FIELD, FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServiceDeploymentsResponse.memberNameToFieldInitializer();
    private final List<ServiceDeployment> serviceDeployments;
    private final List<Failure> failures;

    private DescribeServiceDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceDeployments = builder.serviceDeployments;
        this.failures = builder.failures;
    }

    public final boolean hasServiceDeployments() {
        return this.serviceDeployments != null && !(this.serviceDeployments instanceof SdkAutoConstructList);
    }

    public final List<ServiceDeployment> serviceDeployments() {
        return this.serviceDeployments;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<Failure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceDeployments() ? this.serviceDeployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceDeploymentsResponse)) {
            return false;
        }
        DescribeServiceDeploymentsResponse other = (DescribeServiceDeploymentsResponse)((Object)obj);
        return this.hasServiceDeployments() == other.hasServiceDeployments() && Objects.equals(this.serviceDeployments(), other.serviceDeployments()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceDeploymentsResponse").add("ServiceDeployments", this.hasServiceDeployments() ? this.serviceDeployments() : null).add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceDeployments": {
                return Optional.ofNullable(clazz.cast(this.serviceDeployments()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceDeployments", SERVICE_DEPLOYMENTS_FIELD);
        map.put("failures", FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceDeploymentsResponse, T> g) {
        return obj -> g.apply((DescribeServiceDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<ServiceDeployment> serviceDeployments = DefaultSdkAutoConstructList.getInstance();
        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceDeploymentsResponse model) {
            super(model);
            this.serviceDeployments(model.serviceDeployments);
            this.failures(model.failures);
        }

        public final List<ServiceDeployment.Builder> getServiceDeployments() {
            List<ServiceDeployment.Builder> result = ServiceDeploymentsCopier.copyToBuilder(this.serviceDeployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceDeployments(Collection<ServiceDeployment.BuilderImpl> serviceDeployments) {
            this.serviceDeployments = ServiceDeploymentsCopier.copyFromBuilder(serviceDeployments);
        }

        @Override
        public final Builder serviceDeployments(Collection<ServiceDeployment> serviceDeployments) {
            this.serviceDeployments = ServiceDeploymentsCopier.copy(serviceDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDeployments(ServiceDeployment ... serviceDeployments) {
            this.serviceDeployments(Arrays.asList(serviceDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDeployments(Consumer<ServiceDeployment.Builder> ... serviceDeployments) {
            this.serviceDeployments(Stream.of(serviceDeployments).map(c -> (ServiceDeployment)((ServiceDeployment.Builder)ServiceDeployment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Failure.Builder> getFailures() {
            List<Failure.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (Failure)((Failure.Builder)Failure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeServiceDeploymentsResponse build() {
            return new DescribeServiceDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceDeploymentsResponse> {
        public Builder serviceDeployments(Collection<ServiceDeployment> var1);

        public Builder serviceDeployments(ServiceDeployment ... var1);

        public Builder serviceDeployments(Consumer<ServiceDeployment.Builder> ... var1);

        public Builder failures(Collection<Failure> var1);

        public Builder failures(Failure ... var1);

        public Builder failures(Consumer<Failure.Builder> ... var1);
    }
}

