/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resolved load balancer configuration for a service revision. This includes information about which target groups
 * serve traffic and which listener rules direct traffic to them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceRevisionLoadBalancer implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceRevisionLoadBalancer.Builder, ServiceRevisionLoadBalancer> {
    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetGroupArn").getter(getter(ServiceRevisionLoadBalancer::targetGroupArn))
            .setter(setter(Builder::targetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroupArn").build()).build();

    private static final SdkField<String> PRODUCTION_LISTENER_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productionListenerRule").getter(getter(ServiceRevisionLoadBalancer::productionListenerRule))
            .setter(setter(Builder::productionListenerRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productionListenerRule").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUP_ARN_FIELD,
            PRODUCTION_LISTENER_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetGroupArn;

    private final String productionListenerRule;

    private ServiceRevisionLoadBalancer(BuilderImpl builder) {
        this.targetGroupArn = builder.targetGroupArn;
        this.productionListenerRule = builder.productionListenerRule;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target group associated with the service revision.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target group associated with the service revision.
     */
    public final String targetGroupArn() {
        return targetGroupArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the production listener rule or listener that directs traffic to the target
     * group associated with the service revision.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the production listener rule or listener that directs traffic to the
     *         target group associated with the service revision.
     */
    public final String productionListenerRule() {
        return productionListenerRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(productionListenerRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceRevisionLoadBalancer)) {
            return false;
        }
        ServiceRevisionLoadBalancer other = (ServiceRevisionLoadBalancer) obj;
        return Objects.equals(targetGroupArn(), other.targetGroupArn())
                && Objects.equals(productionListenerRule(), other.productionListenerRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceRevisionLoadBalancer").add("TargetGroupArn", targetGroupArn())
                .add("ProductionListenerRule", productionListenerRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetGroupArn":
            return Optional.ofNullable(clazz.cast(targetGroupArn()));
        case "productionListenerRule":
            return Optional.ofNullable(clazz.cast(productionListenerRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetGroupArn", TARGET_GROUP_ARN_FIELD);
        map.put("productionListenerRule", PRODUCTION_LISTENER_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceRevisionLoadBalancer, T> g) {
        return obj -> g.apply((ServiceRevisionLoadBalancer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceRevisionLoadBalancer> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target group associated with the service revision.
         * </p>
         * 
         * @param targetGroupArn
         *        The Amazon Resource Name (ARN) of the target group associated with the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupArn(String targetGroupArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the production listener rule or listener that directs traffic to the target
         * group associated with the service revision.
         * </p>
         * 
         * @param productionListenerRule
         *        The Amazon Resource Name (ARN) of the production listener rule or listener that directs traffic to the
         *        target group associated with the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionListenerRule(String productionListenerRule);
    }

    static final class BuilderImpl implements Builder {
        private String targetGroupArn;

        private String productionListenerRule;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceRevisionLoadBalancer model) {
            targetGroupArn(model.targetGroupArn);
            productionListenerRule(model.productionListenerRule);
        }

        public final String getTargetGroupArn() {
            return targetGroupArn;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final String getProductionListenerRule() {
            return productionListenerRule;
        }

        public final void setProductionListenerRule(String productionListenerRule) {
            this.productionListenerRule = productionListenerRule;
        }

        @Override
        public final Builder productionListenerRule(String productionListenerRule) {
            this.productionListenerRule = productionListenerRule;
            return this;
        }

        @Override
        public ServiceRevisionLoadBalancer build() {
            return new ServiceRevisionLoadBalancer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
