/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServiceDeploymentsResponse extends EcsResponse implements
        ToCopyableBuilder<DescribeServiceDeploymentsResponse.Builder, DescribeServiceDeploymentsResponse> {
    private static final SdkField<List<ServiceDeployment>> SERVICE_DEPLOYMENTS_FIELD = SdkField
            .<List<ServiceDeployment>> builder(MarshallingType.LIST)
            .memberName("serviceDeployments")
            .getter(getter(DescribeServiceDeploymentsResponse::serviceDeployments))
            .setter(setter(Builder::serviceDeployments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDeployments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceDeployment> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceDeployment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField
            .<List<Failure>> builder(MarshallingType.LIST)
            .memberName("failures")
            .getter(getter(DescribeServiceDeploymentsResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Failure> builder(MarshallingType.SDK_POJO)
                                            .constructor(Failure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_DEPLOYMENTS_FIELD,
            FAILURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ServiceDeployment> serviceDeployments;

    private final List<Failure> failures;

    private DescribeServiceDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceDeployments = builder.serviceDeployments;
        this.failures = builder.failures;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceDeployments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceDeployments() {
        return serviceDeployments != null && !(serviceDeployments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of service deployments described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceDeployments} method.
     * </p>
     * 
     * @return The list of service deployments described.
     */
    public final List<ServiceDeployment> serviceDeployments() {
        return serviceDeployments;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any failures associated with the call.
     * </p>
     * <p>
     * If you decsribe a deployment with a service revision created before October 25, 2024, the call fails. The failure
     * includes the service revision ARN and the reason set to <code>MISSING</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailures} method.
     * </p>
     * 
     * @return Any failures associated with the call.</p>
     *         <p>
     *         If you decsribe a deployment with a service revision created before October 25, 2024, the call fails. The
     *         failure includes the service revision ARN and the reason set to <code>MISSING</code>.
     */
    public final List<Failure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceDeployments() ? serviceDeployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceDeploymentsResponse)) {
            return false;
        }
        DescribeServiceDeploymentsResponse other = (DescribeServiceDeploymentsResponse) obj;
        return hasServiceDeployments() == other.hasServiceDeployments()
                && Objects.equals(serviceDeployments(), other.serviceDeployments()) && hasFailures() == other.hasFailures()
                && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeServiceDeploymentsResponse")
                .add("ServiceDeployments", hasServiceDeployments() ? serviceDeployments() : null)
                .add("Failures", hasFailures() ? failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceDeployments":
            return Optional.ofNullable(clazz.cast(serviceDeployments()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceDeployments", SERVICE_DEPLOYMENTS_FIELD);
        map.put("failures", FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceDeploymentsResponse, T> g) {
        return obj -> g.apply((DescribeServiceDeploymentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeServiceDeploymentsResponse> {
        /**
         * <p>
         * The list of service deployments described.
         * </p>
         * 
         * @param serviceDeployments
         *        The list of service deployments described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDeployments(Collection<ServiceDeployment> serviceDeployments);

        /**
         * <p>
         * The list of service deployments described.
         * </p>
         * 
         * @param serviceDeployments
         *        The list of service deployments described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDeployments(ServiceDeployment... serviceDeployments);

        /**
         * <p>
         * The list of service deployments described.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ServiceDeployment.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ServiceDeployment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ServiceDeployment.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceDeployments(List<ServiceDeployment>)}.
         * 
         * @param serviceDeployments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ServiceDeployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceDeployments(java.util.Collection<ServiceDeployment>)
         */
        Builder serviceDeployments(Consumer<ServiceDeployment.Builder>... serviceDeployments);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * <p>
         * If you decsribe a deployment with a service revision created before October 25, 2024, the call fails. The
         * failure includes the service revision ARN and the reason set to <code>MISSING</code>.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.</p>
         *        <p>
         *        If you decsribe a deployment with a service revision created before October 25, 2024, the call fails.
         *        The failure includes the service revision ARN and the reason set to <code>MISSING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<Failure> failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * <p>
         * If you decsribe a deployment with a service revision created before October 25, 2024, the call fails. The
         * failure includes the service revision ARN and the reason set to <code>MISSING</code>.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.</p>
         *        <p>
         *        If you decsribe a deployment with a service revision created before October 25, 2024, the call fails.
         *        The failure includes the service revision ARN and the reason set to <code>MISSING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Failure... failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * <p>
         * If you decsribe a deployment with a service revision created before October 25, 2024, the call fails. The
         * failure includes the service revision ARN and the reason set to <code>MISSING</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Failure.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ecs.model.Failure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.Failure.Builder#build()} is called immediately and its
         * result is passed to {@link #failures(List<Failure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecs.model.Failure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(java.util.Collection<Failure>)
         */
        Builder failures(Consumer<Failure.Builder>... failures);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private List<ServiceDeployment> serviceDeployments = DefaultSdkAutoConstructList.getInstance();

        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceDeploymentsResponse model) {
            super(model);
            serviceDeployments(model.serviceDeployments);
            failures(model.failures);
        }

        public final List<ServiceDeployment.Builder> getServiceDeployments() {
            List<ServiceDeployment.Builder> result = ServiceDeploymentsCopier.copyToBuilder(this.serviceDeployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceDeployments(Collection<ServiceDeployment.BuilderImpl> serviceDeployments) {
            this.serviceDeployments = ServiceDeploymentsCopier.copyFromBuilder(serviceDeployments);
        }

        @Override
        public final Builder serviceDeployments(Collection<ServiceDeployment> serviceDeployments) {
            this.serviceDeployments = ServiceDeploymentsCopier.copy(serviceDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDeployments(ServiceDeployment... serviceDeployments) {
            serviceDeployments(Arrays.asList(serviceDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDeployments(Consumer<ServiceDeployment.Builder>... serviceDeployments) {
            serviceDeployments(Stream.of(serviceDeployments).map(c -> ServiceDeployment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Failure.Builder> getFailures() {
            List<Failure.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> Failure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeServiceDeploymentsResponse build() {
            return new DescribeServiceDeploymentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
