/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.ContainerImage;
import software.amazon.awssdk.services.ecs.model.ContainerImagesCopier;
import software.amazon.awssdk.services.ecs.model.DeploymentEphemeralStorage;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.LoadBalancer;
import software.amazon.awssdk.services.ecs.model.LoadBalancersCopier;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.ServiceConnectConfiguration;
import software.amazon.awssdk.services.ecs.model.ServiceRegistriesCopier;
import software.amazon.awssdk.services.ecs.model.ServiceRegistry;
import software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration;
import software.amazon.awssdk.services.ecs.model.ServiceVolumeConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceRevision
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceRevision> {
    private static final SdkField<String> SERVICE_REVISION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRevisionArn").getter(ServiceRevision.getter(ServiceRevision::serviceRevisionArn)).setter(ServiceRevision.setter(Builder::serviceRevisionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRevisionArn").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceArn").getter(ServiceRevision.getter(ServiceRevision::serviceArn)).setter(ServiceRevision.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(ServiceRevision.getter(ServiceRevision::clusterArn)).setter(ServiceRevision.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskDefinition").getter(ServiceRevision.getter(ServiceRevision::taskDefinition)).setter(ServiceRevision.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityProviderStrategy").getter(ServiceRevision.getter(ServiceRevision::capacityProviderStrategy)).setter(ServiceRevision.setter(Builder::capacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchType").getter(ServiceRevision.getter(ServiceRevision::launchTypeAsString)).setter(ServiceRevision.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformVersion").getter(ServiceRevision.getter(ServiceRevision::platformVersion)).setter(ServiceRevision.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<String> PLATFORM_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformFamily").getter(ServiceRevision.getter(ServiceRevision::platformFamily)).setter(ServiceRevision.setter(Builder::platformFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformFamily").build()}).build();
    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loadBalancers").getter(ServiceRevision.getter(ServiceRevision::loadBalancers)).setter(ServiceRevision.setter(Builder::loadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceRegistries").getter(ServiceRevision.getter(ServiceRevision::serviceRegistries)).setter(ServiceRevision.setter(Builder::serviceRegistries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceRegistry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(ServiceRevision.getter(ServiceRevision::networkConfiguration)).setter(ServiceRevision.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<List<ContainerImage>> CONTAINER_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerImages").getter(ServiceRevision.getter(ServiceRevision::containerImages)).setter(ServiceRevision.setter(Builder::containerImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> GUARD_DUTY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("guardDutyEnabled").getter(ServiceRevision.getter(ServiceRevision::guardDutyEnabled)).setter(ServiceRevision.setter(Builder::guardDutyEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardDutyEnabled").build()}).build();
    private static final SdkField<ServiceConnectConfiguration> SERVICE_CONNECT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceConnectConfiguration").getter(ServiceRevision.getter(ServiceRevision::serviceConnectConfiguration)).setter(ServiceRevision.setter(Builder::serviceConnectConfiguration)).constructor(ServiceConnectConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConnectConfiguration").build()}).build();
    private static final SdkField<List<ServiceVolumeConfiguration>> VOLUME_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumeConfigurations").getter(ServiceRevision.getter(ServiceRevision::volumeConfigurations)).setter(ServiceRevision.setter(Builder::volumeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DeploymentEphemeralStorage> FARGATE_EPHEMERAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fargateEphemeralStorage").getter(ServiceRevision.getter(ServiceRevision::fargateEphemeralStorage)).setter(ServiceRevision.setter(Builder::fargateEphemeralStorage)).constructor(DeploymentEphemeralStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateEphemeralStorage").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ServiceRevision.getter(ServiceRevision::createdAt)).setter(ServiceRevision.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_REVISION_ARN_FIELD, SERVICE_ARN_FIELD, CLUSTER_ARN_FIELD, TASK_DEFINITION_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, LAUNCH_TYPE_FIELD, PLATFORM_VERSION_FIELD, PLATFORM_FAMILY_FIELD, LOAD_BALANCERS_FIELD, SERVICE_REGISTRIES_FIELD, NETWORK_CONFIGURATION_FIELD, CONTAINER_IMAGES_FIELD, GUARD_DUTY_ENABLED_FIELD, SERVICE_CONNECT_CONFIGURATION_FIELD, VOLUME_CONFIGURATIONS_FIELD, FARGATE_EPHEMERAL_STORAGE_FIELD, CREATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceRevisionArn;
    private final String serviceArn;
    private final String clusterArn;
    private final String taskDefinition;
    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;
    private final String launchType;
    private final String platformVersion;
    private final String platformFamily;
    private final List<LoadBalancer> loadBalancers;
    private final List<ServiceRegistry> serviceRegistries;
    private final NetworkConfiguration networkConfiguration;
    private final List<ContainerImage> containerImages;
    private final Boolean guardDutyEnabled;
    private final ServiceConnectConfiguration serviceConnectConfiguration;
    private final List<ServiceVolumeConfiguration> volumeConfigurations;
    private final DeploymentEphemeralStorage fargateEphemeralStorage;
    private final Instant createdAt;

    private ServiceRevision(BuilderImpl builder) {
        this.serviceRevisionArn = builder.serviceRevisionArn;
        this.serviceArn = builder.serviceArn;
        this.clusterArn = builder.clusterArn;
        this.taskDefinition = builder.taskDefinition;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.launchType = builder.launchType;
        this.platformVersion = builder.platformVersion;
        this.platformFamily = builder.platformFamily;
        this.loadBalancers = builder.loadBalancers;
        this.serviceRegistries = builder.serviceRegistries;
        this.networkConfiguration = builder.networkConfiguration;
        this.containerImages = builder.containerImages;
        this.guardDutyEnabled = builder.guardDutyEnabled;
        this.serviceConnectConfiguration = builder.serviceConnectConfiguration;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.fargateEphemeralStorage = builder.fargateEphemeralStorage;
        this.createdAt = builder.createdAt;
    }

    public final String serviceRevisionArn() {
        return this.serviceRevisionArn;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String taskDefinition() {
        return this.taskDefinition;
    }

    public final boolean hasCapacityProviderStrategy() {
        return this.capacityProviderStrategy != null && !(this.capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return this.capacityProviderStrategy;
    }

    public final LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public final String launchTypeAsString() {
        return this.launchType;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final String platformFamily() {
        return this.platformFamily;
    }

    public final boolean hasLoadBalancers() {
        return this.loadBalancers != null && !(this.loadBalancers instanceof SdkAutoConstructList);
    }

    public final List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public final boolean hasServiceRegistries() {
        return this.serviceRegistries != null && !(this.serviceRegistries instanceof SdkAutoConstructList);
    }

    public final List<ServiceRegistry> serviceRegistries() {
        return this.serviceRegistries;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final boolean hasContainerImages() {
        return this.containerImages != null && !(this.containerImages instanceof SdkAutoConstructList);
    }

    public final List<ContainerImage> containerImages() {
        return this.containerImages;
    }

    public final Boolean guardDutyEnabled() {
        return this.guardDutyEnabled;
    }

    public final ServiceConnectConfiguration serviceConnectConfiguration() {
        return this.serviceConnectConfiguration;
    }

    public final boolean hasVolumeConfigurations() {
        return this.volumeConfigurations != null && !(this.volumeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ServiceVolumeConfiguration> volumeConfigurations() {
        return this.volumeConfigurations;
    }

    public final DeploymentEphemeralStorage fargateEphemeralStorage() {
        return this.fargateEphemeralStorage;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRevisionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancers() ? this.loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceRegistries() ? this.serviceRegistries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerImages() ? this.containerImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.guardDutyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceConnectConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeConfigurations() ? this.volumeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fargateEphemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceRevision)) {
            return false;
        }
        ServiceRevision other = (ServiceRevision)obj;
        return Objects.equals(this.serviceRevisionArn(), other.serviceRevisionArn()) && Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && this.hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy() && Objects.equals(this.capacityProviderStrategy(), other.capacityProviderStrategy()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.platformFamily(), other.platformFamily()) && this.hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(this.loadBalancers(), other.loadBalancers()) && this.hasServiceRegistries() == other.hasServiceRegistries() && Objects.equals(this.serviceRegistries(), other.serviceRegistries()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && this.hasContainerImages() == other.hasContainerImages() && Objects.equals(this.containerImages(), other.containerImages()) && Objects.equals(this.guardDutyEnabled(), other.guardDutyEnabled()) && Objects.equals(this.serviceConnectConfiguration(), other.serviceConnectConfiguration()) && this.hasVolumeConfigurations() == other.hasVolumeConfigurations() && Objects.equals(this.volumeConfigurations(), other.volumeConfigurations()) && Objects.equals(this.fargateEphemeralStorage(), other.fargateEphemeralStorage()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceRevision").add("ServiceRevisionArn", (Object)this.serviceRevisionArn()).add("ServiceArn", (Object)this.serviceArn()).add("ClusterArn", (Object)this.clusterArn()).add("TaskDefinition", (Object)this.taskDefinition()).add("CapacityProviderStrategy", this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null).add("LaunchType", (Object)this.launchTypeAsString()).add("PlatformVersion", (Object)this.platformVersion()).add("PlatformFamily", (Object)this.platformFamily()).add("LoadBalancers", this.hasLoadBalancers() ? this.loadBalancers() : null).add("ServiceRegistries", this.hasServiceRegistries() ? this.serviceRegistries() : null).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("ContainerImages", this.hasContainerImages() ? this.containerImages() : null).add("GuardDutyEnabled", (Object)this.guardDutyEnabled()).add("ServiceConnectConfiguration", (Object)this.serviceConnectConfiguration()).add("VolumeConfigurations", this.hasVolumeConfigurations() ? this.volumeConfigurations() : null).add("FargateEphemeralStorage", (Object)this.fargateEphemeralStorage()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceRevisionArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRevisionArn()));
            }
            case "serviceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "capacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderStrategy()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "platformFamily": {
                return Optional.ofNullable(clazz.cast(this.platformFamily()));
            }
            case "loadBalancers": {
                return Optional.ofNullable(clazz.cast(this.loadBalancers()));
            }
            case "serviceRegistries": {
                return Optional.ofNullable(clazz.cast(this.serviceRegistries()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "containerImages": {
                return Optional.ofNullable(clazz.cast(this.containerImages()));
            }
            case "guardDutyEnabled": {
                return Optional.ofNullable(clazz.cast(this.guardDutyEnabled()));
            }
            case "serviceConnectConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serviceConnectConfiguration()));
            }
            case "volumeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.volumeConfigurations()));
            }
            case "fargateEphemeralStorage": {
                return Optional.ofNullable(clazz.cast(this.fargateEphemeralStorage()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceRevision, T> g) {
        return obj -> g.apply((ServiceRevision)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceRevisionArn;
        private String serviceArn;
        private String clusterArn;
        private String taskDefinition;
        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private String launchType;
        private String platformVersion;
        private String platformFamily;
        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();
        private NetworkConfiguration networkConfiguration;
        private List<ContainerImage> containerImages = DefaultSdkAutoConstructList.getInstance();
        private Boolean guardDutyEnabled;
        private ServiceConnectConfiguration serviceConnectConfiguration;
        private List<ServiceVolumeConfiguration> volumeConfigurations = DefaultSdkAutoConstructList.getInstance();
        private DeploymentEphemeralStorage fargateEphemeralStorage;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceRevision model) {
            this.serviceRevisionArn(model.serviceRevisionArn);
            this.serviceArn(model.serviceArn);
            this.clusterArn(model.clusterArn);
            this.taskDefinition(model.taskDefinition);
            this.capacityProviderStrategy(model.capacityProviderStrategy);
            this.launchType(model.launchType);
            this.platformVersion(model.platformVersion);
            this.platformFamily(model.platformFamily);
            this.loadBalancers(model.loadBalancers);
            this.serviceRegistries(model.serviceRegistries);
            this.networkConfiguration(model.networkConfiguration);
            this.containerImages(model.containerImages);
            this.guardDutyEnabled(model.guardDutyEnabled);
            this.serviceConnectConfiguration(model.serviceConnectConfiguration);
            this.volumeConfigurations(model.volumeConfigurations);
            this.fargateEphemeralStorage(model.fargateEphemeralStorage);
            this.createdAt(model.createdAt);
        }

        public final String getServiceRevisionArn() {
            return this.serviceRevisionArn;
        }

        public final void setServiceRevisionArn(String serviceRevisionArn) {
            this.serviceRevisionArn = serviceRevisionArn;
        }

        @Override
        public final Builder serviceRevisionArn(String serviceRevisionArn) {
            this.serviceRevisionArn = serviceRevisionArn;
            return this;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final List<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier.copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Stream.of(capacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getPlatformFamily() {
            return this.platformFamily;
        }

        public final void setPlatformFamily(String platformFamily) {
            this.platformFamily = platformFamily;
        }

        @Override
        public final Builder platformFamily(String platformFamily) {
            this.platformFamily = platformFamily;
            return this;
        }

        public final List<LoadBalancer.Builder> getLoadBalancers() {
            List<LoadBalancer.Builder> result = LoadBalancersCopier.copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder> ... loadBalancers) {
            this.loadBalancers(Stream.of(loadBalancers).map(c -> (LoadBalancer)((LoadBalancer.Builder)LoadBalancer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceRegistry.Builder> getServiceRegistries() {
            List<ServiceRegistry.Builder> result = ServiceRegistriesCopier.copyToBuilder(this.serviceRegistries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry ... serviceRegistries) {
            this.serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... serviceRegistries) {
            this.serviceRegistries(Stream.of(serviceRegistries).map(c -> (ServiceRegistry)((ServiceRegistry.Builder)ServiceRegistry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final List<ContainerImage.Builder> getContainerImages() {
            List<ContainerImage.Builder> result = ContainerImagesCopier.copyToBuilder(this.containerImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerImages(Collection<ContainerImage.BuilderImpl> containerImages) {
            this.containerImages = ContainerImagesCopier.copyFromBuilder(containerImages);
        }

        @Override
        public final Builder containerImages(Collection<ContainerImage> containerImages) {
            this.containerImages = ContainerImagesCopier.copy(containerImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerImages(ContainerImage ... containerImages) {
            this.containerImages(Arrays.asList(containerImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerImages(Consumer<ContainerImage.Builder> ... containerImages) {
            this.containerImages(Stream.of(containerImages).map(c -> (ContainerImage)((ContainerImage.Builder)ContainerImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getGuardDutyEnabled() {
            return this.guardDutyEnabled;
        }

        public final void setGuardDutyEnabled(Boolean guardDutyEnabled) {
            this.guardDutyEnabled = guardDutyEnabled;
        }

        @Override
        public final Builder guardDutyEnabled(Boolean guardDutyEnabled) {
            this.guardDutyEnabled = guardDutyEnabled;
            return this;
        }

        public final ServiceConnectConfiguration.Builder getServiceConnectConfiguration() {
            return this.serviceConnectConfiguration != null ? this.serviceConnectConfiguration.toBuilder() : null;
        }

        public final void setServiceConnectConfiguration(ServiceConnectConfiguration.BuilderImpl serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration != null ? serviceConnectConfiguration.build() : null;
        }

        @Override
        public final Builder serviceConnectConfiguration(ServiceConnectConfiguration serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration;
            return this;
        }

        public final List<ServiceVolumeConfiguration.Builder> getVolumeConfigurations() {
            List<ServiceVolumeConfiguration.Builder> result = ServiceVolumeConfigurationsCopier.copyToBuilder(this.volumeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeConfigurations(Collection<ServiceVolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        @Override
        public final Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(ServiceVolumeConfiguration ... volumeConfigurations) {
            this.volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder> ... volumeConfigurations) {
            this.volumeConfigurations(Stream.of(volumeConfigurations).map(c -> (ServiceVolumeConfiguration)((ServiceVolumeConfiguration.Builder)ServiceVolumeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DeploymentEphemeralStorage.Builder getFargateEphemeralStorage() {
            return this.fargateEphemeralStorage != null ? this.fargateEphemeralStorage.toBuilder() : null;
        }

        public final void setFargateEphemeralStorage(DeploymentEphemeralStorage.BuilderImpl fargateEphemeralStorage) {
            this.fargateEphemeralStorage = fargateEphemeralStorage != null ? fargateEphemeralStorage.build() : null;
        }

        @Override
        public final Builder fargateEphemeralStorage(DeploymentEphemeralStorage fargateEphemeralStorage) {
            this.fargateEphemeralStorage = fargateEphemeralStorage;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public ServiceRevision build() {
            return new ServiceRevision(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceRevision> {
        public Builder serviceRevisionArn(String var1);

        public Builder serviceArn(String var1);

        public Builder clusterArn(String var1);

        public Builder taskDefinition(String var1);

        public Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder capacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder platformVersion(String var1);

        public Builder platformFamily(String var1);

        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder loadBalancers(Consumer<LoadBalancer.Builder> ... var1);

        public Builder serviceRegistries(Collection<ServiceRegistry> var1);

        public Builder serviceRegistries(ServiceRegistry ... var1);

        public Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder containerImages(Collection<ContainerImage> var1);

        public Builder containerImages(ContainerImage ... var1);

        public Builder containerImages(Consumer<ContainerImage.Builder> ... var1);

        public Builder guardDutyEnabled(Boolean var1);

        public Builder serviceConnectConfiguration(ServiceConnectConfiguration var1);

        default public Builder serviceConnectConfiguration(Consumer<ServiceConnectConfiguration.Builder> serviceConnectConfiguration) {
            return this.serviceConnectConfiguration((ServiceConnectConfiguration)((ServiceConnectConfiguration.Builder)ServiceConnectConfiguration.builder().applyMutation(serviceConnectConfiguration)).build());
        }

        public Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> var1);

        public Builder volumeConfigurations(ServiceVolumeConfiguration ... var1);

        public Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder> ... var1);

        public Builder fargateEphemeralStorage(DeploymentEphemeralStorage var1);

        default public Builder fargateEphemeralStorage(Consumer<DeploymentEphemeralStorage.Builder> fargateEphemeralStorage) {
            return this.fargateEphemeralStorage((DeploymentEphemeralStorage)((DeploymentEphemeralStorage.Builder)DeploymentEphemeralStorage.builder().applyMutation(fargateEphemeralStorage)).build());
        }

        public Builder createdAt(Instant var1);
    }
}

