/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentRollbackMonitorsStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceDeploymentCircuitBreaker
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceDeploymentCircuitBreaker> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServiceDeploymentCircuitBreaker.getter(ServiceDeploymentCircuitBreaker::statusAsString)).setter(ServiceDeploymentCircuitBreaker.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> FAILURE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failureCount").getter(ServiceDeploymentCircuitBreaker.getter(ServiceDeploymentCircuitBreaker::failureCount)).setter(ServiceDeploymentCircuitBreaker.setter(Builder::failureCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCount").build()}).build();
    private static final SdkField<Integer> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("threshold").getter(ServiceDeploymentCircuitBreaker.getter(ServiceDeploymentCircuitBreaker::threshold)).setter(ServiceDeploymentCircuitBreaker.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FAILURE_COUNT_FIELD, THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceDeploymentCircuitBreaker.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Integer failureCount;
    private final Integer threshold;

    private ServiceDeploymentCircuitBreaker(BuilderImpl builder) {
        this.status = builder.status;
        this.failureCount = builder.failureCount;
        this.threshold = builder.threshold;
    }

    public final ServiceDeploymentRollbackMonitorsStatus status() {
        return ServiceDeploymentRollbackMonitorsStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer failureCount() {
        return this.failureCount;
    }

    public final Integer threshold() {
        return this.threshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDeploymentCircuitBreaker)) {
            return false;
        }
        ServiceDeploymentCircuitBreaker other = (ServiceDeploymentCircuitBreaker)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureCount(), other.failureCount()) && Objects.equals(this.threshold(), other.threshold());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceDeploymentCircuitBreaker").add("Status", (Object)this.statusAsString()).add("FailureCount", (Object)this.failureCount()).add("Threshold", (Object)this.threshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureCount": {
                return Optional.ofNullable(clazz.cast(this.failureCount()));
            }
            case "threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("failureCount", FAILURE_COUNT_FIELD);
        map.put("threshold", THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceDeploymentCircuitBreaker, T> g) {
        return obj -> g.apply((ServiceDeploymentCircuitBreaker)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Integer failureCount;
        private Integer threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDeploymentCircuitBreaker model) {
            this.status(model.status);
            this.failureCount(model.failureCount);
            this.threshold(model.threshold);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceDeploymentRollbackMonitorsStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getFailureCount() {
            return this.failureCount;
        }

        public final void setFailureCount(Integer failureCount) {
            this.failureCount = failureCount;
        }

        @Override
        public final Builder failureCount(Integer failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        public final Integer getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Integer threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Integer threshold) {
            this.threshold = threshold;
            return this;
        }

        public ServiceDeploymentCircuitBreaker build() {
            return new ServiceDeploymentCircuitBreaker(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceDeploymentCircuitBreaker> {
        public Builder status(String var1);

        public Builder status(ServiceDeploymentRollbackMonitorsStatus var1);

        public Builder failureCount(Integer var1);

        public Builder threshold(Integer var1);
    }
}

