/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.DeploymentEphemeralStorage;
import software.amazon.awssdk.services.ecs.model.DeploymentRolloutState;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.ServiceConnectConfiguration;
import software.amazon.awssdk.services.ecs.model.ServiceConnectServiceResource;
import software.amazon.awssdk.services.ecs.model.ServiceConnectServiceResourceListCopier;
import software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration;
import software.amazon.awssdk.services.ecs.model.ServiceVolumeConfigurationsCopier;
import software.amazon.awssdk.services.ecs.model.VpcLatticeConfiguration;
import software.amazon.awssdk.services.ecs.model.VpcLatticeConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Deployment> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Deployment.getter(Deployment::id)).setter(Deployment.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Deployment.getter(Deployment::status)).setter(Deployment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskDefinition").getter(Deployment.getter(Deployment::taskDefinition)).setter(Deployment.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredCount").getter(Deployment.getter(Deployment::desiredCount)).setter(Deployment.setter(Builder::desiredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()}).build();
    private static final SdkField<Integer> PENDING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("pendingCount").getter(Deployment.getter(Deployment::pendingCount)).setter(Deployment.setter(Builder::pendingCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingCount").build()}).build();
    private static final SdkField<Integer> RUNNING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("runningCount").getter(Deployment.getter(Deployment::runningCount)).setter(Deployment.setter(Builder::runningCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningCount").build()}).build();
    private static final SdkField<Integer> FAILED_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failedTasks").getter(Deployment.getter(Deployment::failedTasks)).setter(Deployment.setter(Builder::failedTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedTasks").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Deployment.getter(Deployment::createdAt)).setter(Deployment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Deployment.getter(Deployment::updatedAt)).setter(Deployment.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityProviderStrategy").getter(Deployment.getter(Deployment::capacityProviderStrategy)).setter(Deployment.setter(Builder::capacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchType").getter(Deployment.getter(Deployment::launchTypeAsString)).setter(Deployment.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformVersion").getter(Deployment.getter(Deployment::platformVersion)).setter(Deployment.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<String> PLATFORM_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformFamily").getter(Deployment.getter(Deployment::platformFamily)).setter(Deployment.setter(Builder::platformFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformFamily").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(Deployment.getter(Deployment::networkConfiguration)).setter(Deployment.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<String> ROLLOUT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rolloutState").getter(Deployment.getter(Deployment::rolloutStateAsString)).setter(Deployment.setter(Builder::rolloutState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rolloutState").build()}).build();
    private static final SdkField<String> ROLLOUT_STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rolloutStateReason").getter(Deployment.getter(Deployment::rolloutStateReason)).setter(Deployment.setter(Builder::rolloutStateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rolloutStateReason").build()}).build();
    private static final SdkField<ServiceConnectConfiguration> SERVICE_CONNECT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceConnectConfiguration").getter(Deployment.getter(Deployment::serviceConnectConfiguration)).setter(Deployment.setter(Builder::serviceConnectConfiguration)).constructor(ServiceConnectConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConnectConfiguration").build()}).build();
    private static final SdkField<List<ServiceConnectServiceResource>> SERVICE_CONNECT_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceConnectResources").getter(Deployment.getter(Deployment::serviceConnectResources)).setter(Deployment.setter(Builder::serviceConnectResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConnectResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceConnectServiceResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceVolumeConfiguration>> VOLUME_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumeConfigurations").getter(Deployment.getter(Deployment::volumeConfigurations)).setter(Deployment.setter(Builder::volumeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DeploymentEphemeralStorage> FARGATE_EPHEMERAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fargateEphemeralStorage").getter(Deployment.getter(Deployment::fargateEphemeralStorage)).setter(Deployment.setter(Builder::fargateEphemeralStorage)).constructor(DeploymentEphemeralStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateEphemeralStorage").build()}).build();
    private static final SdkField<List<VpcLatticeConfiguration>> VPC_LATTICE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcLatticeConfigurations").getter(Deployment.getter(Deployment::vpcLatticeConfigurations)).setter(Deployment.setter(Builder::vpcLatticeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLatticeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcLatticeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD, TASK_DEFINITION_FIELD, DESIRED_COUNT_FIELD, PENDING_COUNT_FIELD, RUNNING_COUNT_FIELD, FAILED_TASKS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, LAUNCH_TYPE_FIELD, PLATFORM_VERSION_FIELD, PLATFORM_FAMILY_FIELD, NETWORK_CONFIGURATION_FIELD, ROLLOUT_STATE_FIELD, ROLLOUT_STATE_REASON_FIELD, SERVICE_CONNECT_CONFIGURATION_FIELD, SERVICE_CONNECT_RESOURCES_FIELD, VOLUME_CONFIGURATIONS_FIELD, FARGATE_EPHEMERAL_STORAGE_FIELD, VPC_LATTICE_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Deployment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String status;
    private final String taskDefinition;
    private final Integer desiredCount;
    private final Integer pendingCount;
    private final Integer runningCount;
    private final Integer failedTasks;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;
    private final String launchType;
    private final String platformVersion;
    private final String platformFamily;
    private final NetworkConfiguration networkConfiguration;
    private final String rolloutState;
    private final String rolloutStateReason;
    private final ServiceConnectConfiguration serviceConnectConfiguration;
    private final List<ServiceConnectServiceResource> serviceConnectResources;
    private final List<ServiceVolumeConfiguration> volumeConfigurations;
    private final DeploymentEphemeralStorage fargateEphemeralStorage;
    private final List<VpcLatticeConfiguration> vpcLatticeConfigurations;

    private Deployment(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.taskDefinition = builder.taskDefinition;
        this.desiredCount = builder.desiredCount;
        this.pendingCount = builder.pendingCount;
        this.runningCount = builder.runningCount;
        this.failedTasks = builder.failedTasks;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.launchType = builder.launchType;
        this.platformVersion = builder.platformVersion;
        this.platformFamily = builder.platformFamily;
        this.networkConfiguration = builder.networkConfiguration;
        this.rolloutState = builder.rolloutState;
        this.rolloutStateReason = builder.rolloutStateReason;
        this.serviceConnectConfiguration = builder.serviceConnectConfiguration;
        this.serviceConnectResources = builder.serviceConnectResources;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.fargateEphemeralStorage = builder.fargateEphemeralStorage;
        this.vpcLatticeConfigurations = builder.vpcLatticeConfigurations;
    }

    public final String id() {
        return this.id;
    }

    public final String status() {
        return this.status;
    }

    public final String taskDefinition() {
        return this.taskDefinition;
    }

    public final Integer desiredCount() {
        return this.desiredCount;
    }

    public final Integer pendingCount() {
        return this.pendingCount;
    }

    public final Integer runningCount() {
        return this.runningCount;
    }

    public final Integer failedTasks() {
        return this.failedTasks;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasCapacityProviderStrategy() {
        return this.capacityProviderStrategy != null && !(this.capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return this.capacityProviderStrategy;
    }

    public final LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public final String launchTypeAsString() {
        return this.launchType;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final String platformFamily() {
        return this.platformFamily;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final DeploymentRolloutState rolloutState() {
        return DeploymentRolloutState.fromValue(this.rolloutState);
    }

    public final String rolloutStateAsString() {
        return this.rolloutState;
    }

    public final String rolloutStateReason() {
        return this.rolloutStateReason;
    }

    public final ServiceConnectConfiguration serviceConnectConfiguration() {
        return this.serviceConnectConfiguration;
    }

    public final boolean hasServiceConnectResources() {
        return this.serviceConnectResources != null && !(this.serviceConnectResources instanceof SdkAutoConstructList);
    }

    public final List<ServiceConnectServiceResource> serviceConnectResources() {
        return this.serviceConnectResources;
    }

    public final boolean hasVolumeConfigurations() {
        return this.volumeConfigurations != null && !(this.volumeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ServiceVolumeConfiguration> volumeConfigurations() {
        return this.volumeConfigurations;
    }

    public final DeploymentEphemeralStorage fargateEphemeralStorage() {
        return this.fargateEphemeralStorage;
    }

    public final boolean hasVpcLatticeConfigurations() {
        return this.vpcLatticeConfigurations != null && !(this.vpcLatticeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<VpcLatticeConfiguration> vpcLatticeConfigurations() {
        return this.vpcLatticeConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedTasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolloutStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolloutStateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceConnectConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceConnectResources() ? this.serviceConnectResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeConfigurations() ? this.volumeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fargateEphemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcLatticeConfigurations() ? this.vpcLatticeConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.desiredCount(), other.desiredCount()) && Objects.equals(this.pendingCount(), other.pendingCount()) && Objects.equals(this.runningCount(), other.runningCount()) && Objects.equals(this.failedTasks(), other.failedTasks()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy() && Objects.equals(this.capacityProviderStrategy(), other.capacityProviderStrategy()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.platformFamily(), other.platformFamily()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.rolloutStateAsString(), other.rolloutStateAsString()) && Objects.equals(this.rolloutStateReason(), other.rolloutStateReason()) && Objects.equals(this.serviceConnectConfiguration(), other.serviceConnectConfiguration()) && this.hasServiceConnectResources() == other.hasServiceConnectResources() && Objects.equals(this.serviceConnectResources(), other.serviceConnectResources()) && this.hasVolumeConfigurations() == other.hasVolumeConfigurations() && Objects.equals(this.volumeConfigurations(), other.volumeConfigurations()) && Objects.equals(this.fargateEphemeralStorage(), other.fargateEphemeralStorage()) && this.hasVpcLatticeConfigurations() == other.hasVpcLatticeConfigurations() && Objects.equals(this.vpcLatticeConfigurations(), other.vpcLatticeConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"Deployment").add("Id", (Object)this.id()).add("Status", (Object)this.status()).add("TaskDefinition", (Object)this.taskDefinition()).add("DesiredCount", (Object)this.desiredCount()).add("PendingCount", (Object)this.pendingCount()).add("RunningCount", (Object)this.runningCount()).add("FailedTasks", (Object)this.failedTasks()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("CapacityProviderStrategy", this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null).add("LaunchType", (Object)this.launchTypeAsString()).add("PlatformVersion", (Object)this.platformVersion()).add("PlatformFamily", (Object)this.platformFamily()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("RolloutState", (Object)this.rolloutStateAsString()).add("RolloutStateReason", (Object)this.rolloutStateReason()).add("ServiceConnectConfiguration", (Object)this.serviceConnectConfiguration()).add("ServiceConnectResources", this.hasServiceConnectResources() ? this.serviceConnectResources() : null).add("VolumeConfigurations", this.hasVolumeConfigurations() ? this.volumeConfigurations() : null).add("FargateEphemeralStorage", (Object)this.fargateEphemeralStorage()).add("VpcLatticeConfigurations", this.hasVpcLatticeConfigurations() ? this.vpcLatticeConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "desiredCount": {
                return Optional.ofNullable(clazz.cast(this.desiredCount()));
            }
            case "pendingCount": {
                return Optional.ofNullable(clazz.cast(this.pendingCount()));
            }
            case "runningCount": {
                return Optional.ofNullable(clazz.cast(this.runningCount()));
            }
            case "failedTasks": {
                return Optional.ofNullable(clazz.cast(this.failedTasks()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "capacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderStrategy()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "platformFamily": {
                return Optional.ofNullable(clazz.cast(this.platformFamily()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "rolloutState": {
                return Optional.ofNullable(clazz.cast(this.rolloutStateAsString()));
            }
            case "rolloutStateReason": {
                return Optional.ofNullable(clazz.cast(this.rolloutStateReason()));
            }
            case "serviceConnectConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serviceConnectConfiguration()));
            }
            case "serviceConnectResources": {
                return Optional.ofNullable(clazz.cast(this.serviceConnectResources()));
            }
            case "volumeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.volumeConfigurations()));
            }
            case "fargateEphemeralStorage": {
                return Optional.ofNullable(clazz.cast(this.fargateEphemeralStorage()));
            }
            case "vpcLatticeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.vpcLatticeConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("taskDefinition", TASK_DEFINITION_FIELD);
        map.put("desiredCount", DESIRED_COUNT_FIELD);
        map.put("pendingCount", PENDING_COUNT_FIELD);
        map.put("runningCount", RUNNING_COUNT_FIELD);
        map.put("failedTasks", FAILED_TASKS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("capacityProviderStrategy", CAPACITY_PROVIDER_STRATEGY_FIELD);
        map.put("launchType", LAUNCH_TYPE_FIELD);
        map.put("platformVersion", PLATFORM_VERSION_FIELD);
        map.put("platformFamily", PLATFORM_FAMILY_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("rolloutState", ROLLOUT_STATE_FIELD);
        map.put("rolloutStateReason", ROLLOUT_STATE_REASON_FIELD);
        map.put("serviceConnectConfiguration", SERVICE_CONNECT_CONFIGURATION_FIELD);
        map.put("serviceConnectResources", SERVICE_CONNECT_RESOURCES_FIELD);
        map.put("volumeConfigurations", VOLUME_CONFIGURATIONS_FIELD);
        map.put("fargateEphemeralStorage", FARGATE_EPHEMERAL_STORAGE_FIELD);
        map.put("vpcLatticeConfigurations", VPC_LATTICE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String status;
        private String taskDefinition;
        private Integer desiredCount;
        private Integer pendingCount;
        private Integer runningCount;
        private Integer failedTasks;
        private Instant createdAt;
        private Instant updatedAt;
        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private String launchType;
        private String platformVersion;
        private String platformFamily;
        private NetworkConfiguration networkConfiguration;
        private String rolloutState;
        private String rolloutStateReason;
        private ServiceConnectConfiguration serviceConnectConfiguration;
        private List<ServiceConnectServiceResource> serviceConnectResources = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceVolumeConfiguration> volumeConfigurations = DefaultSdkAutoConstructList.getInstance();
        private DeploymentEphemeralStorage fargateEphemeralStorage;
        private List<VpcLatticeConfiguration> vpcLatticeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            this.id(model.id);
            this.status(model.status);
            this.taskDefinition(model.taskDefinition);
            this.desiredCount(model.desiredCount);
            this.pendingCount(model.pendingCount);
            this.runningCount(model.runningCount);
            this.failedTasks(model.failedTasks);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.capacityProviderStrategy(model.capacityProviderStrategy);
            this.launchType(model.launchType);
            this.platformVersion(model.platformVersion);
            this.platformFamily(model.platformFamily);
            this.networkConfiguration(model.networkConfiguration);
            this.rolloutState(model.rolloutState);
            this.rolloutStateReason(model.rolloutStateReason);
            this.serviceConnectConfiguration(model.serviceConnectConfiguration);
            this.serviceConnectResources(model.serviceConnectResources);
            this.volumeConfigurations(model.volumeConfigurations);
            this.fargateEphemeralStorage(model.fargateEphemeralStorage);
            this.vpcLatticeConfigurations(model.vpcLatticeConfigurations);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final Integer getDesiredCount() {
            return this.desiredCount;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final Integer getPendingCount() {
            return this.pendingCount;
        }

        public final void setPendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
        }

        @Override
        public final Builder pendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
            return this;
        }

        public final Integer getRunningCount() {
            return this.runningCount;
        }

        public final void setRunningCount(Integer runningCount) {
            this.runningCount = runningCount;
        }

        @Override
        public final Builder runningCount(Integer runningCount) {
            this.runningCount = runningCount;
            return this;
        }

        public final Integer getFailedTasks() {
            return this.failedTasks;
        }

        public final void setFailedTasks(Integer failedTasks) {
            this.failedTasks = failedTasks;
        }

        @Override
        public final Builder failedTasks(Integer failedTasks) {
            this.failedTasks = failedTasks;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier.copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Stream.of(capacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getPlatformFamily() {
            return this.platformFamily;
        }

        public final void setPlatformFamily(String platformFamily) {
            this.platformFamily = platformFamily;
        }

        @Override
        public final Builder platformFamily(String platformFamily) {
            this.platformFamily = platformFamily;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getRolloutState() {
            return this.rolloutState;
        }

        public final void setRolloutState(String rolloutState) {
            this.rolloutState = rolloutState;
        }

        @Override
        public final Builder rolloutState(String rolloutState) {
            this.rolloutState = rolloutState;
            return this;
        }

        @Override
        public final Builder rolloutState(DeploymentRolloutState rolloutState) {
            this.rolloutState(rolloutState == null ? null : rolloutState.toString());
            return this;
        }

        public final String getRolloutStateReason() {
            return this.rolloutStateReason;
        }

        public final void setRolloutStateReason(String rolloutStateReason) {
            this.rolloutStateReason = rolloutStateReason;
        }

        @Override
        public final Builder rolloutStateReason(String rolloutStateReason) {
            this.rolloutStateReason = rolloutStateReason;
            return this;
        }

        public final ServiceConnectConfiguration.Builder getServiceConnectConfiguration() {
            return this.serviceConnectConfiguration != null ? this.serviceConnectConfiguration.toBuilder() : null;
        }

        public final void setServiceConnectConfiguration(ServiceConnectConfiguration.BuilderImpl serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration != null ? serviceConnectConfiguration.build() : null;
        }

        @Override
        public final Builder serviceConnectConfiguration(ServiceConnectConfiguration serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration;
            return this;
        }

        public final List<ServiceConnectServiceResource.Builder> getServiceConnectResources() {
            List<ServiceConnectServiceResource.Builder> result = ServiceConnectServiceResourceListCopier.copyToBuilder(this.serviceConnectResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceConnectResources(Collection<ServiceConnectServiceResource.BuilderImpl> serviceConnectResources) {
            this.serviceConnectResources = ServiceConnectServiceResourceListCopier.copyFromBuilder(serviceConnectResources);
        }

        @Override
        public final Builder serviceConnectResources(Collection<ServiceConnectServiceResource> serviceConnectResources) {
            this.serviceConnectResources = ServiceConnectServiceResourceListCopier.copy(serviceConnectResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceConnectResources(ServiceConnectServiceResource ... serviceConnectResources) {
            this.serviceConnectResources(Arrays.asList(serviceConnectResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceConnectResources(Consumer<ServiceConnectServiceResource.Builder> ... serviceConnectResources) {
            this.serviceConnectResources(Stream.of(serviceConnectResources).map(c -> (ServiceConnectServiceResource)((ServiceConnectServiceResource.Builder)ServiceConnectServiceResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceVolumeConfiguration.Builder> getVolumeConfigurations() {
            List<ServiceVolumeConfiguration.Builder> result = ServiceVolumeConfigurationsCopier.copyToBuilder(this.volumeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeConfigurations(Collection<ServiceVolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        @Override
        public final Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(ServiceVolumeConfiguration ... volumeConfigurations) {
            this.volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder> ... volumeConfigurations) {
            this.volumeConfigurations(Stream.of(volumeConfigurations).map(c -> (ServiceVolumeConfiguration)((ServiceVolumeConfiguration.Builder)ServiceVolumeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DeploymentEphemeralStorage.Builder getFargateEphemeralStorage() {
            return this.fargateEphemeralStorage != null ? this.fargateEphemeralStorage.toBuilder() : null;
        }

        public final void setFargateEphemeralStorage(DeploymentEphemeralStorage.BuilderImpl fargateEphemeralStorage) {
            this.fargateEphemeralStorage = fargateEphemeralStorage != null ? fargateEphemeralStorage.build() : null;
        }

        @Override
        public final Builder fargateEphemeralStorage(DeploymentEphemeralStorage fargateEphemeralStorage) {
            this.fargateEphemeralStorage = fargateEphemeralStorage;
            return this;
        }

        public final List<VpcLatticeConfiguration.Builder> getVpcLatticeConfigurations() {
            List<VpcLatticeConfiguration.Builder> result = VpcLatticeConfigurationsCopier.copyToBuilder(this.vpcLatticeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcLatticeConfigurations(Collection<VpcLatticeConfiguration.BuilderImpl> vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations = VpcLatticeConfigurationsCopier.copyFromBuilder(vpcLatticeConfigurations);
        }

        @Override
        public final Builder vpcLatticeConfigurations(Collection<VpcLatticeConfiguration> vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations = VpcLatticeConfigurationsCopier.copy(vpcLatticeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcLatticeConfigurations(VpcLatticeConfiguration ... vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations(Arrays.asList(vpcLatticeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcLatticeConfigurations(Consumer<VpcLatticeConfiguration.Builder> ... vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations(Stream.of(vpcLatticeConfigurations).map(c -> (VpcLatticeConfiguration)((VpcLatticeConfiguration.Builder)VpcLatticeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Deployment build() {
            return new Deployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Deployment> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder taskDefinition(String var1);

        public Builder desiredCount(Integer var1);

        public Builder pendingCount(Integer var1);

        public Builder runningCount(Integer var1);

        public Builder failedTasks(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder capacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder platformVersion(String var1);

        public Builder platformFamily(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder rolloutState(String var1);

        public Builder rolloutState(DeploymentRolloutState var1);

        public Builder rolloutStateReason(String var1);

        public Builder serviceConnectConfiguration(ServiceConnectConfiguration var1);

        default public Builder serviceConnectConfiguration(Consumer<ServiceConnectConfiguration.Builder> serviceConnectConfiguration) {
            return this.serviceConnectConfiguration((ServiceConnectConfiguration)((ServiceConnectConfiguration.Builder)ServiceConnectConfiguration.builder().applyMutation(serviceConnectConfiguration)).build());
        }

        public Builder serviceConnectResources(Collection<ServiceConnectServiceResource> var1);

        public Builder serviceConnectResources(ServiceConnectServiceResource ... var1);

        public Builder serviceConnectResources(Consumer<ServiceConnectServiceResource.Builder> ... var1);

        public Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> var1);

        public Builder volumeConfigurations(ServiceVolumeConfiguration ... var1);

        public Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder> ... var1);

        public Builder fargateEphemeralStorage(DeploymentEphemeralStorage var1);

        default public Builder fargateEphemeralStorage(Consumer<DeploymentEphemeralStorage.Builder> fargateEphemeralStorage) {
            return this.fargateEphemeralStorage((DeploymentEphemeralStorage)((DeploymentEphemeralStorage.Builder)DeploymentEphemeralStorage.builder().applyMutation(fargateEphemeralStorage)).build());
        }

        public Builder vpcLatticeConfigurations(Collection<VpcLatticeConfiguration> var1);

        public Builder vpcLatticeConfigurations(VpcLatticeConfiguration ... var1);

        public Builder vpcLatticeConfigurations(Consumer<VpcLatticeConfiguration.Builder> ... var1);
    }
}

