/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ManagedAgentName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedAgentStateChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedAgentStateChange> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerName").getter(ManagedAgentStateChange.getter(ManagedAgentStateChange::containerName)).setter(ManagedAgentStateChange.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<String> MANAGED_AGENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedAgentName").getter(ManagedAgentStateChange.getter(ManagedAgentStateChange::managedAgentNameAsString)).setter(ManagedAgentStateChange.setter(Builder::managedAgentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedAgentName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ManagedAgentStateChange.getter(ManagedAgentStateChange::status)).setter(ManagedAgentStateChange.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(ManagedAgentStateChange.getter(ManagedAgentStateChange::reason)).setter(ManagedAgentStateChange.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, MANAGED_AGENT_NAME_FIELD, STATUS_FIELD, REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerName;
    private final String managedAgentName;
    private final String status;
    private final String reason;

    private ManagedAgentStateChange(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.managedAgentName = builder.managedAgentName;
        this.status = builder.status;
        this.reason = builder.reason;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final ManagedAgentName managedAgentName() {
        return ManagedAgentName.fromValue(this.managedAgentName);
    }

    public final String managedAgentNameAsString() {
        return this.managedAgentName;
    }

    public final String status() {
        return this.status;
    }

    public final String reason() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedAgentNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedAgentStateChange)) {
            return false;
        }
        ManagedAgentStateChange other = (ManagedAgentStateChange)obj;
        return Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.managedAgentNameAsString(), other.managedAgentNameAsString()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.reason(), other.reason());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedAgentStateChange").add("ContainerName", (Object)this.containerName()).add("ManagedAgentName", (Object)this.managedAgentNameAsString()).add("Status", (Object)this.status()).add("Reason", (Object)this.reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "managedAgentName": {
                return Optional.ofNullable(clazz.cast(this.managedAgentNameAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedAgentStateChange, T> g) {
        return obj -> g.apply((ManagedAgentStateChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerName;
        private String managedAgentName;
        private String status;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedAgentStateChange model) {
            this.containerName(model.containerName);
            this.managedAgentName(model.managedAgentName);
            this.status(model.status);
            this.reason(model.reason);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final String getManagedAgentName() {
            return this.managedAgentName;
        }

        public final void setManagedAgentName(String managedAgentName) {
            this.managedAgentName = managedAgentName;
        }

        @Override
        public final Builder managedAgentName(String managedAgentName) {
            this.managedAgentName = managedAgentName;
            return this;
        }

        @Override
        public final Builder managedAgentName(ManagedAgentName managedAgentName) {
            this.managedAgentName(managedAgentName == null ? null : managedAgentName.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public ManagedAgentStateChange build() {
            return new ManagedAgentStateChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedAgentStateChange> {
        public Builder containerName(String var1);

        public Builder managedAgentName(String var1);

        public Builder managedAgentName(ManagedAgentName var1);

        public Builder status(String var1);

        public Builder reason(String var1);
    }
}

